/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.block;

import com.teamabnormals.upgrade_aquatic.core.registry.UABlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TallBeachgrassBlock
extends DoublePlantBlock
implements BonemealableBlock {
    private static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);

    public TallBeachgrassBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.is(BlockTags.SAND);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        if (state.getValue((Property)HALF) != DoubleBlockHalf.UPPER) {
            return this.mayPlaceOn(level.getBlockState(pos.below()), (BlockGetter)level, pos.below());
        }
        BlockState lower = level.getBlockState(pos.below());
        return lower.is((Block)this) && lower.getValue((Property)HALF) == DoubleBlockHalf.LOWER;
    }

    public VoxelShape getShape(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return SHAPE;
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        if (!worldIn.isClientSide) {
            block0: for (int i = 0; i < 128; ++i) {
                BlockPos blockpos = pos;
                for (int j = 0; j < i / 16; ++j) {
                    if (Block.isShapeFullBlock((VoxelShape)worldIn.getBlockState(blockpos = blockpos.offset(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1)).getCollisionShape((BlockGetter)worldIn, blockpos))) continue block0;
                }
                BlockState blockstate = ((Block)UABlocks.BEACHGRASS.get()).defaultBlockState();
                if (!blockstate.canSurvive((LevelReader)worldIn, blockpos) || !worldIn.isEmptyBlock(blockpos) || !(rand.nextFloat() <= 0.1f)) continue;
                worldIn.setBlockAndUpdate(blockpos, blockstate);
            }
        }
    }
}

