/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.block;

import com.teamabnormals.upgrade_aquatic.core.registry.UACriteriaTriggers;
import com.teamabnormals.upgrade_aquatic.core.registry.UAItems;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.IShearable;
import net.neoforged.neoforge.common.ItemAbilities;

public class MulberryVineBlock
extends Block
implements IShearable,
BonemealableBlock {
    protected static final VoxelShape SHAPE = Block.box((double)5.0, (double)4.0, (double)5.0, (double)13.0, (double)16.0, (double)13.0);
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)4);
    public static final BooleanProperty DOUBLE = BooleanProperty.create((String)"double");

    public MulberryVineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)DOUBLE, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE, DOUBLE});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Vec3 vec3 = state.getOffset(level, pos);
        return SHAPE.move(vec3.x, vec3.y, vec3.z);
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return useContext.getItemInHand().getItem() == this.asItem() && (Boolean)state.getValue((Property)DOUBLE) == false && (Integer)state.getValue((Property)AGE) < 2 || super.canBeReplaced(state, useContext);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState offsetState, LevelAccessor level, BlockPos pos, BlockPos offsetPos) {
        return direction == Direction.UP && !this.canSurvive(state, (LevelReader)level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, offsetState, level, pos, offsetPos);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState aboveState = level.getBlockState(pos.above());
        return (aboveState.is(BlockTags.LOGS) || aboveState.is(BlockTags.LEAVES)) && !level.isWaterAt(pos);
    }

    public boolean isValidBonemealTarget(LevelReader arg0, BlockPos arg1, BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 4;
    }

    public boolean isBonemealSuccess(Level arg0, RandomSource arg1, BlockPos arg2, BlockState state) {
        return true;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if ((Integer)state.getValue((Property)AGE) == 4) {
            MulberryVineBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)UAItems.MULBERRY.get(), (Boolean)state.getValue((Property)DOUBLE) != false ? 2 : 1));
            level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            BlockState newState = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(1));
            level.setBlock(pos, newState, 2);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)newState));
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ((PlayerTrigger)UACriteriaTriggers.PICK_MULBERRIES.get()).trigger(serverPlayer);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useWithoutItem(state, level, pos, player, hit);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack itemStack = player.getItemInHand(hand);
        if ((Integer)state.getValue((Property)AGE) != 4 && itemStack.is(Items.BONE_MEAL)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (itemStack.canPerformAction(ItemAbilities.SHEARS_HARVEST) && ((Boolean)state.getValue((Property)DOUBLE)).booleanValue()) {
            itemStack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            level.playSound(null, pos, SoundEvents.SHEEP_SHEAR, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            if ((Integer)state.getValue((Property)AGE) == 4) {
                MulberryVineBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)UAItems.MULBERRY.get(), 1));
            }
            BlockState newState = (BlockState)state.setValue((Property)DOUBLE, (Comparable)Boolean.valueOf(false));
            level.setBlock(pos, newState, 2);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)newState));
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public void performBonemeal(ServerLevel level, RandomSource rand, BlockPos pos, BlockState state) {
        level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(Math.min(4, (Integer)state.getValue((Property)AGE) + 1))), 2);
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 4;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        super.randomTick(state, level, pos, rand);
        int i = (Integer)state.getValue((Property)AGE);
        if (i < 4 && level.getRawBrightness(pos.above(), 0) >= 7 && CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (rand.nextInt(5) == 0 ? 1 : 0) != 0)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        BlockPos blockpos;
        BlockState blockstate;
        if (!(!level.isRainingAt(pos.above()) || rand.nextInt(15) != 1 || (blockstate = level.getBlockState(blockpos = pos.below())).canOcclude() && blockstate.isFaceSturdy((BlockGetter)level, blockpos, Direction.UP))) {
            double d0 = (float)pos.getX() + rand.nextFloat();
            double d1 = (double)pos.getY() - 0.05;
            double d2 = (float)pos.getZ() + rand.nextFloat();
            level.addParticle((ParticleOptions)ParticleTypes.DRIPPING_WATER, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = context.getLevel().getBlockState(context.getClickedPos());
        if (state.getBlock() == this && !((Boolean)state.getValue((Property)DOUBLE)).booleanValue() && (Integer)state.getValue((Property)AGE) < 2) {
            return (BlockState)state.setValue((Property)DOUBLE, (Comparable)Boolean.valueOf(true));
        }
        return super.getStateForPlacement(context);
    }
}

