/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.block;

import com.teamabnormals.upgrade_aquatic.core.registry.UABlocks;
import com.teamabnormals.upgrade_aquatic.core.registry.UAParticleTypes;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class JellyTorchBlock
extends TorchBlock
implements SimpleWaterloggedBlock {
    private final JellyTorchType torchType;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public JellyTorchBlock(BlockBehaviour.Properties props, JellyTorchType torchType) {
        super(null, props);
        this.torchType = torchType;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        double xOffset = rand.nextBoolean() ? -(Math.random() * 0.1) : Math.random() * 0.1;
        double yOffset = rand.nextBoolean() ? -(Math.random() * 0.1) : Math.random() * 0.1;
        double zOffset = rand.nextBoolean() ? -(Math.random() * 0.1) : Math.random() * 0.1;
        double d0 = (double)pos.getX() + 0.5 + xOffset;
        double d1 = (double)pos.getY() + 0.5 + yOffset;
        double d2 = (double)pos.getZ() + 0.5 + zOffset;
        world.addParticle((ParticleOptions)JellyTorchType.getTorchParticleType(this.torchType), d0, d1, d2, 0.0, 0.0, 0.0);
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED});
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        return super.updateShape(stateIn, facing, stateIn, worldIn, currentPos, facingPos);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState ifluidstate = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)super.getStateForPlacement(context).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public static enum JellyTorchType {
        PINK(ChatFormatting.LIGHT_PURPLE, () -> (Block)UABlocks.PINK_JELLY_TORCH.get()),
        PURPLE(ChatFormatting.DARK_PURPLE, () -> (Block)UABlocks.PURPLE_JELLY_TORCH.get()),
        BLUE(ChatFormatting.BLUE, () -> (Block)UABlocks.BLUE_JELLY_TORCH.get()),
        GREEN(ChatFormatting.GREEN, () -> (Block)UABlocks.GREEN_JELLY_TORCH.get()),
        YELLOW(ChatFormatting.YELLOW, () -> (Block)UABlocks.YELLOW_JELLY_TORCH.get()),
        ORANGE(ChatFormatting.GOLD, () -> (Block)UABlocks.ORANGE_JELLY_TORCH.get()),
        RED(ChatFormatting.RED, () -> (Block)UABlocks.RED_JELLY_TORCH.get()),
        WHITE(ChatFormatting.WHITE, () -> (Block)UABlocks.WHITE_JELLY_TORCH.get());

        public final ChatFormatting color;
        public final Supplier<Block> torch;
        private static final JellyTorchType[] VALUES;

        private JellyTorchType(ChatFormatting color, Supplier<Block> torch) {
            this.color = color;
            this.torch = torch;
        }

        public static JellyTorchType getByOrdinal(int ordinal) {
            return VALUES[ordinal];
        }

        public static SimpleParticleType getTorchParticleType(JellyTorchType type) {
            return switch (type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> (SimpleParticleType)UAParticleTypes.PINK_JELLY_FLAME.get();
                case 1 -> (SimpleParticleType)UAParticleTypes.PURPLE_JELLY_FLAME.get();
                case 2 -> (SimpleParticleType)UAParticleTypes.BLUE_JELLY_FLAME.get();
                case 3 -> (SimpleParticleType)UAParticleTypes.GREEN_JELLY_FLAME.get();
                case 4 -> (SimpleParticleType)UAParticleTypes.YELLOW_JELLY_FLAME.get();
                case 5 -> (SimpleParticleType)UAParticleTypes.ORANGE_JELLY_FLAME.get();
                case 6 -> (SimpleParticleType)UAParticleTypes.RED_JELLY_FLAME.get();
                case 7 -> (SimpleParticleType)UAParticleTypes.WHITE_JELLY_FLAME.get();
            };
        }

        public static SimpleParticleType getBlobParticleType(JellyTorchType type) {
            return switch (type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> (SimpleParticleType)UAParticleTypes.PINK_JELLY_BLOB.get();
                case 1 -> (SimpleParticleType)UAParticleTypes.PURPLE_JELLY_BLOB.get();
                case 2 -> (SimpleParticleType)UAParticleTypes.BLUE_JELLY_BLOB.get();
                case 3 -> (SimpleParticleType)UAParticleTypes.GREEN_JELLY_BLOB.get();
                case 4 -> (SimpleParticleType)UAParticleTypes.YELLOW_JELLY_BLOB.get();
                case 5 -> (SimpleParticleType)UAParticleTypes.ORANGE_JELLY_BLOB.get();
                case 6 -> (SimpleParticleType)UAParticleTypes.RED_JELLY_BLOB.get();
                case 7 -> (SimpleParticleType)UAParticleTypes.WHITE_JELLY_BLOB.get();
            };
        }

        static {
            VALUES = JellyTorchType.values();
        }
    }
}

