/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.teamabnormals.upgrade_aquatic.client.model.PikeModel;
import com.teamabnormals.upgrade_aquatic.common.entity.animal.Pike;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PikeCarriedItemRenderLayer
extends RenderLayer<Pike, PikeModel<Pike>> {
    private final ItemInHandRenderer itemInHandRenderer;

    public PikeCarriedItemRenderLayer(RenderLayerParent<Pike, PikeModel<Pike>> renderer, ItemInHandRenderer itemInHandRenderer) {
        super(renderer);
        this.itemInHandRenderer = itemInHandRenderer;
    }

    public void render(PoseStack matrixStack, MultiBufferSource bufferIn, int packedLightIn, Pike pike, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack itemstack = pike.getItemBySlot(EquipmentSlot.MAINHAND);
        if (!itemstack.isEmpty() && !itemstack.isEmpty()) {
            matrixStack.pushPose();
            matrixStack.translate(((PikeModel)this.getParentModel()).nose.x / 16.0f, ((PikeModel)this.getParentModel()).nose.y / 16.0f + 1.3f, ((PikeModel)this.getParentModel()).nose.z / 16.0f - 0.5f);
            matrixStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            this.itemInHandRenderer.renderItem((LivingEntity)pike, itemstack, ItemDisplayContext.GROUND, false, matrixStack, bufferIn, packedLightIn);
            matrixStack.popPose();
        }
    }
}

