/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.teamabnormals.blueprint.client.BlueprintRenderTypes;
import com.teamabnormals.upgrade_aquatic.client.model.PikeModel;
import com.teamabnormals.upgrade_aquatic.common.entity.animal.Pike;
import com.teamabnormals.upgrade_aquatic.common.entity.animal.PikeVariant;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GlowingPikeRenderLayer<T extends Pike, M extends PikeModel<T>>
extends RenderLayer<T, M> {
    public GlowingPikeRenderLayer(RenderLayerParent<T, M> renderer) {
        super(renderer);
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T pike, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (((PikeVariant)((Pike)((Object)pike)).getVariant().value()).glowAssetId().isEmpty()) {
            return;
        }
        ((PikeModel)this.getParentModel()).setupAnim(pike, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ((PikeModel)this.getParentModel()).renderToBuffer(matrixStackIn, bufferIn.getBuffer(BlueprintRenderTypes.getUnshadedCutoutEntity((ResourceLocation)this.getPikeOverlayTexture((Pike)((Object)pike)), (boolean)false)), 240, OverlayTexture.NO_OVERLAY);
    }

    private ResourceLocation getPikeOverlayTexture(Pike pike) {
        return ((PikeVariant)pike.getVariant().value()).glowAssetId().get().withPath(assetId -> "textures/" + assetId + ".png");
    }
}

