/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class JellyTorchParticle
extends TextureSheetParticle {
    protected final SpriteSet animatedSprite;
    private final float rotSpeed;
    private final float scale;
    private final int MAX_FRAME_ID = 2;
    protected int currentFrame = 0;
    private boolean directionRight = true;
    private int lastTick = 0;

    public JellyTorchParticle(SpriteSet animatedSprite, ClientLevel world, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        super(world, posX, posY, posZ, motionX, motionY, motionZ);
        this.xd = this.xd * (double)0.01f + motionX;
        this.yd = this.yd * (double)0.01f + motionY;
        this.zd = this.zd * (double)0.01f + motionZ;
        this.quadSize = 0.25f;
        this.scale = 0.25f;
        this.rotSpeed = ((float)Math.random() - 0.5f) * 0.1f;
        this.roll = (float)Math.random() * ((float)Math.PI * 2);
        this.gravity = 0.0f;
        this.rCol = 1.0f;
        this.gCol = 1.0f;
        this.bCol = 1.0f;
        this.lifetime = (int)(12.0 / (Math.random() * 0.8 + 0.2)) + 4;
        this.animatedSprite = animatedSprite;
        this.setSpriteFromAge(animatedSprite);
    }

    public void render(VertexConsumer p_225606_1_, Camera activeInfo, float partialTicks) {
        Entity entity = activeInfo.getEntity();
        if (entity.tickCount >= this.lastTick + 5) {
            if (this.currentFrame == 2) {
                this.directionRight = false;
            } else if (this.currentFrame == 0) {
                this.directionRight = true;
            }
            this.currentFrame += this.directionRight ? 1 : -1;
            this.lastTick = entity.tickCount;
        }
        float f = ((float)this.age + partialTicks) / (float)this.lifetime;
        this.quadSize = this.scale * (1.0f - f * f * 0.5f);
        super.render(p_225606_1_, activeInfo, partialTicks);
    }

    public void tick() {
        super.tick();
        this.oRoll = this.roll;
        this.roll += (float)Math.PI * this.rotSpeed * 2.0f;
        if (this.onGround) {
            this.roll = 0.0f;
            this.oRoll = 0.0f;
        }
        if (this.isAlive()) {
            this.setSpriteFromAge(this.animatedSprite);
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public int getLightColor(float partialTick) {
        float f = ((float)this.age + partialTick) / (float)this.lifetime;
        f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
        int i = super.getLightColor(partialTick);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet animatedSprite;

        public Factory(SpriteSet animatedSprite) {
            this.animatedSprite = animatedSprite;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new JellyTorchParticle(this.animatedSprite, world, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }
}

