/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.client.model.jellyfish;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamabnormals.blueprint.core.endimator.Endimator;
import com.teamabnormals.blueprint.core.endimator.EndimatorModelPart;
import com.teamabnormals.blueprint.core.endimator.entity.EndimatorEntityModel;
import com.teamabnormals.blueprint.core.endimator.model.EndimatorLayerDefinition;
import com.teamabnormals.blueprint.core.endimator.model.EndimatorPartDefinition;
import com.teamabnormals.upgrade_aquatic.common.entity.animal.jellyfish.BoxJellyfish;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.util.Mth;

public class BoxJellyfishModel<E extends BoxJellyfish>
extends EndimatorEntityModel<E> {
    public EndimatorModelPart body;
    public EndimatorModelPart tentacleW;
    public EndimatorModelPart tentacleS;
    public EndimatorModelPart tentacleE;
    public EndimatorModelPart tentacleN;
    public EndimatorModelPart tentacleNE;
    public EndimatorModelPart tentacleSE;
    public EndimatorModelPart tentacleNW;
    public EndimatorModelPart tentacleSW;

    public BoxJellyfishModel(ModelPart root) {
        this.body = (EndimatorModelPart)root.getChild("body");
        this.tentacleW = (EndimatorModelPart)this.body.getChild("tentacleW");
        this.tentacleS = (EndimatorModelPart)this.body.getChild("tentacleS");
        this.tentacleE = (EndimatorModelPart)this.body.getChild("tentacleE");
        this.tentacleN = (EndimatorModelPart)this.body.getChild("tentacleN");
        this.tentacleNE = (EndimatorModelPart)this.body.getChild("tentacleNE");
        this.tentacleSE = (EndimatorModelPart)this.body.getChild("tentacleSE");
        this.tentacleNW = (EndimatorModelPart)this.body.getChild("tentacleNW");
        this.tentacleSW = (EndimatorModelPart)this.body.getChild("tentacleSW");
        this.body.setShouldScaleChildren(false);
        this.endimator = Endimator.compile((ModelPart)root);
    }

    public static EndimatorLayerDefinition createBodyLayer() {
        EndimatorPartDefinition root = EndimatorPartDefinition.root();
        EndimatorPartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().addBox(-6.0f, -5.0f, -6.0f, 12.0f, 10.0f, 12.0f), PartPose.offsetAndRotation((float)0.0f, (float)19.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        EndimatorPartDefinition tentacleW = body.addOrReplaceChild("tentacleW", CubeListBuilder.create().texOffs(0, 22).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 18.0f, 1.0f), PartPose.offsetAndRotation((float)3.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)1.5707964f, (float)0.0f));
        EndimatorPartDefinition tentacleS = body.addOrReplaceChild("tentacleS", CubeListBuilder.create().texOffs(0, 22).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 18.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        EndimatorPartDefinition tentacleE = body.addOrReplaceChild("tentacleE", CubeListBuilder.create().texOffs(0, 22).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 18.0f, 1.0f), PartPose.offsetAndRotation((float)-3.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)1.5707964f, (float)0.0f));
        EndimatorPartDefinition tentacleN = body.addOrReplaceChild("tentacleN", CubeListBuilder.create().texOffs(0, 22).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 18.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)-3.0f, (float)0.0f, (float)((float)Math.PI), (float)0.0f));
        EndimatorPartDefinition tentacleNE = body.addOrReplaceChild("tentacleNE", CubeListBuilder.create().texOffs(0, 22).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 16.0f, 1.0f), PartPose.offsetAndRotation((float)-3.0f, (float)5.0f, (float)-3.0f, (float)0.0f, (float)-2.3561945f, (float)0.0f));
        EndimatorPartDefinition tentacleSE = body.addOrReplaceChild("tentacleSE", CubeListBuilder.create().texOffs(0, 22).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 16.0f, 1.0f), PartPose.offsetAndRotation((float)-3.0f, (float)5.0f, (float)3.0f, (float)0.0f, (float)5.497787f, (float)0.0f));
        EndimatorPartDefinition tentacleNW = body.addOrReplaceChild("tentacleNW", CubeListBuilder.create().texOffs(0, 22).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 16.0f, 1.0f), PartPose.offsetAndRotation((float)3.0f, (float)5.0f, (float)-3.0f, (float)0.0f, (float)2.3561945f, (float)0.0f));
        EndimatorPartDefinition tentacleSW = body.addOrReplaceChild("tentacleSW", CubeListBuilder.create().texOffs(0, 22).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 16.0f, 1.0f), PartPose.offsetAndRotation((float)3.0f, (float)5.0f, (float)3.0f, (float)0.0f, (float)0.7853982f, (float)0.0f));
        return new EndimatorLayerDefinition(root, 48, 42);
    }

    public void setupAnim(E entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float tentacleAngleOffset;
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        float progress = Mth.abs((float)Mth.cos((float)(limbSwing * 0.8f))) * Math.min(limbSwingAmount, 0.25f) * 4.0f;
        this.tentacleN.xRot = tentacleAngleOffset = 0.5236f * progress;
        this.tentacleNW.xRot = tentacleAngleOffset;
        this.tentacleNE.xRot = tentacleAngleOffset;
        this.tentacleE.xRot = -tentacleAngleOffset;
        this.tentacleSE.xRot = tentacleAngleOffset;
        this.tentacleS.xRot = tentacleAngleOffset;
        this.tentacleSW.xRot = tentacleAngleOffset;
        this.tentacleW.xRot = tentacleAngleOffset;
        float xzScale = 1.0f + 0.5f * progress;
        this.body.setScale(xzScale, 1.0f - 0.15f * progress, xzScale);
    }

    public void renderToBuffer(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, int color) {
        this.body.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
    }
}

