/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class LionfishModel<T extends Entity>
extends EntityModel<T> {
    public ModelPart body;
    public ModelPart topfin;
    public ModelPart bottomfin;
    public ModelPart tail;
    public ModelPart head;
    public ModelPart right_fin;
    public ModelPart left_fin;
    public ModelPart headFin;

    public LionfishModel(ModelPart root) {
        this.body = root.getChild("body");
        this.right_fin = this.body.getChild("right_fin");
        this.bottomfin = this.body.getChild("bottomfin");
        this.head = this.body.getChild("head");
        this.headFin = this.head.getChild("headFin");
        this.left_fin = this.body.getChild("left_fin");
        this.topfin = this.body.getChild("topfin");
        this.tail = this.body.getChild("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 19).addBox(-1.5f, -2.5f, 0.0f, 3.0f, 5.0f, 8.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)19.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_fin = body.addOrReplaceChild("right_fin", CubeListBuilder.create().texOffs(14, 11).addBox(0.0f, 0.0f, -4.0f, 0.0f, 8.0f, 8.0f, false), PartPose.offsetAndRotation((float)-1.5f, (float)0.5f, (float)5.0f, (float)0.0f, (float)-0.0f, (float)0.43633232f));
        PartDefinition bottomfin = body.addOrReplaceChild("bottomfin", CubeListBuilder.create().texOffs(40, 20).addBox(0.0f, 0.0f, 0.0f, 0.0f, 4.0f, 8.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 11).addBox(-1.5f, -2.5f, -3.0f, 3.0f, 4.0f, 3.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headFin = head.addOrReplaceChild("headFin", CubeListBuilder.create().texOffs(0, 18).addBox(0.0f, -7.0f, -3.0f, 0.0f, 5.0f, 4.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_fin = body.addOrReplaceChild("left_fin", CubeListBuilder.create().texOffs(14, 11).addBox(0.0f, 0.0f, -4.0f, 0.0f, 8.0f, 8.0f, false), PartPose.offsetAndRotation((float)1.5f, (float)0.5f, (float)4.0f, (float)0.0f, (float)-0.0f, (float)-0.43633232f));
        PartDefinition topfin = body.addOrReplaceChild("topfin", CubeListBuilder.create().texOffs(22, 19).addBox(0.0f, -7.0f, 0.0f, 0.0f, 5.0f, 8.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, -9).addBox(0.0f, -5.0f, 0.0f, 0.0f, 10.0f, 10.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)8.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void renderToBuffer(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, int color) {
        this.body.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
    }

    public void setupAnim(T lionfish, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean outOfWater = !lionfish.isInWater();
        float multiplier = outOfWater ? 1.35f : 1.1f;
        float thetaModifier = outOfWater ? 1.7f : 1.0f;
        this.tail.yRot = -multiplier * 0.2f * Mth.sin((float)(thetaModifier * 0.65f * ageInTicks));
    }
}

