/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.world.feature;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.scouter.netherdepthsupgrade.blocks.NDUBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.slf4j.Logger;

public class SpongeFeature
extends Feature<NoneFeatureConfiguration> {
    private static final Logger LOGGER = LogUtils.getLogger();

    public SpongeFeature(Codec<NoneFeatureConfiguration> p_66219_) {
        super(p_66219_);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> p_159956_) {
        WorldGenLevel worldgenlevel = p_159956_.level();
        BlockPos blockpos = p_159956_.origin();
        RandomSource random = p_159956_.random();
        int t = 30 + random.nextInt(-29, 0);
        BlockPos blockpos1 = new BlockPos(blockpos.getX(), t, blockpos.getZ());
        BlockState block = ((Block)NDUBlocks.WET_LAVA_SPONGE.get()).defaultBlockState();
        if (worldgenlevel.getBlockState(blockpos1).is(Blocks.LAVA)) {
            while (worldgenlevel.getFluidState(blockpos1).is((Fluid)Fluids.LAVA)) {
                blockpos1 = blockpos1.below();
            }
            int radius = random.nextInt(3, 6);
            radius = (int)((double)radius + 0.5);
            double radiusSq = radius * radius;
            int ceilRadius = (int)Math.ceil(radius);
            for (int x = 0; x <= ceilRadius; ++x) {
                for (int y = 0; y <= ceilRadius; ++y) {
                    for (int z = 0; z <= ceilRadius; ++z) {
                        double dSq = SpongeFeature.lengthSq(x, y, z);
                        if (dSq > radiusSq) continue;
                        if (worldgenlevel.getFluidState(blockpos1.offset(x, y, z)).is((Fluid)Fluids.LAVA)) {
                            worldgenlevel.setBlock(blockpos1.offset(x, y, z), block, 3);
                        }
                        if (worldgenlevel.getFluidState(blockpos1.offset(-x, y, z)).is((Fluid)Fluids.LAVA)) {
                            worldgenlevel.setBlock(blockpos1.offset(-x, y, z), block, 3);
                        }
                        if (worldgenlevel.getFluidState(blockpos1.offset(x, -y, z)).is((Fluid)Fluids.LAVA)) {
                            worldgenlevel.setBlock(blockpos1.offset(x, -y, z), block, 3);
                        }
                        if (worldgenlevel.getFluidState(blockpos1.offset(x, y, -z)).is((Fluid)Fluids.LAVA)) {
                            worldgenlevel.setBlock(blockpos1.offset(x, y, -z), block, 3);
                        }
                        if (worldgenlevel.getFluidState(blockpos1.offset(-x, -y, z)).is((Fluid)Fluids.LAVA)) {
                            worldgenlevel.setBlock(blockpos1.offset(-x, -y, z), block, 3);
                        }
                        if (worldgenlevel.getFluidState(blockpos1.offset(x, -y, -z)).is((Fluid)Fluids.LAVA)) {
                            worldgenlevel.setBlock(blockpos1.offset(x, -y, -z), block, 3);
                        }
                        if (worldgenlevel.getFluidState(blockpos1.offset(-x, y, -z)).is((Fluid)Fluids.LAVA)) {
                            worldgenlevel.setBlock(blockpos1.offset(-x, y, -z), block, 3);
                        }
                        if (!worldgenlevel.getFluidState(blockpos1.offset(-x, -y, -z)).is((Fluid)Fluids.LAVA)) continue;
                        worldgenlevel.setBlock(blockpos1.offset(-x, -y, -z), block, 3);
                    }
                }
            }
        }
        return true;
    }

    public static double lengthSq(int x, int y, int z) {
        return Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0);
    }
}

