/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.items;

import com.scouter.netherdepthsupgrade.blocks.NDUBlocks;
import com.scouter.netherdepthsupgrade.entity.NDUEntity;
import com.scouter.netherdepthsupgrade.items.BurnableBlockItem;
import com.scouter.netherdepthsupgrade.items.FishBucketItem;
import com.scouter.netherdepthsupgrade.items.LavaFishingRodItem;
import com.scouter.netherdepthsupgrade.items.NDUArmorMaterials;
import com.scouter.netherdepthsupgrade.items.NDUFoods;
import com.scouter.netherdepthsupgrade.items.SoulSuckerArmorItem;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.Nullable;

public class NDUItems {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"netherdepthsupgrade");
    public static final DeferredItem<BlockItem> LAVA_SPONGE = NDUItems.fromBlockFireRes(NDUBlocks.LAVA_SPONGE);
    public static final DeferredItem<BlockItem> WET_LAVA_SPONGE = NDUItems.fromBlockFireRes(NDUBlocks.WET_LAVA_SPONGE);
    public static final DeferredItem<BlockItem> WARPED_KELP = NDUItems.fromBlockFireRes(NDUBlocks.WARPED_KELP);
    public static final DeferredItem<BlockItem> WARPED_SEAGRASS = NDUItems.fromBlockFireRes(NDUBlocks.WARPED_SEAGRASS);
    public static final DeferredItem<BurnableBlockItem> WARPED_KELP_BLOCK = NDUItems.fromBlockFireResFuel(NDUBlocks.WARPED_KELP_BLOCK, 6400);
    public static final DeferredItem<BlockItem> WARPED_KELP_CARPET_BLOCK = NDUItems.fromBlockFireRes(NDUBlocks.WARPED_KELP_CARPET_BLOCK);
    public static final DeferredItem<BlockItem> CRIMSON_KELP = NDUItems.fromBlockFireRes(NDUBlocks.CRIMSON_KELP);
    public static final DeferredItem<BlockItem> CRIMSON_SEAGRASS = NDUItems.fromBlockFireRes(NDUBlocks.CRIMSON_SEAGRASS);
    public static final DeferredItem<BurnableBlockItem> CRIMSON_KELP_BLOCK = NDUItems.fromBlockFireResFuel(NDUBlocks.CRIMSON_KELP_BLOCK, 6400);
    public static final DeferredItem<BlockItem> CRIMSON_KELP_CARPET_BLOCK = NDUItems.fromBlockFireRes(NDUBlocks.CRIMSON_KELP_CARPET_BLOCK);
    public static final DeferredItem<BlockItem> LAVA_GLASS = NDUItems.fromBlockFireRes(NDUBlocks.LAVA_GLASS);
    public static final DeferredItem<Item> SOUL_SUCKER_LEATHER = ITEMS.register("soul_sucker_leather", () -> new Item(new Item.Properties().fireResistant()));
    public static final DeferredItem<Item> FORTRESS_GROUPER_PLATE = ITEMS.register("fortress_grouper_plate", () -> new Item(new Item.Properties().fireResistant()));
    public static final DeferredItem<Item> EYEBALL_FISH_EYE = ITEMS.register("eyeball", () -> new Item(new Item.Properties().fireResistant()));
    public static final DeferredItem<SoulSuckerArmorItem> SOUL_SUCKER_BOOTS = ITEMS.register("soul_sucker_boots", () -> new SoulSuckerArmorItem(NDUArmorMaterials.SOUL_SUCKER, ArmorItem.Type.BOOTS, new Item.Properties().fireResistant().durability(ArmorItem.Type.HELMET.getDurability(7))));
    public static final DeferredItem<Item> LAVA_PUFFERFISH = ITEMS.register("lava_pufferfish", () -> new Item(new Item.Properties().fireResistant().food(NDUFoods.LAVA_PUFFERFISH)));
    public static final DeferredItem<Item> OBSIDIANFISH = ITEMS.register("obsidianfish", () -> new Item(new Item.Properties().fireResistant().food(NDUFoods.OBSIDIANFISH)));
    public static final DeferredItem<Item> SEARING_COD = ITEMS.register("searing_cod", () -> new Item(new Item.Properties().fireResistant().food(NDUFoods.SEARING_COD)){

        public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
            return 3200;
        }
    });
    public static final DeferredItem<Item> BONEFISH = ITEMS.register("bonefish", () -> new Item(new Item.Properties().fireResistant().food(NDUFoods.BONEFISH)));
    public static final DeferredItem<Item> WITHER_BONEFISH = ITEMS.register("wither_bonefish", () -> new Item(new Item.Properties().fireResistant().food(NDUFoods.WITHER_BONEFISH)));
    public static final DeferredItem<Item> BLAZEFISH = ITEMS.register("blazefish", () -> new Item(new Item.Properties().fireResistant().food(NDUFoods.BLAZEFISH)));
    public static final DeferredItem<Item> MAGMACUBEFISH = ITEMS.register("magmacubefish", () -> new Item(new Item.Properties().fireResistant().food(NDUFoods.MAGMACUBEFISH)));
    public static final DeferredItem<Item> GLOWDINE = ITEMS.register("glowdine", () -> new Item(new Item.Properties().fireResistant().food(NDUFoods.GLOWDINE)));
    public static final DeferredItem<Item> SOULSUCKER = ITEMS.register("soulsucker", () -> new Item(new Item.Properties().fireResistant()));
    public static final DeferredItem<Item> LAVA_PUFFERFISH_BUCKET = ITEMS.register("lava_pufferfish_bucket", () -> new FishBucketItem((EntityType)NDUEntity.LAVA_PUFFERFISH.get(), (Fluid)Fluids.LAVA, new Item.Properties().fireResistant()));
    public static final DeferredItem<Item> OBSIDIANFISH_BUCKET = ITEMS.register("obsidianfish_bucket", () -> new FishBucketItem((EntityType)NDUEntity.OBSIDIAN_FISH.get(), (Fluid)Fluids.LAVA, new Item.Properties().fireResistant()));
    public static final DeferredItem<Item> SEARING_COD_BUCKET = ITEMS.register("searing_cod_bucket", () -> new FishBucketItem((EntityType)NDUEntity.SEARING_COD.get(), (Fluid)Fluids.LAVA, new Item.Properties().fireResistant()));
    public static final DeferredItem<Item> BONEFISH_BUCKET = ITEMS.register("bonefish_bucket", () -> new FishBucketItem((EntityType)NDUEntity.BONEFISH.get(), (Fluid)Fluids.LAVA, new Item.Properties().fireResistant()));
    public static final DeferredItem<Item> WITHER_BONEFISH_BUCKET = ITEMS.register("wither_bonefish_bucket", () -> new FishBucketItem((EntityType)NDUEntity.WITHER_BONEFISH.get(), (Fluid)Fluids.LAVA, new Item.Properties().fireResistant()));
    public static final DeferredItem<Item> BLAZEFISH_BUCKET = ITEMS.register("blazefish_bucket", () -> new FishBucketItem((EntityType)NDUEntity.BLAZEFISH.get(), (Fluid)Fluids.LAVA, new Item.Properties().fireResistant()));
    public static final DeferredItem<Item> MAGMACUBEFISH_BUCKET = ITEMS.register("magmacubefish_bucket", () -> new FishBucketItem((EntityType)NDUEntity.MAGMACUBEFISH.get(), (Fluid)Fluids.LAVA, new Item.Properties().fireResistant()));
    public static final DeferredItem<Item> GLOWDINE_BUCKET = ITEMS.register("glowdine_bucket", () -> new FishBucketItem((EntityType)NDUEntity.GLOWDINE.get(), (Fluid)Fluids.LAVA, new Item.Properties().fireResistant()));
    public static final DeferredItem<Item> SOULSUCKER_BUCKET = ITEMS.register("soulsucker_bucket", () -> new FishBucketItem((EntityType)NDUEntity.SOULSUCKER.get(), (Fluid)Fluids.LAVA, new Item.Properties().fireResistant()));
    public static final DeferredItem<Item> LAVA_PUFFERFISH_SPAWN_EGG = ITEMS.register("lava_pufferfish_spawn_egg", () -> new DeferredSpawnEggItem(() -> (EntityType)NDUEntity.LAVA_PUFFERFISH.get(), 16022652, 14684947, new Item.Properties().fireResistant()));
    public static final DeferredItem<Item> OBSIDIANFISH_SPAWN_EGG = ITEMS.register("obsidianfish_spawn_egg", () -> new DeferredSpawnEggItem(() -> (EntityType)NDUEntity.OBSIDIAN_FISH.get(), 1, 3876692, new Item.Properties().fireResistant()));
    public static final DeferredItem<Item> SEARING_COD_SPAWN_EGG = ITEMS.register("searing_cod_spawn_egg", () -> new DeferredSpawnEggItem(() -> (EntityType)NDUEntity.SEARING_COD.get(), 14898439, 16473607, new Item.Properties().fireResistant()));
    public static final DeferredItem<Item> BONEFISH_SPAWN_EGG = ITEMS.register("bonefish_spawn_egg", () -> new DeferredSpawnEggItem(() -> (EntityType)NDUEntity.BONEFISH.get(), 0xC1C1C1, 0x494949, new Item.Properties().fireResistant()));
    public static final DeferredItem<Item> WITHER_BONEFISH_SPAWN_EGG = ITEMS.register("wither_bonefish_spawn_egg", () -> new DeferredSpawnEggItem(() -> (EntityType)NDUEntity.WITHER_BONEFISH.get(), 0x141414, 0x474D4D, new Item.Properties().fireResistant()));
    public static final DeferredItem<Item> BLAZEFISH_SPAWN_EGG = ITEMS.register("blazefish_spawn_egg", () -> new DeferredSpawnEggItem(() -> (EntityType)NDUEntity.BLAZEFISH.get(), 16167425, 16775294, new Item.Properties().fireResistant()));
    public static final DeferredItem<Item> MAGMACUBEFISH_SPAWN_EGG = ITEMS.register("magmacubefish_spawn_egg", () -> new DeferredSpawnEggItem(() -> (EntityType)NDUEntity.MAGMACUBEFISH.get(), 0x340000, 0xFCFC00, new Item.Properties().fireResistant()));
    public static final DeferredItem<Item> GLOWDINE_SPAWN_EGG = ITEMS.register("glowdine_spawn_egg", () -> new DeferredSpawnEggItem(() -> (EntityType)NDUEntity.GLOWDINE.get(), 16505460, 13403732, new Item.Properties().fireResistant()));
    public static final DeferredItem<Item> SOULSUCKER_SPAWN_EGG = ITEMS.register("soulsucker_spawn_egg", () -> new DeferredSpawnEggItem(() -> (EntityType)NDUEntity.SOULSUCKER.get(), 7954770, 13403732, new Item.Properties().fireResistant()));
    public static final DeferredItem<Item> FORTRESS_GROUPER = ITEMS.register("fortress_grouper", () -> new Item(new Item.Properties().fireResistant().food(NDUFoods.FORTRESS_GROUPER)));
    public static final DeferredItem<Item> FORTRESS_GROUPER_BUCKET = ITEMS.register("fortress_grouper_bucket", () -> new FishBucketItem((EntityType)NDUEntity.FORTRESS_GROUPER.get(), (Fluid)Fluids.LAVA, new Item.Properties().fireResistant()));
    public static final DeferredItem<Item> FORTRESS_GROUPER_SPAWN_EGG = ITEMS.register("fortress_grouper_spawn_egg", () -> new DeferredSpawnEggItem(() -> (EntityType)NDUEntity.FORTRESS_GROUPER.get(), 3676190, 15766552, new Item.Properties().fireResistant()));
    public static final DeferredItem<Item> EYEBALL_FISH = ITEMS.register("eyeball_fish", () -> new Item(new Item.Properties().fireResistant().food(NDUFoods.EYEBALL_FISH)));
    public static final DeferredItem<Item> EYEBALL_FISH_BUCKET = ITEMS.register("eyeball_fish_bucket", () -> new FishBucketItem((EntityType)NDUEntity.EYEBALL_FISH.get(), (Fluid)Fluids.LAVA, new Item.Properties().fireResistant()));
    public static final DeferredItem<Item> EYEBALL_FISH_SPAWN_EGG = ITEMS.register("eyeball_fish_spawn_egg", () -> new DeferredSpawnEggItem(() -> (EntityType)NDUEntity.EYEBALL_FISH.get(), 9048080, 15783291, new Item.Properties().fireResistant()));
    public static final DeferredItem<LavaFishingRodItem> LAVA_FISHING_ROD = ITEMS.register("lava_fishing_rod", () -> new LavaFishingRodItem(new Item.Properties().fireResistant().durability(256)));

    public static <B extends Block> DeferredItem<BlockItem> fromBlock(DeferredBlock<B> block) {
        return ITEMS.register(block.getId().getPath(), () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static <B extends Block> DeferredItem<BlockItem> fromBlockFireRes(DeferredBlock<B> block) {
        return ITEMS.register(block.getId().getPath(), () -> new BlockItem((Block)block.get(), new Item.Properties().fireResistant()));
    }

    public static <B extends Block> DeferredItem<BurnableBlockItem> fromBlockFireResFuel(DeferredBlock<B> block, int burntime) {
        return ITEMS.register(block.getId().getPath(), () -> new BurnableBlockItem((Block)block.get(), new Item.Properties().fireResistant(), burntime));
    }
}

