/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.entity.ai;

import com.scouter.netherdepthsupgrade.entity.AbstractLavaFish;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.JumpGoal;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;

public class LavaFishJumpGoal
extends JumpGoal {
    private static final int[] STEPS_TO_CHECK = new int[]{0, 1, 4, 5, 6, 7, 10, 11};
    private final AbstractLavaFish lavaAnimal;
    private final int interval;
    private boolean breached;

    public LavaFishJumpGoal(AbstractLavaFish lavaAnimal, int pInterval) {
        this.lavaAnimal = lavaAnimal;
        this.interval = LavaFishJumpGoal.reducedTickDelay((int)pInterval);
    }

    public boolean canUse() {
        if (this.lavaAnimal.getRandom().nextInt(this.interval) != 0) {
            return false;
        }
        Direction direction = this.lavaAnimal.getMotionDirection();
        int i = direction.getStepX();
        int j = direction.getStepZ();
        BlockPos blockpos = this.lavaAnimal.blockPosition();
        for (int k : STEPS_TO_CHECK) {
            if (this.lavaIsClear(blockpos, i, j, k) && this.surfaceIsClear(blockpos, i, j, k)) continue;
            return false;
        }
        return true;
    }

    private boolean lavaIsClear(BlockPos pPos, int pDx, int pDz, int pScale) {
        BlockPos blockpos = pPos.offset(pDx * pScale, 0, pDz * pScale);
        return this.lavaAnimal.level().getFluidState(blockpos).is(FluidTags.LAVA) && !this.lavaAnimal.level().getBlockState(blockpos).blocksMotion();
    }

    private boolean surfaceIsClear(BlockPos pPos, int pDx, int pDz, int pScale) {
        return this.lavaAnimal.level().getBlockState(pPos.offset(pDx * pScale, 1, pDz * pScale)).isAir() && this.lavaAnimal.level().getBlockState(pPos.offset(pDx * pScale, 2, pDz * pScale)).isAir();
    }

    public boolean canContinueToUse() {
        double d0 = this.lavaAnimal.getDeltaMovement().y;
        return !(d0 * d0 < (double)0.03f && this.lavaAnimal.getXRot() != 0.0f && Math.abs(this.lavaAnimal.getXRot()) < 10.0f && this.lavaAnimal.isInLava() || this.lavaAnimal.onGround());
    }

    public boolean isInterruptable() {
        return false;
    }

    public void start() {
        Direction direction = this.lavaAnimal.getMotionDirection();
        this.lavaAnimal.setDeltaMovement(this.lavaAnimal.getDeltaMovement().add((double)direction.getStepX() * 1.1, 0.7, (double)direction.getStepZ() * 1.1));
        this.lavaAnimal.getNavigation().stop();
        this.lavaAnimal.setIsJumping(true);
    }

    public void stop() {
        this.lavaAnimal.setXRot(0.0f);
        this.lavaAnimal.setIsJumping(false);
        this.lavaAnimal.fishSwimGoal.trigger();
    }

    public void tick() {
        boolean flag = this.breached;
        if (!flag) {
            FluidState fluidstate = this.lavaAnimal.level().getFluidState(this.lavaAnimal.blockPosition());
            this.breached = fluidstate.is(FluidTags.LAVA);
        }
        if (this.breached && !flag) {
            this.lavaAnimal.playSound(SoundEvents.DOLPHIN_JUMP, 1.0f, 1.0f);
        }
        Vec3 vec3 = this.lavaAnimal.getDeltaMovement();
        if (vec3.y * vec3.y < (double)0.03f && this.lavaAnimal.getXRot() != 0.0f) {
            this.lavaAnimal.setXRot(Mth.rotLerp((float)this.lavaAnimal.getXRot(), (float)0.0f, (float)0.2f));
        } else if (vec3.length() > (double)1.0E-5f) {
            double d0 = vec3.horizontalDistance();
            double d1 = Math.atan2(-vec3.y, d0) * 57.2957763671875;
            this.lavaAnimal.setXRot((float)d1);
        }
    }
}

