/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.datagen;

import com.scouter.netherdepthsupgrade.datagen.AdvancementProvider;
import com.scouter.netherdepthsupgrade.datagen.BlockTagGenerator;
import com.scouter.netherdepthsupgrade.datagen.EnchantmenTagGenerator;
import com.scouter.netherdepthsupgrade.datagen.EntityTagGenerator;
import com.scouter.netherdepthsupgrade.datagen.FluidTagGenerator;
import com.scouter.netherdepthsupgrade.datagen.ItemModelGenerator;
import com.scouter.netherdepthsupgrade.datagen.ItemTagGenerator;
import com.scouter.netherdepthsupgrade.datagen.LanguageGenerator;
import com.scouter.netherdepthsupgrade.datagen.RecipeGenerator;
import com.scouter.netherdepthsupgrade.datagen.RegistryDataGenerator;
import com.scouter.netherdepthsupgrade.datagen.SBlockStateGenerator;
import com.scouter.netherdepthsupgrade.datagen.StructureUpdater;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.DetectedVersion;
import net.minecraft.WorldVersion;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.util.InclusiveRange;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="netherdepthsupgrade", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new RecipeGenerator(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new LanguageGenerator(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new SBlockStateGenerator(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModelGenerator(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new FluidTagGenerator(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new EntityTagGenerator(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new StructureUpdater("structure", packOutput, existingFileHelper));
        generator.addProvider(true, (DataProvider)new AdvancementProvider(packOutput, lookupProvider, existingFileHelper));
        BlockTagGenerator blockTagGenerator = (BlockTagGenerator)generator.addProvider(event.includeServer(), (DataProvider)new BlockTagGenerator(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ItemTagGenerator(packOutput, lookupProvider, blockTagGenerator.contentsGetter(), existingFileHelper));
        RegistryDataGenerator datapackProvider = new RegistryDataGenerator(packOutput, lookupProvider);
        CompletableFuture customLookupProvider = datapackProvider.getRegistryProvider();
        generator.addProvider(event.includeServer(), (DataProvider)datapackProvider);
        generator.addProvider(true, (DataProvider)new EnchantmenTagGenerator(packOutput, customLookupProvider, existingFileHelper));
        Map packVersions = Arrays.stream(PackType.values()).collect(Collectors.toMap(Function.identity(), arg_0 -> ((WorldVersion)DetectedVersion.BUILT_IN).getPackVersion(arg_0)));
        InclusiveRange supportedFormatsRange = new InclusiveRange((Comparable)packVersions.values().stream().min(Integer::compareTo).orElse(1), (Comparable)packVersions.values().stream().max(Integer::compareTo).orElse(1));
        generator.addProvider(true, (DataProvider)new PackMetadataGenerator(packOutput).add(PackMetadataSection.TYPE, (Object)new PackMetadataSection((Component)Component.literal((String)"Resources for Nether Depths Upgrade"), DetectedVersion.BUILT_IN.getPackVersion(PackType.CLIENT_RESOURCES), Optional.of(supportedFormatsRange))));
    }
}

