/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.blocks.entity;

import com.scouter.netherdepthsupgrade.blocks.entity.NDUBlockEntities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class LavaGlassBlockEntity
extends BlockEntity {
    protected static final VoxelShape SHAPE_DOWN = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.01, (double)16.0);
    protected static final VoxelShape SHAPE_UP = Block.box((double)0.0, (double)15.99, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_NORTH = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)0.01);
    protected static final VoxelShape SHAPE_EAST = Block.box((double)15.99, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH = Block.box((double)0.0, (double)0.0, (double)15.99, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_WEST = Block.box((double)0.0, (double)0.0, (double)0.0, (double)0.01, (double)16.0, (double)16.0);
    private static final Map<Direction, VoxelShape> occlusionShapes = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.DOWN, SHAPE_DOWN);
            this.put(Direction.UP, SHAPE_UP);
            this.put(Direction.NORTH, SHAPE_NORTH);
            this.put(Direction.EAST, SHAPE_EAST);
            this.put(Direction.SOUTH, SHAPE_SOUTH);
            this.put(Direction.WEST, SHAPE_WEST);
        }
    };
    protected VoxelShape occlusionShape = Shapes.empty();
    private final List<Direction> occlusionDirs = new ArrayList<Direction>();

    public LavaGlassBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)NDUBlockEntities.LAVA_GLASS.get(), pPos, pBlockState);
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        ListTag occlusionDirStrings = new ListTag();
        for (Direction direction : this.occlusionDirs) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putString("dir", direction.toString());
            occlusionDirStrings.add((Object)compoundTag);
        }
        pTag.put("occlusiondirs", (Tag)occlusionDirStrings);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        ListTag occlusionDirTag = pTag.getList("occlusiondirs", 10);
        for (int i = 0; i < occlusionDirTag.size(); ++i) {
            CompoundTag dirCompoundTag = occlusionDirTag.getCompound(i);
            String dirString = dirCompoundTag.getString("dir");
            Direction direction = Direction.byName((String)dirString);
            if (direction == null) continue;
            this.occlusionDirs.add(direction);
        }
        VoxelShape shape = Shapes.empty();
        for (Direction direction : this.occlusionDirs) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)occlusionShapes.get(direction));
        }
        this.setOcclusionShape(shape);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.handleUpdateTag(tag, lookupProvider);
        ListTag occlusionDirTag = tag.getList("occlusiondirs", 10);
        for (int i = 0; i < occlusionDirTag.size(); ++i) {
            CompoundTag dirCompoundTag = occlusionDirTag.getCompound(i);
            String dirString = dirCompoundTag.getString("dir");
            Direction direction = Direction.byName((String)dirString);
            if (direction == null) continue;
            this.occlusionDirs.add(direction);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag compoundTag = new CompoundTag();
        ListTag occlusionDirStrings = new ListTag();
        for (Direction direction : this.occlusionDirs) {
            CompoundTag dirTag = new CompoundTag();
            dirTag.putString("dir", direction.toString());
            occlusionDirStrings.add((Object)dirTag);
        }
        compoundTag.put("occlusiondirs", (Tag)occlusionDirStrings);
        return compoundTag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
        LavaGlassBlockEntity blockEntity = (LavaGlassBlockEntity)this.level.getBlockEntity(pkt.getPos());
        CompoundTag tag = pkt.getTag();
        if (tag != null && tag.contains("occlusiondirs", 10)) {
            ListTag occlusionDirTag = tag.getList("occlusiondirs", 10);
            for (int i = 0; i < occlusionDirTag.size(); ++i) {
                CompoundTag dirCompoundTag = occlusionDirTag.getCompound(i);
                String dirString = dirCompoundTag.getString("dir");
                Direction direction = Direction.byName((String)dirString);
                if (direction == null) continue;
                this.occlusionDirs.add(direction);
            }
            VoxelShape shape = Shapes.empty();
            for (Direction direction : this.occlusionDirs) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)occlusionShapes.get(direction));
            }
            blockEntity.setOcclusionShape(shape);
        }
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 8);
    }

    public VoxelShape getOcclusionShape() {
        return this.occlusionShape;
    }

    public void setOcclusionShape(VoxelShape shape) {
        this.occlusionShape = shape;
    }

    public void addDirection(Direction direction) {
        this.occlusionDirs.add(direction);
    }

    public List<Direction> getOcclusionDirs() {
        return this.occlusionDirs;
    }
}

