/*
 * Decompiled with CFR 0.152.
 */
package team.creative.playerrevive.server;

import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.scores.Team;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.CommandEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import team.creative.creativecore.common.config.premade.MobEffectConfig;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.playerrevive.PlayerRevive;
import team.creative.playerrevive.PlayerReviveConfig;
import team.creative.playerrevive.api.IBleeding;
import team.creative.playerrevive.api.PlayerExtender;
import team.creative.playerrevive.packet.HelperPacket;
import team.creative.playerrevive.server.PlayerReviveServer;

public class ReviveEventServer {
    public static boolean isReviveActive(Entity player) {
        Player p;
        if (player instanceof Player && (p = (Player)player).isCreative() && !PlayerRevive.CONFIG.bleeding.triggerForCreative) {
            return false;
        }
        return PlayerRevive.CONFIG.bleedInSingleplayer || player.getServer().isPublished();
    }

    @SubscribeEvent
    public void executeCommand(CommandEvent event) {
        CommandSourceStack source = (CommandSourceStack)event.getParseResults().getContext().getSource();
        if (PlayerRevive.CONFIG.bleeding.disableServerCommands && source.isPlayer() && PlayerReviveServer.getBleeding((Player)source.getPlayer()).isBleeding()) {
            source.getPlayer().sendSystemMessage((Component)Component.translatable((String)"playerrevive.chat.no_commands"));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void playerTick(PlayerTickEvent.Pre event) {
        if (!event.getEntity().level().isClientSide && ReviveEventServer.isReviveActive((Entity)event.getEntity())) {
            Player player = event.getEntity();
            if (!player.isAlive()) {
                return;
            }
            IBleeding revive = PlayerReviveServer.getBleeding(player);
            if (revive.isBleeding()) {
                revive.tick(player);
                if (revive.downedTime() % 5 == 0) {
                    PlayerReviveServer.sendUpdatePacket(player);
                }
                if (PlayerRevive.CONFIG.bleeding.affectHunger) {
                    player.getFoodData().setFoodLevel(PlayerRevive.CONFIG.bleeding.remainingHunger);
                }
                for (MobEffectConfig effect : PlayerRevive.CONFIG.bleeding.bleedingEffects) {
                    player.addEffect(effect.create());
                }
                if (PlayerRevive.CONFIG.bleeding.shouldGlow) {
                    player.addEffect(new MobEffectInstance(MobEffects.GLOWING, 10));
                }
                if (revive.revived()) {
                    PlayerReviveServer.revive(player);
                } else if (revive.bledOut()) {
                    PlayerReviveServer.kill(player);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void playerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        IBleeding revive = PlayerReviveServer.getBleeding(event.getEntity());
        if (revive.isBleeding()) {
            PlayerReviveServer.kill(event.getEntity());
        }
        if (!event.getEntity().level().isClientSide) {
            PlayerReviveServer.removePlayerAsHelper(event.getEntity());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void playerInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.getTarget() instanceof Player && !event.getEntity().level().isClientSide) {
            Player target = (Player)event.getTarget();
            Player helper = event.getEntity();
            IBleeding revive = PlayerReviveServer.getBleeding(target);
            if (revive.isBleeding()) {
                block10: {
                    event.setCanceled(true);
                    if (PlayerRevive.CONFIG.revive.teammatesOnly && !helper.getTeam().isAlliedTo((Team)target.getTeam())) {
                        helper.sendSystemMessage((Component)Component.translatable((String)"playerrevive.revive.other_team"));
                        return;
                    }
                    if (PlayerRevive.CONFIG.revive.needReviveItem) {
                        if (PlayerRevive.CONFIG.revive.consumeReviveItem && !revive.isItemConsumed()) {
                            if (PlayerRevive.CONFIG.revive.reviveItem.is(helper.getMainHandItem())) {
                                if (!helper.isCreative()) {
                                    helper.getMainHandItem().shrink(1);
                                    helper.getInventory().setChanged();
                                }
                                revive.setItemConsumed();
                                break block10;
                            } else {
                                if (!helper.level().isClientSide) {
                                    helper.sendSystemMessage((Component)Component.translatable((String)"playerrevive.revive.item", (Object[])new Object[]{PlayerRevive.CONFIG.revive.reviveItem.description()}));
                                }
                                return;
                            }
                        }
                        if (!PlayerRevive.CONFIG.revive.reviveItem.is(helper.getMainHandItem())) {
                            return;
                        }
                    }
                }
                PlayerReviveServer.removePlayerAsHelper(helper);
                revive.revivingPlayers().add(helper);
                PlayerRevive.NETWORK.sendToClient((CreativePacket)new HelperPacket(target.getUUID(), true), (ServerPlayer)helper);
            }
        }
    }

    private boolean doesByPass(Player player, DamageSource source) {
        if (source.typeHolder().is(PlayerRevive.BLED_TO_DEATH)) {
            return true;
        }
        if (PlayerRevive.CONFIG.bypassDamageSources.contains(source.getMsgId())) {
            return true;
        }
        return PlayerRevive.CONFIG.bypassDamageSources.contains(source.typeHolder().getRegisteredName());
    }

    private boolean doesByPassDamageAmount(Player player, DamageSource source) {
        if (!PlayerRevive.CONFIG.enableBypassDamage) {
            return false;
        }
        float amount = ((PlayerExtender)player).getOverkill();
        if ((float)PlayerRevive.CONFIG.bypassDamage <= amount) {
            return true;
        }
        for (PlayerReviveConfig.DamageTypeConfig d : PlayerRevive.CONFIG.bypassSourceByDamage) {
            if ((float)d.damageAmount > amount || !d.damageType.equals(source.getMsgId()) && !d.damageType.equals(source.typeHolder().getRegisteredName())) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void playerDamage(LivingIncomingDamageEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            IBleeding revive = PlayerReviveServer.getBleeding(player);
            if (revive.isBleeding()) {
                if (this.doesByPass(player, event.getSource())) {
                    return;
                }
                if (revive.bledOut()) {
                    event.setCanceled(true);
                }
                if (revive.downedTime() <= PlayerRevive.CONFIG.bleeding.initialDamageCooldown) {
                    event.setCanceled(true);
                }
                if (event.getSource().getEntity() instanceof Player) {
                    if (PlayerRevive.CONFIG.bleeding.disablePlayerDamage) {
                        event.setCanceled(true);
                    }
                } else if (event.getSource().getEntity() instanceof LivingEntity) {
                    if (PlayerRevive.CONFIG.bleeding.disableMobDamage) {
                        event.setCanceled(true);
                    }
                } else if (PlayerRevive.CONFIG.bleeding.disableOtherDamage) {
                    event.setCanceled(true);
                }
            } else if (PlayerRevive.CONFIG.revive.abortOnDamage) {
                PlayerReviveServer.removePlayerAsHelper(player);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void playerOverkillTracker(LivingDamageEvent.Pre event) {
        LivingEntity livingEntity;
        if (!event.getEntity().level().isClientSide && (livingEntity = event.getEntity()) instanceof PlayerExtender) {
            PlayerExtender player = (PlayerExtender)livingEntity;
            if (ReviveEventServer.isReviveActive((Entity)event.getEntity())) {
                player.setOverkill(Math.max(0.0f, event.getContainer().getNewDamage() - event.getEntity().getHealth()));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void playerDied(LivingDeathEvent event) {
        LivingEntity livingEntity;
        if (!event.getEntity().level().isClientSide && (livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            if (ReviveEventServer.isReviveActive((Entity)event.getEntity()) && !this.doesByPass(player, event.getSource()) && !this.doesByPassDamageAmount(player, event.getSource())) {
                IBleeding revive = PlayerReviveServer.getBleeding(player);
                if (revive.bledOut() || revive.isBleeding()) {
                    if (revive.isBleeding()) {
                        PlayerRevive.CONFIG.sounds.death.play((Entity)player, SoundSource.PLAYERS);
                    }
                    for (Player helper : revive.revivingPlayers()) {
                        PlayerRevive.NETWORK.sendToClient((CreativePacket)new HelperPacket(null, false), (ServerPlayer)helper);
                    }
                    revive.revivingPlayers().clear();
                    return;
                }
                PlayerReviveServer.removePlayerAsHelper(player);
                PlayerRevive.NETWORK.sendToClient((CreativePacket)new HelperPacket(null, false), (ServerPlayer)player);
                PlayerReviveServer.startBleeding(player, event.getSource());
                if (player.isPassenger()) {
                    player.stopRiding();
                }
                event.setCanceled(true);
                if (PlayerRevive.CONFIG.bleeding.affectHunger) {
                    player.getFoodData().setFoodLevel(PlayerRevive.CONFIG.bleeding.remainingHunger);
                }
                player.setHealth((float)PlayerRevive.CONFIG.bleeding.bleedingHealth);
                if (PlayerRevive.CONFIG.bleeding.bleedingMessage) {
                    if (PlayerRevive.CONFIG.bleeding.bleedingMessageTrackingOnly) {
                        ChunkSource chunkSource = player.level().getChunkSource();
                        if (chunkSource instanceof ServerChunkCache) {
                            ServerChunkCache chunkCache = (ServerChunkCache)chunkSource;
                            chunkCache.broadcastAndSend((Entity)player, (Packet)new ClientboundSystemChatPacket((Component)Component.translatable((String)"playerrevive.chat.bleeding", (Object[])new Object[]{player.getDisplayName()}), false));
                        }
                    } else {
                        player.getServer().getPlayerList().broadcastSystemMessage((Component)Component.translatable((String)"playerrevive.chat.bleeding", (Object[])new Object[]{player.getDisplayName()}), false);
                    }
                }
            }
        }
    }
}

