/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.item;

import com.bobmowzie.mowziesmobs.server.block.BlockHandler;
import com.bobmowzie.mowziesmobs.server.block.RakedSandBlock;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.Tags;

public class ItemSandRake
extends Item {
    public ItemSandRake(Item.Properties properties) {
        super(properties);
    }

    public boolean isValidRepairItem(ItemStack thisStack, ItemStack ingredientStack) {
        return ingredientStack.is(ItemTags.PLANKS) || super.isValidRepairItem(thisStack, ingredientStack);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        BlockState blockstate = level.getBlockState(blockpos);
        if (context.getClickedFace() != Direction.UP) {
            return InteractionResult.PASS;
        }
        Player player = context.getPlayer();
        if (player != null) {
            BlockPlaceContext blockPlaceContext = new BlockPlaceContext(player, context.getHand(), context.getItemInHand(), new BlockHitResult(context.getClickLocation(), context.getClickedFace(), context.getClickedPos(), context.isInside()));
            RakedSandBlock origBlock = null;
            if (blockstate.is(Tags.Blocks.SANDS_COLORLESS)) {
                origBlock = (RakedSandBlock)((Object)BlockHandler.RAKED_SAND.value());
            } else if (blockstate.is(Tags.Blocks.SANDS_RED)) {
                origBlock = (RakedSandBlock)((Object)BlockHandler.RED_RAKED_SAND.value());
            }
            if (origBlock != null) {
                BlockState blockState = origBlock.getStateForPlacement(blockPlaceContext);
                if (blockState != null) {
                    level.playSound(player, blockpos, (SoundEvent)MMSounds.BLOCK_RAKE_SAND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    if (!level.isClientSide) {
                        level.setBlock(blockpos, blockState, 11);
                        origBlock.onPlace(blockState, level, blockpos, blockstate, false);
                        origBlock.updateState(blockState, level, blockpos, false);
                        context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
                    }
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".text.0")).setStyle(ItemHandler.TOOLTIP_STYLE));
    }
}

