/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.wroughtnaut;

import com.bobmowzie.mowziesmobs.client.model.tools.ControlledAnimation;
import com.bobmowzie.mowziesmobs.client.sound.BossMusic;
import com.bobmowzie.mowziesmobs.client.sound.BossMusicPlayer;
import com.bobmowzie.mowziesmobs.server.ai.MMPathNavigateGround;
import com.bobmowzie.mowziesmobs.server.ai.WroughtnautAttackAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationActivateAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationDeactivateAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationDieAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationFWNAttackAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationFWNStompAttackAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationFWNVerticalAttackAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationTakeDamage;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.bobmowzie.mowziesmobs.server.entity.MowzieLLibraryEntity;
import com.bobmowzie.mowziesmobs.server.entity.SmartBodyHelper;
import com.bobmowzie.mowziesmobs.server.loot.LootTableHandler;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.ilexiconn.llibrary.server.animation.Animation;
import com.ilexiconn.llibrary.server.animation.AnimationHandler;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EntityWroughtnaut
extends MowzieLLibraryEntity
implements Enemy {
    public static final Animation DIE_ANIMATION = Animation.create(130);
    public static final Animation HURT_ANIMATION = Animation.create(15);
    public static final Animation ATTACK_ANIMATION = Animation.create(50);
    public static final Animation ATTACK_TWICE_ANIMATION = Animation.create(36);
    public static final Animation ATTACK_THRICE_ANIMATION = Animation.create(59);
    public static final Animation VERTICAL_ATTACK_ANIMATION = Animation.create(105);
    public static final Animation STOMP_ATTACK_ANIMATION = Animation.create(40);
    public static final Animation ACTIVATE_ANIMATION = Animation.create(45);
    public static final Animation DEACTIVATE_ANIMATION = Animation.create(15);
    private static final Animation[] ANIMATIONS = new Animation[]{DIE_ANIMATION, HURT_ANIMATION, ATTACK_ANIMATION, ATTACK_TWICE_ANIMATION, ATTACK_THRICE_ANIMATION, VERTICAL_ATTACK_ANIMATION, STOMP_ATTACK_ANIMATION, ACTIVATE_ANIMATION, DEACTIVATE_ANIMATION};
    private static final float[][] VERTICAL_ATTACK_BLOCK_OFFSETS = new float[][]{{-0.1f, -0.1f}, {-0.1f, 0.1f}, {0.1f, 0.1f}, {0.1f, -0.1f}};
    private static final EntityDataAccessor<Optional<BlockPos>> REST_POSITION = SynchedEntityData.defineId(EntityWroughtnaut.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_POS);
    private static final EntityDataAccessor<Boolean> ACTIVE = SynchedEntityData.defineId(EntityWroughtnaut.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> ALWAYS_ACTIVE = SynchedEntityData.defineId(EntityWroughtnaut.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public ControlledAnimation walkAnim = new ControlledAnimation(10);
    public boolean swingDirection;
    public boolean vulnerable;
    private CeilingDisturbance disturbance;
    public Vec3 leftEyePos;
    public Vec3 rightEyePos;
    public Vec3 leftEyeRot;
    public Vec3 rightEyeRot;

    public EntityWroughtnaut(EntityType<? extends EntityWroughtnaut> type, Level world) {
        super(type, world);
        this.xpReward = 30;
        this.active = false;
        this.dropAfterDeathAnim = true;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new AnimationFWNAttackAI(this, 4.0f, 5.0f, 100.0f));
        this.goalSelector.addGoal(1, (Goal)new AnimationFWNVerticalAttackAI(this, VERTICAL_ATTACK_ANIMATION, (SoundEvent)MMSounds.ENTITY_WROUGHT_WHOOSH.get(), 1.0f, 5.0f, 40.0f));
        this.goalSelector.addGoal(1, (Goal)new AnimationFWNStompAttackAI(this, STOMP_ATTACK_ANIMATION));
        this.goalSelector.addGoal(1, new AnimationTakeDamage<EntityWroughtnaut>(this));
        this.goalSelector.addGoal(1, new AnimationDieAI<EntityWroughtnaut>(this));
        this.goalSelector.addGoal(1, new AnimationActivateAI<EntityWroughtnaut>(this, ACTIVATE_ANIMATION));
        this.goalSelector.addGoal(1, new AnimationDeactivateAI<EntityWroughtnaut>(this, DEACTIVATE_ANIMATION));
        this.goalSelector.addGoal(2, (Goal)new WroughtnautAttackAI(this));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 0, true, false, null));
    }

    protected PathNavigation createNavigation(Level world) {
        return new MMPathNavigateGround(this, world);
    }

    protected BodyRotationControl createBodyControl() {
        return new SmartBodyHelper((Mob)this);
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)MMSounds.ENTITY_WROUGHT_HURT_1.get();
    }

    public SoundEvent getDeathSound() {
        this.playSound((SoundEvent)MMSounds.ENTITY_WROUGHT_SCREAM.get(), 1.0f, 1.0f);
        return null;
    }

    protected SoundEvent getAmbientSound() {
        return this.getAnimation() == NO_ANIMATION && this.isActive() ? (SoundEvent)MMSounds.ENTITY_WROUGHT_AMBIENT.get() : null;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MowzieEntity.createAttributes().add(Attributes.ATTACK_DAMAGE, 30.0).add(Attributes.MAX_HEALTH, 40.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.STEP_HEIGHT, 1.0);
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        Entity entitySource = source.getEntity();
        if (entitySource != null) {
            if (!(this.active && this.getTarget() != null || !(entitySource instanceof LivingEntity) || entitySource instanceof Player && ((Player)entitySource).isCreative() || entitySource instanceof EntityWroughtnaut)) {
                this.setTarget((LivingEntity)entitySource);
            }
            if (this.vulnerable) {
                float entityRelativeAngle;
                int arc = 220;
                float entityHitAngle = (float)((Math.atan2(entitySource.getZ() - this.getZ(), entitySource.getX() - this.getX()) * 57.29577951308232 - 90.0) % 360.0);
                float entityAttackingAngle = this.yBodyRot % 360.0f;
                if (entityHitAngle < 0.0f) {
                    entityHitAngle += 360.0f;
                }
                if (entityAttackingAngle < 0.0f) {
                    entityAttackingAngle += 360.0f;
                }
                if ((entityRelativeAngle = entityHitAngle - entityAttackingAngle) <= (float)arc / 2.0f && entityRelativeAngle >= (float)(-arc) / 2.0f || entityRelativeAngle >= 360.0f - (float)arc / 2.0f || entityRelativeAngle <= (float)(-arc) + 45.0f) {
                    this.playSound((SoundEvent)MMSounds.ENTITY_WROUGHT_UNDAMAGED.get(), 0.4f, 2.0f);
                    return false;
                }
                this.setAnimation(NO_ANIMATION);
                return super.hurt(source, amount);
            }
            this.playSound((SoundEvent)MMSounds.ENTITY_WROUGHT_UNDAMAGED.get(), 0.4f, 2.0f);
        } else if (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return super.hurt(source, amount);
        }
        return false;
    }

    @Override
    public Animation getDeathAnimation() {
        return DIE_ANIMATION;
    }

    @Override
    public Animation getHurtAnimation() {
        return HURT_ANIMATION;
    }

    public boolean displayFireAnimation() {
        return false;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    @Override
    public void tick() {
        super.tick();
        this.walkAnim.updatePrevTimer();
        if (this.getTarget() != null && (!this.getTarget().isAlive() || this.getTarget().getHealth() <= 0.0f)) {
            this.setTarget(null);
        }
        if (!this.level().isClientSide) {
            if (this.isAlwaysActive()) {
                this.setActive(true);
                this.active = true;
            } else if (this.getAnimation() == NO_ANIMATION && !this.isNoAi()) {
                if (this.isActive()) {
                    if (this.getTarget() == null && this.zza == 0.0f && this.isAtRestPos()) {
                        AnimationHandler.INSTANCE.sendAnimationMessage(this, DEACTIVATE_ANIMATION);
                        this.setActive(false);
                    }
                } else if (this.getTarget() != null && (double)this.targetDistance <= 4.5) {
                    AnimationHandler.INSTANCE.sendAnimationMessage(this, ACTIVATE_ANIMATION);
                    this.setActive(true);
                }
            }
        }
        if (!this.isActive()) {
            this.setDeltaMovement(0.0, this.getDeltaMovement().y, 0.0);
            this.setYRot(this.yRotO);
        }
        if (this.getAnimation() != NO_ANIMATION || !this.isActive()) {
            this.yHeadRot = this.yBodyRot = this.getYRot();
        }
        if (!this.isAlwaysActive() && this.getTarget() == null && this.getNavigation().isDone() && !this.isAtRestPos() && this.isActive()) {
            this.updateRestPos();
        }
        if (this.getAnimation() == ATTACK_ANIMATION && this.getAnimationTick() == 1) {
            this.swingDirection = this.random.nextBoolean();
        } else if (this.getAnimation() == ACTIVATE_ANIMATION) {
            int tick = this.getAnimationTick();
            if (tick == 1) {
                this.playSound((SoundEvent)MMSounds.ENTITY_WROUGHT_GRUNT_2.get(), 1.0f, 1.0f);
            } else if (tick == 27 || tick == 44) {
                this.playSound((SoundEvent)MMSounds.ENTITY_WROUGHT_STEP.get(), 0.5f, 0.5f);
            }
        } else if (this.getAnimation() == VERTICAL_ATTACK_ANIMATION && this.getAnimationTick() == 29) {
            this.doVerticalAttackHitFX();
        } else if (this.getAnimation() == STOMP_ATTACK_ANIMATION) {
            this.doStompFX();
        }
        float moveX = (float)(this.getX() - this.xo);
        float moveZ = (float)(this.getZ() - this.zo);
        float speed = Mth.sqrt((float)(moveX * moveX + moveZ * moveZ));
        if ((double)speed > 0.01) {
            if (this.getAnimation() == NO_ANIMATION) {
                this.walkAnim.increaseTimer();
            }
        } else {
            this.walkAnim.decreaseTimer();
        }
        if (this.getAnimation() != NO_ANIMATION) {
            this.walkAnim.decreaseTimer(2);
        }
        if (this.level().isClientSide && this.frame % 20 == 1 && (double)speed > 0.03 && this.getAnimation() == NO_ANIMATION && this.isActive()) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), (SoundEvent)MMSounds.ENTITY_WROUGHT_STEP.get(), this.getSoundSource(), 0.5f, 0.5f, false);
        }
        this.repelEntities(1.7f, 4.0f, 1.7f, 1.7f);
        if (!this.active && !this.level().isClientSide && this.getAnimation() != ACTIVATE_ANIMATION && ((Boolean)ConfigHandler.COMMON.MOBS.FERROUS_WROUGHTNAUT.healsOutOfBattle.get()).booleanValue()) {
            this.heal(0.3f);
        }
        if (this.disturbance != null && this.disturbance.update()) {
            this.disturbance = null;
        }
    }

    @Override
    protected void repelEntities(float x, float y, float z, float radius) {
        super.repelEntities(x, y, z, radius);
    }

    @Override
    public boolean canBePushedByEntity(Entity entity) {
        return false;
    }

    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    private boolean isAtRestPos() {
        Optional<BlockPos> restPos = this.getRestPos();
        if (restPos.isPresent()) {
            return restPos.get().distSqr((Vec3i)this.blockPosition()) < 36.0;
        }
        return false;
    }

    private void updateRestPos() {
        boolean reassign = true;
        if (this.getRestPos().isPresent()) {
            BlockPos pos = this.getRestPos().get();
            if (this.getNavigation().moveTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 0.2)) {
                reassign = false;
            }
        }
        if (reassign) {
            this.setRestPos(this.blockPosition());
        }
    }

    private void doVerticalAttackHitFX() {
        float strength;
        double theta = (double)(this.yBodyRot - 4.0f) * (Math.PI / 180);
        double perpX = Math.cos(theta);
        double perpZ = Math.sin(theta);
        double vecX = Math.cos(theta += 1.5707963267948966);
        double vecZ = Math.sin(theta);
        double x = this.getX() + 4.2 * vecX;
        double y = this.getBoundingBox().minY + 0.1;
        double z = this.getZ() + 4.2 * vecZ;
        int hitY = Mth.floor((double)(this.getY() - 0.2));
        for (int t = 0; t < VERTICAL_ATTACK_BLOCK_OFFSETS.length; ++t) {
            float ox = VERTICAL_ATTACK_BLOCK_OFFSETS[t][0];
            float oy = VERTICAL_ATTACK_BLOCK_OFFSETS[t][1];
            int hitX = Mth.floor((double)(x + (double)ox));
            int hitZ = Mth.floor((double)(z + (double)oy));
            BlockPos hit = new BlockPos(hitX, hitY, hitZ);
            BlockState block = this.level().getBlockState(hit);
            if (block.getRenderShape() == RenderShape.INVISIBLE) continue;
            for (int n = 0; n < 6; ++n) {
                double pa = this.random.nextDouble() * 2.0 * Math.PI;
                double pd = this.random.nextDouble() * 0.6 + 0.1;
                double px = x + Math.cos(pa) * pd;
                double pz = z + Math.sin(pa) * pd;
                double magnitude = this.random.nextDouble() * 4.0 + 5.0;
                double velX = perpX * magnitude;
                double velY = this.random.nextDouble() * 3.0 + 6.0;
                double velZ = perpZ * magnitude;
                if (vecX * (pz - this.getZ()) - vecZ * (px - this.getX()) > 0.0) {
                    velX = -velX;
                    velZ = -velZ;
                }
                this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, block), px, y, pz, velX, velY, velZ);
            }
        }
        int hitX = Mth.floor((double)x);
        int ceilY = Mth.floor((double)this.getBoundingBox().maxY);
        int hitZ = Mth.floor((double)z);
        int maxHeight = 5;
        int height = 5;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        while (height-- > 0) {
            pos.set(hitX, ceilY, hitZ);
            if (this.level().getBlockState((BlockPos)pos).blocksMotion()) break;
            ++ceilY;
        }
        if ((strength = (float)height / 5.0f) >= 0.0f) {
            int radius = Mth.ceil((float)(Mth.sqrt((float)(1.0f - strength * strength)) * 5.0f));
            this.disturbance = new CeilingDisturbance(hitX, ceilY, hitZ, radius, this.random.nextInt(5) + 3, this.random.nextInt(60) + 20);
        }
    }

    private void doStompFX() {
        double perpFacing = (double)this.yBodyRot * (Math.PI / 180);
        double facingAngle = perpFacing + 1.5707963267948966;
        int tick = this.getAnimationTick();
        int maxDistance = 6;
        if (tick > 9 && tick < 17) {
            if (tick == 12) {
                double infront = 1.47;
                double side = -0.21;
                double vx = Math.cos(facingAngle) * 1.47;
                double vz = Math.sin(facingAngle) * 1.47;
                double perpX = Math.cos(perpFacing);
                double perpZ = Math.sin(perpFacing);
                double fx = this.getX() + vx + perpX * -0.21;
                double fy = this.getBoundingBox().minY + 0.1;
                double fz = this.getZ() + vz + perpZ * -0.21;
                int amount = 16 + this.level().random.nextInt(8);
                while (amount-- > 0) {
                    double theta = this.level().random.nextDouble() * Math.PI * 2.0;
                    double dist = this.level().random.nextDouble() * 0.1 + 0.25;
                    double sx = Math.cos(theta);
                    double sz = Math.sin(theta);
                    double px = fx + sx * dist;
                    double py = fy + this.level().random.nextDouble() * 0.1;
                    double pz = fz + sz * dist;
                    this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, px, py, pz, sx * 0.065, 0.0, sz * 0.065);
                }
            }
            if (tick % 2 == 0) {
                int distance = tick / 2 - 2;
                double spread = Math.PI * 2;
                int arcLen = Mth.ceil((double)((double)distance * spread));
                for (int i = 0; i < arcLen; ++i) {
                    double theta = ((double)i / ((double)arcLen - 1.0) - 0.5) * spread + facingAngle;
                    double vx = Math.cos(theta);
                    double vz = Math.sin(theta);
                    double px = this.getX() + vx * (double)distance;
                    double pz = this.getZ() + vz * (double)distance;
                    float factor = 1.0f - (float)distance / 6.0f;
                    if (!this.level().random.nextBoolean()) continue;
                    int amount = this.level().random.nextInt(5);
                    while (amount-- > 0) {
                        double velX = vx * 0.075;
                        double velY = (double)factor * 0.3 + 0.025;
                        double velZ = vz * 0.075;
                        this.level().addParticle((ParticleOptions)ParticleTypes.CLOUD, px + (double)(this.level().random.nextFloat() * 2.0f) - 1.0, this.getBoundingBox().minY + 0.1 + (double)this.level().random.nextFloat() * 1.5, pz + (double)(this.level().random.nextFloat() * 2.0f) - 1.0, velX, velY, velZ);
                    }
                }
            }
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingData) {
        this.setRestPos(this.blockPosition());
        return super.finalizeSpawn(world, difficulty, reason, livingData);
    }

    public boolean requiresCustomPersistence() {
        return true;
    }

    @Override
    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(REST_POSITION, Optional.empty());
        builder.define(ACTIVE, (Object)false);
        builder.define(ALWAYS_ACTIVE, (Object)false);
    }

    public Optional<BlockPos> getRestPos() {
        return (Optional)this.getEntityData().get(REST_POSITION);
    }

    public void setRestPos(BlockPos pos) {
        this.getEntityData().set(REST_POSITION, Optional.of(pos));
    }

    public boolean isActive() {
        return (Boolean)this.getEntityData().get(ACTIVE);
    }

    public void setActive(boolean isActive) {
        this.getEntityData().set(ACTIVE, (Object)isActive);
    }

    public boolean isAlwaysActive() {
        return (Boolean)this.getEntityData().get(ALWAYS_ACTIVE);
    }

    public void setAlwaysActive(boolean isAlwaysActive) {
        this.getEntityData().set(ALWAYS_ACTIVE, (Object)isAlwaysActive);
        if (isAlwaysActive) {
            this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.2));
            this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
            this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        }
    }

    @Override
    public void writeSpawnData(@NotNull RegistryFriendlyByteBuf buffer) {
        super.writeSpawnData(buffer);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        Optional<BlockPos> restPos = this.getRestPos();
        restPos.ifPresent(pos -> compound.put("restPos", NbtUtils.writeBlockPos((BlockPos)pos)));
        compound.putBoolean("active", this.isActive());
        compound.putBoolean("alwaysActive", this.isAlwaysActive());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        NbtUtils.readBlockPos((CompoundTag)compound, (String)"restPos").ifPresent(this::setRestPos);
        this.setActive(compound.getBoolean("active"));
        this.active = this.isActive();
        this.setAlwaysActive(compound.getBoolean("alwaysActive"));
    }

    @Override
    protected ConfigHandler.CombatConfig getCombatConfig() {
        return ConfigHandler.COMMON.MOBS.FERROUS_WROUGHTNAUT.combatConfig;
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
    }

    @Override
    public Animation[] getAnimations() {
        return ANIMATIONS;
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        return LootTableHandler.FERROUS_WROUGHTNAUT;
    }

    @Override
    public boolean hasBossBar() {
        return (Boolean)ConfigHandler.COMMON.MOBS.FERROUS_WROUGHTNAUT.hasBossBar.get();
    }

    @Override
    public BossEvent.BossBarColor bossBarColor() {
        return BossEvent.BossBarColor.RED;
    }

    @Override
    public boolean hasBossMusic() {
        return true;
    }

    @Override
    public BossMusic<?> getBossMusic() {
        return BossMusicPlayer.FERROUS_WROUGHTNAUT_MUSIC;
    }

    @Override
    protected boolean canPlayMusic() {
        return super.canPlayMusic() && (this.active || this.getAnimation() == ACTIVATE_ANIMATION);
    }

    @Override
    public boolean resetHealthOnPlayerRespawn() {
        return (Boolean)ConfigHandler.COMMON.MOBS.FERROUS_WROUGHTNAUT.resetHealthWhenRespawn.get();
    }

    private class CeilingDisturbance {
        private final int ceilX;
        private final int ceilY;
        private final int ceilZ;
        private final int radius;
        private int delay;
        private int remainingTicks;
        private final int duration;

        public CeilingDisturbance(int x, int y, int z, int radius, int delay, int remainingTicks) {
            this.ceilX = x;
            this.ceilY = y;
            this.ceilZ = z;
            this.radius = radius;
            this.delay = delay;
            this.remainingTicks = remainingTicks;
            this.duration = remainingTicks;
        }

        public boolean update() {
            if (--this.delay > 0) {
                return false;
            }
            float t = (float)this.remainingTicks / (float)this.duration;
            int amount = Mth.ceil((float)((1.0f - Mth.sqrt((float)(1.0f - t * t))) * (float)this.radius * (float)this.radius * 0.15f));
            boolean playSound = true;
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            while (amount-- > 0) {
                double theta = EntityWroughtnaut.this.random.nextDouble() * Math.PI * 2.0;
                double dist = EntityWroughtnaut.this.random.nextDouble() * (double)this.radius;
                double x = (double)this.ceilX + Math.cos(theta) * dist;
                double y = (double)this.ceilY - 0.1 - EntityWroughtnaut.this.random.nextDouble() * 0.3;
                double z = (double)this.ceilZ + Math.sin(theta) * dist;
                int blockX = Mth.floor((double)x);
                int blockZ = Mth.floor((double)z);
                pos.set(blockX, this.ceilY, blockZ);
                BlockState block = EntityWroughtnaut.this.level().getBlockState((BlockPos)pos);
                if (block.getRenderShape() == RenderShape.INVISIBLE) continue;
                EntityWroughtnaut.this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.FALLING_DUST, block), x, y, z, 0.0, 0.0, 0.0);
                if (!playSound || !(EntityWroughtnaut.this.random.nextFloat() < 0.075f)) continue;
                SoundType sound = block.getBlock().getSoundType(block, (LevelReader)EntityWroughtnaut.this.level(), (BlockPos)pos, null);
                EntityWroughtnaut.this.level().playLocalSound(EntityWroughtnaut.this.getX(), EntityWroughtnaut.this.getY(), EntityWroughtnaut.this.getZ(), sound.getBreakSound(), SoundSource.BLOCKS, sound.getVolume() * 2.0f, sound.getPitch() * 0.6f, false);
                playSound = false;
            }
            return --this.remainingTicks <= 0;
        }
    }
}

