/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.umvuthana.trade;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public record Trade(ItemStack input, ItemStack output, int weight) {
    public static final Codec<Trade> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.CODEC.fieldOf("input").forGetter(Trade::input), (App)ItemStack.CODEC.fieldOf("output").forGetter(Trade::output), (App)Codec.INT.fieldOf("weight").forGetter(Trade::weight)).apply((Applicative)instance, Trade::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Trade> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, Trade::input, (StreamCodec)ItemStack.STREAM_CODEC, Trade::output, (StreamCodec)ByteBufCodecs.VAR_INT, Trade::weight, Trade::new);

    public ItemStack getInput() {
        return this.input.copy();
    }

    public ItemStack getOutput() {
        return this.output.copy();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Trade) {
            Trade otherTrade = (Trade)other;
            return this.weight == otherTrade.weight && ItemStack.matches((ItemStack)this.input, (ItemStack)otherTrade.input) && ItemStack.matches((ItemStack)this.output, (ItemStack)otherTrade.output);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 961 * this.input.hashCode() + 31 * this.output.hashCode() + this.weight;
    }

    public CompoundTag serialize(RegistryAccess access) {
        CompoundTag compound = new CompoundTag();
        compound.put("input", this.input.save((HolderLookup.Provider)access, (Tag)new CompoundTag()));
        compound.put("output", this.output.save((HolderLookup.Provider)access, (Tag)new CompoundTag()));
        compound.putInt("weight", this.weight);
        return compound;
    }

    public static Trade deserialize(RegistryAccess access, CompoundTag compound) {
        ItemStack input = ItemStack.parseOptional((HolderLookup.Provider)access, (CompoundTag)compound.getCompound("input"));
        ItemStack output = ItemStack.parseOptional((HolderLookup.Provider)access, (CompoundTag)compound.getCompound("output"));
        int weight = compound.getInt("weight");
        if (input.isEmpty() || output.isEmpty() || weight < 1) {
            return null;
        }
        return new Trade(input, output, weight);
    }
}

