/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.effects.geomancy;

import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieAnimationController;
import com.bobmowzie.mowziesmobs.client.particle.AdvancedTerrainParticle;
import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.bluff.EntityBluff;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityMagicEffect;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityGeomancyBase;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class EntityEarthSpike
extends EntityGeomancyBase {
    private boolean emerged = false;
    private int damageDelay = -1;
    protected MowzieAnimationController<EntityEarthSpike> controller = new MowzieAnimationController<EntityEarthSpike>(this, "controller", 0, this::predicate, 0.0);
    private static RawAnimation EMERGE = RawAnimation.begin().thenPlay("emerge");

    public EntityEarthSpike(EntityType<? extends EntityMagicEffect> type, Level worldIn) {
        super(type, worldIn);
    }

    public EntityEarthSpike(EntityType<? extends EntityMagicEffect> type, Level worldIn, LivingEntity caster, BlockState blockState) {
        super(type, worldIn, caster, blockState, null);
        this.setDeathTime(180);
        this.setTier(EntityGeomancyBase.GeomancyTier.SMALL);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.damageDelay >= 0) {
            --this.damageDelay;
        }
        if (!this.emerged) {
            this.emerged = true;
            this.damageDelay = 2;
            this.playSound((SoundEvent)MMSounds.ENTITY_BLUFF_SPIKE_EMERGE.get(), 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            if (this.level().isClientSide()) {
                for (int i = 0; i < 30; ++i) {
                    Vec3 offset = new Vec3(0.6 + (double)this.random.nextFloat() * 0.2, 0.1, 0.0).yRot(this.random.nextFloat() * (float)Math.PI * 2.0f);
                    Vec3 vel = offset.normalize().scale(this.random.nextGaussian() * 0.12).yRot(this.random.nextFloat() * 0.2f - 0.1f).add(0.0, this.random.nextDouble() * 0.45 + 0.2, 0.0).add(this.getForward().scale(0.1));
                    AdvancedTerrainParticle.spawnTerrainParticle(this.level(), ParticleHandler.TERRAIN, this.getX() + offset.x, this.getY(), this.getZ() + offset.z, vel.x, vel.y, vel.z, 0.0, (double)0.4f + this.random.nextGaussian() * 0.3, 0.94f, 25.0f + this.random.nextFloat() * 10.0f, this.getBlock(), new ParticleComponent[]{new ParticleComponent.Gravity(1.0f)});
                }
            }
        }
        if (this.damageDelay == 0 && !this.level().isClientSide()) {
            this.damageDelay = -1;
            List entitiesHit = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(0.4), e -> e.canBeHitByProjectile() && e != this.getCaster() && !(e instanceof ItemEntity));
            double damage = 10.0;
            if (this.getCaster() != null && this.getCaster() instanceof EntityBluff) {
                AttributeInstance attrib = this.getCaster().getAttribute(Attributes.ATTACK_DAMAGE);
                if (attrib != null) {
                    damage = attrib.getValue();
                }
                damage *= ((Double)ConfigHandler.COMMON.MOBS.BLUFF.combatConfig.attackMultiplier.get()).doubleValue();
            }
            for (Entity entity : entitiesHit) {
                if (this.getCaster() instanceof EntityBluff && entity instanceof EntityBluff || entity instanceof ItemEntity) continue;
                entity.hurt(this.damageSources().mobProjectile((Entity)this, this.getCaster()), (float)damage);
                float applyKnockbackResistance = 0.0f;
                if (entity instanceof LivingEntity) {
                    applyKnockbackResistance = (float)((LivingEntity)entity).getAttribute(Attributes.KNOCKBACK_RESISTANCE).getValue();
                }
                double y = 0.0;
                if (entity.onGround()) {
                    y += 0.15 * (double)(1.0f - applyKnockbackResistance);
                }
                entity.setDeltaMovement(entity.getDeltaMovement().add(0.0, y, 0.0));
                if (!(entity instanceof ServerPlayer)) continue;
                ((ServerPlayer)entity).connection.send((Packet)new ClientboundSetEntityMotionPacket(entity));
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.controller);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.emerged = compound.getBoolean("emerged");
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("emerged", this.emerged);
    }

    protected <E extends GeoEntity> PlayState predicate(AnimationState<E> event) {
        event.getController().setAnimation(EMERGE);
        return PlayState.CONTINUE;
    }

    @Override
    protected void explode() {
        super.explode();
    }
}

