/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.damage;

import com.bobmowzie.mowziesmobs.server.capability.DataHandler;
import com.bobmowzie.mowziesmobs.server.capability.LivingData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.tuple.Pair;

public class DamageUtil {
    public static Pair<Boolean, Boolean> dealMixedDamage(LivingEntity target, DamageSource source1, float amount1, DamageSource source2, float amount2) {
        boolean hit1;
        boolean flag2;
        if (target.level().isClientSide()) {
            return Pair.of((Object)false, (Object)false);
        }
        boolean flag1 = source1.getEntity() != null && target.isAlliedTo(source1.getEntity());
        boolean bl = flag2 = source2.getEntity() != null && target.isAlliedTo(source2.getEntity());
        if (flag1 || flag2) {
            return Pair.of((Object)false, (Object)false);
        }
        LivingData data = DataHandler.getData((Entity)target, DataHandler.LIVING_DATA);
        data.setLastDamage(-1.0f);
        float damageSoFar = 0.0f;
        float origLastDamage = target.lastHurt;
        boolean hit1Registered = hit1 = target.hurt(source1, amount1);
        if (data.getLastDamage() != -1.0f) {
            hit1Registered = true;
        }
        if (data.getLastDamage() != 0.0f) {
            damageSoFar += amount1;
        }
        target.lastHurt = Math.max(target.lastHurt - amount1, 0.0f);
        data.setLastDamage(-1.0f);
        boolean hit2 = target.hurt(source2, amount2);
        if (data.getLastDamage() != 0.0f) {
            damageSoFar += amount2;
        }
        target.lastHurt = origLastDamage;
        if (damageSoFar > target.lastHurt) {
            target.lastHurt = damageSoFar;
        }
        if (hit2 && hit1Registered) {
            DamageUtil.onHit2(target, source2);
            if (target instanceof Player) {
                SoundEvent sound = SoundEvents.PLAYER_HURT;
                if (source2.is(DamageTypeTags.IS_FIRE)) {
                    sound = SoundEvents.PLAYER_HURT_ON_FIRE;
                } else if (source2.is(DamageTypeTags.IS_DROWNING)) {
                    sound = SoundEvents.PLAYER_HURT_DROWN;
                }
                target.playSound(sound, 1.0f, DamageUtil.getSoundPitch(target));
            }
        }
        return Pair.of((Object)hit1, (Object)hit2);
    }

    private static float getSoundPitch(LivingEntity target) {
        return (target.getRandom().nextFloat() - target.getRandom().nextFloat()) * 0.2f + 1.0f;
    }

    private static void onHit2(LivingEntity target, DamageSource source) {
        if (source.is(DamageTypes.THORNS)) {
            target.level().broadcastEntityEvent((Entity)target, (byte)33);
        } else {
            byte b0 = source.is(DamageTypeTags.IS_DROWNING) ? (byte)36 : (source.is(DamageTypeTags.IS_FIRE) ? (byte)37 : 2);
            target.level().broadcastEntityEvent((Entity)target, b0);
        }
        Entity entity1 = source.getEntity();
        if (entity1 != null) {
            double d1 = entity1.getX() - target.getX();
            double d0 = entity1.getZ() - target.getZ();
            while (d1 * d1 + d0 * d0 < 1.0E-4) {
                d1 = (Math.random() - Math.random()) * 0.01;
                d0 = (Math.random() - Math.random()) * 0.01;
            }
            if (target instanceof Player) {
                ((Player)target).hurtDir = (float)(Mth.atan2((double)d0, (double)d1) * 57.29577951308232 - (double)target.getYRot());
            }
            target.knockback((double)0.4f, d1, d0);
        } else if (target instanceof Player) {
            ((Player)target).hurtDir = (int)(Math.random() * 2.0) * 180;
        }
    }
}

