/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.capability;

import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieGeoModel;
import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoPlayer;
import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import com.bobmowzie.mowziesmobs.server.entity.MowzieGeckoEntity;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;

public class AbilityData
implements INBTSerializable<CompoundTag> {
    SortedMap<AbilityType<?, ?>, Ability<?>> abilityInstances = new TreeMap();
    Ability<?> activeAbility = null;
    Map<String, Tag> nbtMap = new HashMap<String, Tag>();

    public void instanceAbilities(LivingEntity entity) {
        this.setActiveAbility(null);
        for (AbilityType<?, ?> abilityType : this.getAbilityTypesOnEntity(entity)) {
            Object ability = abilityType.makeInstance(entity);
            this.abilityInstances.put(abilityType, (Ability<?>)ability);
            if (!this.nbtMap.containsKey(abilityType.getName())) continue;
            ((Ability)ability).readNBT(this.nbtMap.get(abilityType.getName()));
        }
    }

    public void activateAbility(LivingEntity entity, AbilityType<?, ?> abilityType) {
        Ability ability = (Ability)this.abilityInstances.get(abilityType);
        if (ability != null) {
            boolean tryResult = ability.tryAbility();
            if (tryResult) {
                ability.start();
            }
        } else {
            System.out.println("Ability<?>" + abilityType.toString() + " does not exist on mob " + entity.getClass().getSimpleName());
        }
    }

    public void tick(LivingEntity entity) {
        for (Ability<?> ability : this.abilityInstances.values()) {
            ability.tick();
        }
    }

    public AbilityType<?, ?>[] getAbilityTypesOnEntity(LivingEntity entity) {
        if (entity instanceof Player) {
            return AbilityHandler.PLAYER_ABILITIES;
        }
        if (entity instanceof MowzieGeckoEntity) {
            return ((MowzieGeckoEntity)entity).getAbilities();
        }
        return new AbilityType[0];
    }

    public Map<AbilityType<?, ?>, Ability<?>> getAbilityMap() {
        return this.abilityInstances;
    }

    public Ability<?> getAbilityFromType(AbilityType<?, ?> abilityType) {
        return (Ability)this.abilityInstances.get(abilityType);
    }

    public Ability<?> getActiveAbility() {
        return this.activeAbility;
    }

    public void setActiveAbility(Ability<?> activeAbility) {
        if (this.getActiveAbility() != null && this.getActiveAbility().isUsing()) {
            this.getActiveAbility().interrupt();
        }
        this.activeAbility = activeAbility;
    }

    public Collection<Ability<?>> getAbilities() {
        return this.abilityInstances.values();
    }

    public boolean attackingPrevented() {
        return this.getActiveAbility() != null && this.getActiveAbility().preventsAttacking();
    }

    public boolean blockBreakingBuildingPrevented() {
        return this.getActiveAbility() != null && this.getActiveAbility().preventsBlockBreakingBuilding();
    }

    public boolean interactingPrevented() {
        return this.getActiveAbility() != null && this.getActiveAbility().preventsInteracting();
    }

    public boolean itemUsePrevented(ItemStack itemStack) {
        return this.getActiveAbility() != null && this.getActiveAbility().preventsItemUse(itemStack);
    }

    public <E extends GeoEntity> PlayState animationPredicate(AnimationState<E> e, GeckoPlayer.Perspective perspective) {
        return this.getActiveAbility().animationPredicate(e, perspective);
    }

    public void codeAnimations(MowzieGeoModel<? extends GeoEntity> model, float partialTick) {
        this.getActiveAbility().codeAnimations(model, partialTick);
    }

    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider lookup) {
        CompoundTag compound = new CompoundTag();
        for (Map.Entry<AbilityType<?, ?>, Ability<?>> abilityEntry : this.getAbilityMap().entrySet()) {
            CompoundTag nbt = abilityEntry.getValue().writeNBT();
            if (nbt.isEmpty()) continue;
            compound.put(abilityEntry.getKey().getName(), (Tag)nbt);
        }
        return compound;
    }

    public void deserializeNBT(@NotNull HolderLookup.Provider lookup, CompoundTag nbt) {
        Set keys = nbt.getAllKeys();
        for (String abilityName : keys) {
            this.nbtMap.put(abilityName, nbt.get(abilityName));
        }
    }
}

