/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.model.entity;

import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieGeoBone;
import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieGeoModel;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthana;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.MaskType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.data.EntityModelData;

public class ModelUmvuthana
extends MowzieGeoModel<EntityUmvuthana> {
    public ResourceLocation getModelResource(EntityUmvuthana object) {
        return ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"geo/umvuthana.geo.json");
    }

    public ResourceLocation getTextureResource(EntityUmvuthana entity) {
        boolean isElite = entity.getMaskType() == MaskType.FAITH || entity.getMaskType() == MaskType.FURY;
        return ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)(isElite ? "textures/entity/umvuthana_elite.png" : "textures/entity/umvuthana.png"));
    }

    public ResourceLocation getAnimationResource(EntityUmvuthana object) {
        return ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"animations/umvuthana.animation.json");
    }

    public void setCustomAnimations(EntityUmvuthana entity, long instanceId, AnimationState<EntityUmvuthana> animationState) {
        boolean isRaptor = entity.getMaskType() == MaskType.FURY;
        boolean isElite = entity.getMaskType() == MaskType.FAITH || isRaptor;
        this.getMowzieBone("crestRight").setHidden(!isElite);
        this.getMowzieBone("crestLeft").setHidden(!isElite);
        this.getMowzieBone("crest1").setHidden(!isElite);
        this.getMowzieBone("leftIndexTalon").setHidden(!isRaptor);
        this.getMowzieBone("leftIndexClaw").setHidden(isRaptor);
        this.getMowzieBone("rightIndexTalon").setHidden(!isRaptor);
        this.getMowzieBone("rightIndexClaw").setHidden(isRaptor);
        MowzieGeoBone root = this.getMowzieBone("root");
        if (isElite) {
            root.multiplyScale(0.93f, 0.93f, 0.93f);
        } else {
            root.multiplyScale(0.83f, 0.83f, 0.83f);
        }
        MowzieGeoBone mask = this.getMowzieBone("mask");
        MowzieGeoBone hips = this.getMowzieBone("hips");
        if (entity.getActiveAbilityType() != EntityUmvuthana.TELEPORT_ABILITY) {
            mask.setScale(1.0f / (float)hips.getScale().x, 1.0f / (float)hips.getScale().y, 1.0f / (float)hips.getScale().z);
        }
        if (entity.isAlive() && entity.active) {
            MowzieGeoBone head = this.getMowzieBone("head");
            MowzieGeoBone neck = this.getMowzieBone("neck");
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            float headYaw = Mth.wrapDegrees((float)entityData.netHeadYaw());
            float headPitch = Mth.wrapDegrees((float)entityData.headPitch());
            head.addRotX(headPitch * ((float)Math.PI / 180) / 2.0f);
            head.addRotY(headYaw * ((float)Math.PI / 180) / 2.0f);
            neck.addRotX(headPitch * ((float)Math.PI / 180) / 2.0f);
            neck.addRotY(headYaw * ((float)Math.PI / 180) / 2.0f);
        }
        MowzieGeoBone maskHand = this.getMowzieBone("maskHand");
        MowzieGeoBone maskTwitcher = this.getMowzieBone("maskTwitcher");
        float maskPlaceSwitch = this.getControllerValue("maskPlacementSwitchController");
        if ((double)maskPlaceSwitch == 1.0) {
            maskTwitcher.setHidden(true);
            maskHand.setHidden(false);
        } else {
            maskTwitcher.setHidden(false);
            maskHand.setHidden(true);
        }
        float animSpeed = 1.4f;
        float limbSwing = animationState.getLimbSwing();
        float limbSwingAmount = animationState.getLimbSwingAmount();
        Vec3 moveVec = entity.getDeltaMovement().normalize().yRot((float)Math.toRadians((double)entity.yBodyRot + 90.0));
        float forward = (float)Math.max(0.0, new Vec3(1.0, 0.0, 0.0).dot(moveVec));
        float backward = (float)Math.max(0.0, new Vec3(-1.0, 0.0, 0.0).dot(moveVec));
        float left = (float)Math.max(0.0, new Vec3(0.0, 0.0, -1.0).dot(moveVec));
        float right = (float)Math.max(0.0, new Vec3(0.0, 0.0, 1.0).dot(moveVec));
        limbSwingAmount *= 2.0f;
        limbSwingAmount = Math.min(0.7f, limbSwingAmount);
        float locomotionAnimController = this.getControllerValue("locomotionAnimController");
        float runAnim = this.getControllerValue("walkRunSwitchController");
        float walkAnim = 1.0f - runAnim;
        this.walkForwardAnim(forward * locomotionAnimController * walkAnim, limbSwing, limbSwingAmount, animSpeed);
        this.walkBackwardAnim(backward * locomotionAnimController * walkAnim, limbSwing, limbSwingAmount, animSpeed);
        this.walkLeftAnim(left * locomotionAnimController * walkAnim, limbSwing, limbSwingAmount, animSpeed);
        this.walkRightAnim(right * locomotionAnimController * walkAnim, limbSwing, limbSwingAmount, animSpeed);
        this.runAnim(locomotionAnimController * runAnim, limbSwing, limbSwingAmount, animSpeed);
    }

    private void runAnim(float blend, float limbSwing, float limbSwingAmount, float speed) {
        MowzieGeoBone head = this.getMowzieBone("head");
        MowzieGeoBone neck = this.getMowzieBone("neck");
        MowzieGeoBone hips = this.getMowzieBone("hips");
        MowzieGeoBone stomach = this.getMowzieBone("stomach");
        MowzieGeoBone chest = this.getMowzieBone("chest");
        MowzieGeoBone leftThigh = this.getMowzieBone("leftThigh");
        MowzieGeoBone leftShin = this.getMowzieBone("leftShin");
        MowzieGeoBone leftAnkle = this.getMowzieBone("leftAnkle");
        MowzieGeoBone leftFoot = this.getMowzieBone("leftFoot");
        MowzieGeoBone leftToesBack = this.getMowzieBone("leftToesBack");
        MowzieGeoBone rightThigh = this.getMowzieBone("rightThigh");
        MowzieGeoBone rightShin = this.getMowzieBone("rightShin");
        MowzieGeoBone rightAnkle = this.getMowzieBone("rightAnkle");
        MowzieGeoBone rightFoot = this.getMowzieBone("rightFoot");
        MowzieGeoBone rightToesBack = this.getMowzieBone("rightToesBack");
        MowzieGeoBone leftArm = this.getMowzieBone("leftArm");
        MowzieGeoBone leftForeArm = this.getMowzieBone("leftForeArm");
        MowzieGeoBone leftHand = this.getMowzieBone("leftHand");
        MowzieGeoBone rightArm = this.getMowzieBone("rightArm");
        MowzieGeoBone rightForeArm = this.getMowzieBone("rightForeArm");
        MowzieGeoBone rightHand = this.getMowzieBone("rightHand");
        float globalHeight = 1.5f;
        float globalDegree = 1.7f;
        speed = (float)((double)speed * 0.8);
        hips.addPosY(blend * (float)(Math.cos((double)(limbSwing * speed) - 1.7) * 2.0 * (double)globalHeight + (double)(4.0f * globalHeight)) * limbSwingAmount);
        hips.addRotX(blend * -0.4f * limbSwingAmount * globalHeight);
        hips.addRotY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.0) * (double)-0.1f * (double)globalHeight) * limbSwingAmount);
        chest.addRotY(blend * (float)(-Math.cos((double)(limbSwing * speed) * 0.5 + 1.0) * (double)-0.2f * (double)globalHeight) * limbSwingAmount);
        stomach.addRotX(blend * -((float)(Math.cos((double)(limbSwing * speed) + 1.4 - 1.7) * 0.025 * (double)globalHeight)) * limbSwingAmount);
        neck.addRotY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.0) * (double)-0.1f * (double)globalHeight) * limbSwingAmount);
        neck.addRotX(blend * -((float)(Math.cos((double)(limbSwing * speed) - 1.5) * 0.25 * (double)globalHeight - 0.2 * (double)globalHeight)) * limbSwingAmount);
        head.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed) + 0.175 - 1.7) * 0.25 * (double)globalHeight + 0.2 * (double)globalHeight) * limbSwingAmount);
        leftThigh.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.5) * (double)0.55f * (double)globalDegree) * limbSwingAmount);
        leftThigh.addRotY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.5) * (double)0.1f * (double)globalDegree - (double)0.2f) * limbSwingAmount);
        leftShin.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.5) * (double)-0.7f * (double)globalDegree) * limbSwingAmount);
        leftAnkle.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.5) * (double)1.1f * (double)globalDegree + (double)(0.1f * globalDegree)) * limbSwingAmount);
        leftFoot.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 3.5) * -1.0 * (double)globalDegree - (double)(1.1f * globalDegree)) * limbSwingAmount);
        leftToesBack.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 3.1) * (double)1.6f * (double)globalDegree + (double)(1.8f * globalDegree)) * limbSwingAmount);
        leftToesBack.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed * 1.0f) + 0.1) * (double)0.3f * (double)globalDegree) * limbSwingAmount);
        rightThigh.addRotX(blend * (float)(-Math.cos((double)(limbSwing * speed) * 0.5 + 1.5) * (double)0.55f * (double)globalDegree) * limbSwingAmount);
        rightThigh.addRotY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.5) * (double)0.1f * (double)globalDegree + (double)0.2f) * limbSwingAmount);
        rightShin.addRotX(blend * (float)(-Math.cos((double)(limbSwing * speed) * 0.5 + 2.5) * (double)-0.7f * (double)globalDegree) * limbSwingAmount);
        rightAnkle.addRotX(blend * (float)(-Math.cos((double)(limbSwing * speed) * 0.5 + 2.5) * (double)1.1f * (double)globalDegree + (double)(0.1f * globalDegree)) * limbSwingAmount);
        rightFoot.addRotX(blend * (float)(-Math.cos((double)(limbSwing * speed) * 0.5 + 3.5) * -1.0 * (double)globalDegree - (double)(1.1f * globalDegree)) * limbSwingAmount);
        rightToesBack.addRotX(blend * (float)(-Math.cos((double)(limbSwing * speed) * 0.5 + 3.1) * (double)1.6f * (double)globalDegree + (double)(1.8f * globalDegree)) * limbSwingAmount);
        rightToesBack.addRotX(blend * (float)(-Math.cos((double)(limbSwing * speed * 1.0f) + 0.1) * (double)0.3f * (double)globalDegree) * limbSwingAmount);
        leftArm.addRotY(blend * (float)(-(Math.cos((double)(limbSwing * speed) + 0.52) * 0.09 * (double)globalHeight)) * limbSwingAmount);
        leftArm.addRotZ(blend * (float)(Math.cos((double)(limbSwing * speed) + 0.52) * 0.09 * (double)globalHeight) * limbSwingAmount);
        leftForeArm.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed) - 1.0) * 0.05 * (double)globalHeight) * limbSwingAmount);
        rightArm.addRotY(blend * (float)(Math.cos((double)(limbSwing * speed) + 0.52) * 0.09 * (double)globalHeight) * limbSwingAmount);
        rightArm.addRotZ(blend * (float)(-(Math.cos((double)(limbSwing * speed) + 0.52) * 0.09 * (double)globalHeight)) * limbSwingAmount);
        rightForeArm.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed) - 1.0) * 0.05 * (double)globalHeight) * limbSwingAmount);
    }

    private void walkForwardAnim(float blend, float limbSwing, float limbSwingAmount, float speed) {
        MowzieGeoBone head = this.getMowzieBone("head");
        MowzieGeoBone neck = this.getMowzieBone("neck");
        MowzieGeoBone hips = this.getMowzieBone("hips");
        MowzieGeoBone stomach = this.getMowzieBone("stomach");
        MowzieGeoBone chest = this.getMowzieBone("chest");
        MowzieGeoBone leftThigh = this.getMowzieBone("leftThigh");
        MowzieGeoBone leftShin = this.getMowzieBone("leftShin");
        MowzieGeoBone leftAnkle = this.getMowzieBone("leftAnkle");
        MowzieGeoBone leftFoot = this.getMowzieBone("leftFoot");
        MowzieGeoBone leftToesBack = this.getMowzieBone("leftToesBack");
        MowzieGeoBone rightThigh = this.getMowzieBone("rightThigh");
        MowzieGeoBone rightShin = this.getMowzieBone("rightShin");
        MowzieGeoBone rightAnkle = this.getMowzieBone("rightAnkle");
        MowzieGeoBone rightFoot = this.getMowzieBone("rightFoot");
        MowzieGeoBone rightToesBack = this.getMowzieBone("rightToesBack");
        MowzieGeoBone leftArm = this.getMowzieBone("leftArm");
        MowzieGeoBone leftForeArm = this.getMowzieBone("leftForeArm");
        MowzieGeoBone leftHand = this.getMowzieBone("leftHand");
        MowzieGeoBone rightArm = this.getMowzieBone("rightArm");
        MowzieGeoBone rightForeArm = this.getMowzieBone("rightForeArm");
        MowzieGeoBone rightHand = this.getMowzieBone("rightHand");
        float globalHeight = 1.5f;
        float globalDegree = 1.5f;
        hips.addPosY(blend * (float)(Math.cos(limbSwing * speed) * 1.5 * (double)globalHeight) * limbSwingAmount);
        hips.addRotX(blend * -0.18f * limbSwingAmount * globalHeight);
        hips.addRotY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.0) * (double)-0.1f * (double)globalHeight) * limbSwingAmount);
        chest.addRotY(blend * (float)(-Math.cos((double)(limbSwing * speed) * 0.5 + 1.0) * (double)-0.2f * (double)globalHeight) * limbSwingAmount);
        stomach.addRotX(blend * -((float)(Math.cos((double)(limbSwing * speed) + 1.4) * 0.025 * (double)globalHeight)) * limbSwingAmount);
        neck.addRotY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.0) * (double)-0.1f * (double)globalHeight) * limbSwingAmount);
        neck.addRotX(blend * -((float)(Math.cos(limbSwing * speed) * 0.175 * (double)globalHeight)) * limbSwingAmount);
        head.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed) + 0.175) * 0.175 * (double)globalHeight + 0.18 * (double)globalHeight) * limbSwingAmount);
        leftThigh.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.5) * (double)0.55f * (double)globalDegree) * limbSwingAmount);
        leftThigh.addRotY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.5) * (double)0.1f * (double)globalDegree - (double)0.15f) * limbSwingAmount);
        leftShin.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.4) * (double)-0.7f * (double)globalDegree) * limbSwingAmount);
        leftAnkle.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.4) * (double)1.1f * (double)globalDegree + (double)(0.1f * globalDegree)) * limbSwingAmount);
        leftFoot.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.5) * (double)-1.3f * (double)globalDegree - (double)(0.4f * globalDegree)) * limbSwingAmount);
        leftFoot.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed * 1.0f) - 0.2) * (double)-0.2f * (double)globalDegree) * limbSwingAmount);
        leftToesBack.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 3.1) * (double)1.6f * (double)globalDegree + (double)(1.4f * globalDegree)) * limbSwingAmount);
        leftToesBack.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed * 1.0f) + 0.1) * (double)0.3f * (double)globalDegree) * limbSwingAmount);
        rightThigh.addRotX(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.5) * (double)0.55f * (double)globalDegree)) * limbSwingAmount);
        rightThigh.addRotY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.5) * (double)0.1f * (double)globalDegree + (double)0.15f) * limbSwingAmount);
        rightShin.addRotX(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.4) * (double)-0.7f * (double)globalDegree)) * limbSwingAmount);
        rightAnkle.addRotX(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.4) * (double)1.1f * (double)globalDegree - (double)(0.1f * globalDegree))) * limbSwingAmount);
        rightFoot.addRotX(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.5) * (double)-1.3f * (double)globalDegree + (double)(0.4f * globalDegree))) * limbSwingAmount);
        rightFoot.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed * 1.0f) - 0.2) * (double)-0.2f * (double)globalDegree) * limbSwingAmount);
        rightToesBack.addRotX(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 + 3.1) * (double)1.6f * (double)globalDegree - (double)(1.4f * globalDegree))) * limbSwingAmount);
        rightToesBack.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed * 1.0f) + 0.1) * (double)0.3f * (double)globalDegree) * limbSwingAmount);
        leftArm.addRotY(blend * (float)(-(Math.cos((double)(limbSwing * speed) + 0.52) * 0.0707 * (double)globalHeight)) * limbSwingAmount);
        leftArm.addRotZ(blend * (float)(Math.cos((double)(limbSwing * speed) + 0.52) * 0.0707 * (double)globalHeight) * limbSwingAmount);
        leftForeArm.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed) - 1.0) * 0.03 * (double)globalHeight) * limbSwingAmount);
        rightArm.addRotY(blend * (float)(Math.cos((double)(limbSwing * speed) + 0.52) * 0.0707 * (double)globalHeight) * limbSwingAmount);
        rightArm.addRotZ(blend * (float)(-(Math.cos((double)(limbSwing * speed) + 0.52) * 0.0707 * (double)globalHeight)) * limbSwingAmount);
        rightForeArm.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed) - 1.0) * 0.03 * (double)globalHeight) * limbSwingAmount);
    }

    private void walkBackwardAnim(float blend, float limbSwing, float limbSwingAmount, float speed) {
        MowzieGeoBone head = this.getMowzieBone("head");
        MowzieGeoBone neck = this.getMowzieBone("neck");
        MowzieGeoBone hips = this.getMowzieBone("hips");
        MowzieGeoBone stomach = this.getMowzieBone("stomach");
        MowzieGeoBone chest = this.getMowzieBone("chest");
        MowzieGeoBone leftThigh = this.getMowzieBone("leftThigh");
        MowzieGeoBone leftShin = this.getMowzieBone("leftShin");
        MowzieGeoBone leftAnkle = this.getMowzieBone("leftAnkle");
        MowzieGeoBone leftFoot = this.getMowzieBone("leftFoot");
        MowzieGeoBone leftToesBack = this.getMowzieBone("leftToesBack");
        MowzieGeoBone rightThigh = this.getMowzieBone("rightThigh");
        MowzieGeoBone rightShin = this.getMowzieBone("rightShin");
        MowzieGeoBone rightAnkle = this.getMowzieBone("rightAnkle");
        MowzieGeoBone rightFoot = this.getMowzieBone("rightFoot");
        MowzieGeoBone rightToesBack = this.getMowzieBone("rightToesBack");
        MowzieGeoBone leftArm = this.getMowzieBone("leftArm");
        MowzieGeoBone leftForeArm = this.getMowzieBone("leftForeArm");
        MowzieGeoBone leftHand = this.getMowzieBone("leftHand");
        MowzieGeoBone rightArm = this.getMowzieBone("rightArm");
        MowzieGeoBone rightForeArm = this.getMowzieBone("rightForeArm");
        MowzieGeoBone rightHand = this.getMowzieBone("rightHand");
        float globalHeight = 1.5f;
        float globalDegree = 1.5f;
        hips.addPosY(blend * (float)(Math.cos(limbSwing * speed) * 1.5 * (double)globalHeight) * limbSwingAmount);
        hips.addRotX(blend * 0.18f * limbSwingAmount * globalHeight);
        hips.addRotY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.0) * (double)0.1f * (double)globalHeight) * limbSwingAmount);
        chest.addRotY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.0) * (double)-0.2f * (double)globalHeight) * limbSwingAmount);
        stomach.addRotX(blend * -((float)(Math.cos((double)(limbSwing * speed) + 1.4) * 0.025 * (double)globalHeight)) * limbSwingAmount);
        neck.addRotY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.0) * (double)0.1f * (double)globalHeight) * limbSwingAmount);
        neck.addRotX(blend * -((float)(Math.cos(limbSwing * speed) * 0.175 * (double)globalHeight)) * limbSwingAmount);
        head.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed) + 0.175) * 0.175 * (double)globalHeight - 0.18 * (double)globalHeight) * limbSwingAmount);
        leftThigh.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 - 1.5) * (double)0.55f * (double)globalDegree - 0.3 * (double)globalDegree) * limbSwingAmount);
        leftThigh.addRotY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 - 1.5) * (double)0.1f * (double)globalDegree - (double)0.15f) * limbSwingAmount);
        leftShin.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 - 2.4) * (double)-0.7f * (double)globalDegree) * limbSwingAmount);
        leftAnkle.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 - 2.4) * (double)1.1f * (double)globalDegree + (double)(0.1f * globalDegree)) * limbSwingAmount);
        leftFoot.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 - 2.5) * (double)-1.3f * (double)globalDegree - (double)(0.4f * globalDegree)) * limbSwingAmount);
        leftFoot.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed * 1.0f) + 0.2) * (double)-0.2f * (double)globalDegree) * limbSwingAmount);
        leftToesBack.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 - 3.1) * (double)1.6f * (double)globalDegree + (double)(1.4f * globalDegree)) * limbSwingAmount);
        leftToesBack.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed * 1.0f) - 0.1) * (double)0.3f * (double)globalDegree) * limbSwingAmount);
        rightThigh.addRotX(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 - 1.5) * (double)0.55f * (double)globalDegree + 0.3 * (double)globalDegree)) * limbSwingAmount);
        rightThigh.addRotY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 - 1.5) * (double)0.1f * (double)globalDegree + (double)0.15f) * limbSwingAmount);
        rightShin.addRotX(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 - 2.4) * (double)-0.7f * (double)globalDegree)) * limbSwingAmount);
        rightAnkle.addRotX(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 - 2.4) * (double)1.1f * (double)globalDegree - (double)(0.1f * globalDegree))) * limbSwingAmount);
        rightFoot.addRotX(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 - 2.5) * (double)-1.3f * (double)globalDegree + (double)(0.4f * globalDegree))) * limbSwingAmount);
        rightFoot.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed * 1.0f) + 0.2) * (double)-0.2f * (double)globalDegree) * limbSwingAmount);
        rightToesBack.addRotX(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 - 3.1) * (double)1.6f * (double)globalDegree - (double)(1.4f * globalDegree))) * limbSwingAmount);
        rightToesBack.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed * 1.0f) - 0.1) * (double)0.3f * (double)globalDegree) * limbSwingAmount);
        leftArm.addRotY(blend * (float)(-(Math.cos((double)(limbSwing * speed) + 0.52) * 0.0707 * (double)globalHeight)) * limbSwingAmount);
        leftArm.addRotZ(blend * (float)(Math.cos((double)(limbSwing * speed) + 0.52) * 0.0707 * (double)globalHeight) * limbSwingAmount);
        leftForeArm.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed) - 1.0) * 0.03 * (double)globalHeight) * limbSwingAmount);
        rightArm.addRotY(blend * (float)(Math.cos((double)(limbSwing * speed) + 0.52) * 0.0707 * (double)globalHeight) * limbSwingAmount);
        rightArm.addRotZ(blend * (float)(-(Math.cos((double)(limbSwing * speed) + 0.52) * 0.0707 * (double)globalHeight)) * limbSwingAmount);
        rightForeArm.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed) - 1.0) * 0.03 * (double)globalHeight) * limbSwingAmount);
    }

    private void walkLeftAnim(float blend, float limbSwing, float limbSwingAmount, float speed) {
        MowzieGeoBone head = this.getMowzieBone("head");
        MowzieGeoBone neck = this.getMowzieBone("neck");
        MowzieGeoBone hips = this.getMowzieBone("hips");
        MowzieGeoBone stomach = this.getMowzieBone("stomach");
        MowzieGeoBone chest = this.getMowzieBone("chest");
        MowzieGeoBone leftThigh = this.getMowzieBone("leftThigh");
        MowzieGeoBone leftShin = this.getMowzieBone("leftShin");
        MowzieGeoBone leftAnkle = this.getMowzieBone("leftAnkle");
        MowzieGeoBone leftFoot = this.getMowzieBone("leftFoot");
        MowzieGeoBone leftToesBack = this.getMowzieBone("leftToesBack");
        MowzieGeoBone rightThigh = this.getMowzieBone("rightThigh");
        MowzieGeoBone rightShin = this.getMowzieBone("rightShin");
        MowzieGeoBone rightAnkle = this.getMowzieBone("rightAnkle");
        MowzieGeoBone rightFoot = this.getMowzieBone("rightFoot");
        MowzieGeoBone rightToesBack = this.getMowzieBone("rightToesBack");
        MowzieGeoBone leftArm = this.getMowzieBone("leftArm");
        MowzieGeoBone leftForeArm = this.getMowzieBone("leftForeArm");
        MowzieGeoBone leftHand = this.getMowzieBone("leftHand");
        MowzieGeoBone rightArm = this.getMowzieBone("rightArm");
        MowzieGeoBone rightForeArm = this.getMowzieBone("rightForeArm");
        MowzieGeoBone rightHand = this.getMowzieBone("rightHand");
        float globalHeight = 1.5f;
        float globalDegree = 1.5f;
        hips.addPosY(blend * (float)(Math.cos(limbSwing * speed) * 1.5 * (double)globalHeight) * limbSwingAmount);
        hips.addRotX(blend * -0.1f * limbSwingAmount * globalHeight);
        hips.addRotY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.0) * (double)-0.1f * (double)globalHeight) * limbSwingAmount);
        hips.addRotZ(blend * 0.08f * limbSwingAmount * globalHeight);
        chest.addRotY(blend * (float)(-Math.cos((double)(limbSwing * speed) * 0.5 + 1.0) * (double)-0.2f * (double)globalHeight) * limbSwingAmount);
        stomach.addRotX(blend * -((float)(Math.cos((double)(limbSwing * speed) + 1.4) * 0.025 * (double)globalHeight)) * limbSwingAmount);
        stomach.addRotZ(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.4) * 0.02 * (double)globalHeight)) * limbSwingAmount);
        stomach.addRotZ(blend * -((float)(Math.cos((double)(limbSwing * speed) - 0.5) * 0.02 * (double)globalHeight)) * limbSwingAmount);
        neck.addRotY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.0) * (double)-0.1f * (double)globalHeight) * limbSwingAmount);
        neck.addRotX(blend * -((float)(Math.cos(limbSwing * speed) * 0.175 * (double)globalHeight)) * limbSwingAmount);
        head.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed) + 0.175) * 0.175 * (double)globalHeight + 0.1 * (double)globalHeight) * limbSwingAmount);
        head.addRotZ(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.4) * 0.02 * (double)globalHeight) * limbSwingAmount);
        head.addRotZ(blend * (float)(Math.cos((double)(limbSwing * speed) - 0.5) * 0.02 * (double)globalHeight) * limbSwingAmount);
        head.addRotZ(blend * -0.03f * limbSwingAmount * globalHeight);
        leftThigh.addRotX(blend * -0.05f * limbSwingAmount * globalHeight);
        leftThigh.addRotZ(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.5) * (double)0.55f * (double)globalDegree + 0.05 * (double)globalDegree)) * limbSwingAmount);
        leftThigh.addRotY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.5) * (double)0.1f * (double)globalDegree - 0.15) * limbSwingAmount);
        leftShin.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.4) * (double)-0.7f * (double)globalDegree) * limbSwingAmount);
        leftAnkle.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.4) * (double)1.1f * (double)globalDegree + (double)(0.1f * globalDegree)) * limbSwingAmount);
        leftFoot.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.5) * (double)-1.3f * (double)globalDegree - (double)(0.6f * globalDegree)) * limbSwingAmount);
        leftFoot.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed * 1.0f) - 0.2) * (double)-0.2f * (double)globalDegree) * limbSwingAmount);
        leftFoot.addRotY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.5) * (double)-0.4f * (double)globalDegree) * limbSwingAmount);
        leftFoot.addRotY(blend * (float)(Math.cos((double)(limbSwing * speed * 1.0f) - 0.2) * (double)-0.2f * (double)globalDegree) * limbSwingAmount);
        leftToesBack.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 3.1) * (double)1.6f * (double)globalDegree + (double)(1.4f * globalDegree)) * limbSwingAmount);
        leftToesBack.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed * 1.0f) + 0.1) * (double)0.3f * (double)globalDegree) * limbSwingAmount);
        rightThigh.addRotX(blend * 0.05f * limbSwingAmount * globalHeight);
        rightThigh.addRotZ(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.5) * (double)0.55f * (double)globalDegree - 0.05 * (double)globalDegree) * limbSwingAmount);
        rightThigh.addRotY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.5) * (double)0.1f * (double)globalDegree + 0.15) * limbSwingAmount);
        rightShin.addRotX(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.4) * (double)-0.7f * (double)globalDegree)) * limbSwingAmount);
        rightAnkle.addRotX(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.4) * (double)1.1f * (double)globalDegree - (double)(0.1f * globalDegree))) * limbSwingAmount);
        rightFoot.addRotX(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.5) * (double)-1.3f * (double)globalDegree + (double)(0.6f * globalDegree))) * limbSwingAmount);
        rightFoot.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed * 1.0f) - 0.2) * (double)-0.2f * (double)globalDegree) * limbSwingAmount);
        rightFoot.addRotY(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.5) * (double)-0.4f * (double)globalDegree)) * limbSwingAmount);
        rightFoot.addRotY(blend * (float)(Math.cos((double)(limbSwing * speed * 1.0f) - 0.2) * (double)-0.2f * (double)globalDegree) * limbSwingAmount);
        rightToesBack.addRotX(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 + 3.1) * (double)1.6f * (double)globalDegree - (double)(1.4f * globalDegree))) * limbSwingAmount);
        rightToesBack.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed * 1.0f) + 0.1) * (double)0.3f * (double)globalDegree) * limbSwingAmount);
        leftShin.addRotX(blend * -((float)(Math.pow(Math.cos((double)limbSwing * 0.25 * (double)speed - 0.6), 12.0) * (double)0.6f * (double)globalHeight)) * limbSwingAmount);
        leftAnkle.addRotX(blend * (float)(Math.pow(Math.cos((double)limbSwing * 0.25 * (double)speed - 0.6), 12.0) * (double)0.6f * (double)globalHeight) * limbSwingAmount);
        leftArm.addRotY(blend * (float)(-(Math.cos((double)(limbSwing * speed) + 0.52) * 0.0707 * (double)globalHeight)) * limbSwingAmount);
        leftArm.addRotZ(blend * (float)(Math.cos((double)(limbSwing * speed) + 0.52) * 0.0707 * (double)globalHeight) * limbSwingAmount);
        leftForeArm.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed) - 1.0) * 0.03 * (double)globalHeight) * limbSwingAmount);
        rightArm.addRotY(blend * (float)(Math.cos((double)(limbSwing * speed) + 0.52) * 0.0707 * (double)globalHeight) * limbSwingAmount);
        rightArm.addRotZ(blend * (float)(-(Math.cos((double)(limbSwing * speed) + 0.52) * 0.0707 * (double)globalHeight)) * limbSwingAmount);
        rightForeArm.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed) - 1.0) * 0.03 * (double)globalHeight) * limbSwingAmount);
    }

    private void walkRightAnim(float blend, float limbSwing, float limbSwingAmount, float speed) {
        MowzieGeoBone head = this.getMowzieBone("head");
        MowzieGeoBone neck = this.getMowzieBone("neck");
        MowzieGeoBone hips = this.getMowzieBone("hips");
        MowzieGeoBone stomach = this.getMowzieBone("stomach");
        MowzieGeoBone chest = this.getMowzieBone("chest");
        MowzieGeoBone leftThigh = this.getMowzieBone("leftThigh");
        MowzieGeoBone leftShin = this.getMowzieBone("leftShin");
        MowzieGeoBone leftAnkle = this.getMowzieBone("leftAnkle");
        MowzieGeoBone leftFoot = this.getMowzieBone("leftFoot");
        MowzieGeoBone leftToesBack = this.getMowzieBone("leftToesBack");
        MowzieGeoBone rightThigh = this.getMowzieBone("rightThigh");
        MowzieGeoBone rightShin = this.getMowzieBone("rightShin");
        MowzieGeoBone rightAnkle = this.getMowzieBone("rightAnkle");
        MowzieGeoBone rightFoot = this.getMowzieBone("rightFoot");
        MowzieGeoBone rightToesBack = this.getMowzieBone("rightToesBack");
        MowzieGeoBone leftArm = this.getMowzieBone("leftArm");
        MowzieGeoBone leftForeArm = this.getMowzieBone("leftForeArm");
        MowzieGeoBone leftHand = this.getMowzieBone("leftHand");
        MowzieGeoBone rightArm = this.getMowzieBone("rightArm");
        MowzieGeoBone rightForeArm = this.getMowzieBone("rightForeArm");
        MowzieGeoBone rightHand = this.getMowzieBone("rightHand");
        float globalHeight = 1.5f;
        float globalDegree = 1.5f;
        hips.addPosY(blend * (float)(Math.cos(limbSwing * speed) * 1.5 * (double)globalHeight) * limbSwingAmount);
        hips.addRotX(blend * -0.1f * limbSwingAmount * globalHeight);
        hips.addRotY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.0) * (double)-0.1f * (double)globalHeight) * limbSwingAmount);
        hips.addRotZ(blend * -0.08f * limbSwingAmount * globalHeight);
        chest.addRotY(blend * (float)(-Math.cos((double)(limbSwing * speed) * 0.5 + 1.0) * (double)-0.2f * (double)globalHeight) * limbSwingAmount);
        stomach.addRotX(blend * -((float)(Math.cos((double)(limbSwing * speed) + 1.4) * 0.025 * (double)globalHeight)) * limbSwingAmount);
        stomach.addRotZ(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.4) * 0.02 * (double)globalHeight) * limbSwingAmount);
        stomach.addRotZ(blend * (float)(Math.cos((double)(limbSwing * speed) - 0.5) * 0.02 * (double)globalHeight) * limbSwingAmount);
        neck.addRotY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.0) * (double)-0.1f * (double)globalHeight) * limbSwingAmount);
        neck.addRotX(blend * -((float)(Math.cos(limbSwing * speed) * 0.175 * (double)globalHeight)) * limbSwingAmount);
        head.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed) + 0.175) * 0.175 * (double)globalHeight + 0.1 * (double)globalHeight) * limbSwingAmount);
        head.addRotZ(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.4) * 0.02 * (double)globalHeight)) * limbSwingAmount);
        head.addRotZ(blend * -((float)(Math.cos((double)(limbSwing * speed) - 0.5) * 0.02 * (double)globalHeight)) * limbSwingAmount);
        head.addRotZ(blend * 0.03f * limbSwingAmount * globalHeight);
        leftThigh.addRotX(blend * 0.05f * limbSwingAmount * globalHeight);
        leftThigh.addRotZ(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.5) * (double)0.55f * (double)globalDegree + 0.05 * (double)globalDegree) * limbSwingAmount);
        leftThigh.addRotY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.5) * (double)0.1f * (double)globalDegree - 0.15) * limbSwingAmount);
        leftShin.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.4) * (double)-0.7f * (double)globalDegree) * limbSwingAmount);
        leftAnkle.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.4) * (double)1.1f * (double)globalDegree + (double)(0.1f * globalDegree)) * limbSwingAmount);
        leftFoot.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.5) * (double)-1.3f * (double)globalDegree - (double)(0.6f * globalDegree)) * limbSwingAmount);
        leftFoot.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed * 1.0f) - 0.2) * (double)-0.2f * (double)globalDegree) * limbSwingAmount);
        leftFoot.addRotY(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.5) * (double)-0.4f * (double)globalDegree)) * limbSwingAmount);
        leftFoot.addRotY(blend * -((float)(Math.cos((double)(limbSwing * speed * 1.0f) - 0.2) * (double)-0.2f * (double)globalDegree)) * limbSwingAmount);
        leftToesBack.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 3.1) * (double)1.6f * (double)globalDegree + (double)(1.4f * globalDegree)) * limbSwingAmount);
        leftToesBack.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed * 1.0f) + 0.1) * (double)0.3f * (double)globalDegree) * limbSwingAmount);
        rightThigh.addRotX(blend * -0.05f * limbSwingAmount * globalHeight);
        rightThigh.addRotZ(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.5) * (double)0.55f * (double)globalDegree - 0.05 * (double)globalDegree)) * limbSwingAmount);
        rightThigh.addRotY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.5) * (double)0.1f * (double)globalDegree + 0.15) * limbSwingAmount);
        rightShin.addRotX(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.4) * (double)-0.7f * (double)globalDegree)) * limbSwingAmount);
        rightAnkle.addRotX(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.4) * (double)1.1f * (double)globalDegree - (double)(0.1f * globalDegree))) * limbSwingAmount);
        rightFoot.addRotX(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.5) * (double)-1.3f * (double)globalDegree + (double)(0.6f * globalDegree))) * limbSwingAmount);
        rightFoot.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed * 1.0f) - 0.2) * (double)-0.2f * (double)globalDegree) * limbSwingAmount);
        rightFoot.addRotY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.5) * (double)-0.4f * (double)globalDegree) * limbSwingAmount);
        rightFoot.addRotY(blend * -((float)(Math.cos((double)(limbSwing * speed * 1.0f) - 0.2) * (double)-0.2f * (double)globalDegree)) * limbSwingAmount);
        rightToesBack.addRotX(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 + 3.1) * (double)1.6f * (double)globalDegree - (double)(1.4f * globalDegree))) * limbSwingAmount);
        rightToesBack.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed * 1.0f) + 0.1) * (double)0.3f * (double)globalDegree) * limbSwingAmount);
        rightShin.addRotX(blend * -((float)(Math.pow(Math.cos((double)limbSwing * 0.25 * (double)speed - 0.6 + 1.5707963267948966), 12.0) * (double)0.6f * (double)globalHeight)) * limbSwingAmount);
        rightAnkle.addRotX(blend * (float)(Math.pow(Math.cos((double)limbSwing * 0.25 * (double)speed - 0.6 + 1.5707963267948966), 12.0) * (double)0.6f * (double)globalHeight) * limbSwingAmount);
        leftArm.addRotY(blend * (float)(-(Math.cos((double)(limbSwing * speed) + 0.52) * 0.0707 * (double)globalHeight)) * limbSwingAmount);
        leftArm.addRotZ(blend * (float)(Math.cos((double)(limbSwing * speed) + 0.52) * 0.0707 * (double)globalHeight) * limbSwingAmount);
        leftForeArm.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed) - 1.0) * 0.03 * (double)globalHeight) * limbSwingAmount);
        rightArm.addRotY(blend * (float)(Math.cos((double)(limbSwing * speed) + 0.52) * 0.0707 * (double)globalHeight) * limbSwingAmount);
        rightArm.addRotZ(blend * (float)(-(Math.cos((double)(limbSwing * speed) + 0.52) * 0.0707 * (double)globalHeight)) * limbSwingAmount);
        rightForeArm.addRotX(blend * (float)(Math.cos((double)(limbSwing * speed) - 1.0) * 0.03 * (double)globalHeight) * limbSwingAmount);
    }
}

