/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop;

import ht.treechop.TreeChopInternalAPI;
import ht.treechop.api.TreeChopAPI;
import ht.treechop.common.config.Lazy;
import ht.treechop.common.platform.Platform;
import ht.treechop.compat.HugeFungusHandler;
import ht.treechop.compat.HugeMushroomHandler;
import ht.treechop.compat.LeafDecayOverrides;
import ht.treechop.compat.ProblematicLeavesTreeHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TreeChop {
    public static final String MOD_ID = "treechop";
    public static final String MOD_NAME = "HT's TreeChop";
    public static final Logger LOGGER = LogManager.getLogger((String)"treechop");
    public static Platform platform;
    public static TreeChopInternalAPI api;
    private static int cryCounter;
    public static final ResourceLocation CHOP_WOOD;
    public static final Lazy<SoundEvent> CHOP_WOOD_EVENT;

    public static void initUsingAPI(TreeChopAPI api) {
        HugeMushroomHandler.register(api);
        HugeFungusHandler.register(api);
        ProblematicLeavesTreeHandler.register(api);
        LeafDecayOverrides.register(api);
    }

    public static void showText(String text) {
        Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)String.format("%s[%s] %s%s", ChatFormatting.GRAY, MOD_NAME, ChatFormatting.WHITE, text)), false);
    }

    public static ResourceLocation resource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static void cry(Throwable e) {
        if (cryCounter-- > 0) {
            LOGGER.error("Something went wrong - please share this log file at https://github.com/hammertater/treechop/issues", e);
        }
    }

    static {
        cryCounter = 10;
        CHOP_WOOD = TreeChop.resource("chop_wood");
        CHOP_WOOD_EVENT = new Lazy<SoundEvent>(() -> SoundEvent.createVariableRangeEvent((ResourceLocation)CHOP_WOOD));
    }
}

