/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pinguin.network;

import java.util.HashMap;
import net.mcreator.pinguin.WinterUpdateMod;
import net.mcreator.pinguin.procedures.Test10Procedure;
import net.mcreator.pinguin.procedures.Test1Procedure;
import net.mcreator.pinguin.procedures.Test22Procedure;
import net.mcreator.pinguin.procedures.Test3Procedure;
import net.mcreator.pinguin.procedures.Test4Procedure;
import net.mcreator.pinguin.procedures.Test5Procedure;
import net.mcreator.pinguin.procedures.Test6Procedure;
import net.mcreator.pinguin.procedures.Test7Procedure;
import net.mcreator.pinguin.procedures.Test8Procedure;
import net.mcreator.pinguin.procedures.Test9Procedure;
import net.mcreator.pinguin.world.inventory.VuMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record VuButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<VuButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"winter_update", (String)"vu_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, VuButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new VuButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<VuButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(VuButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                VuButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = VuMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            Test1Procedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            Test22Procedure.execute((Entity)entity);
        }
        if (buttonID == 8) {
            Test3Procedure.execute((Entity)entity);
        }
        if (buttonID == 12) {
            Test4Procedure.execute((Entity)entity);
        }
        if (buttonID == 16) {
            Test5Procedure.execute((Entity)entity);
        }
        if (buttonID == 20) {
            Test6Procedure.execute((Entity)entity);
        }
        if (buttonID == 24) {
            Test7Procedure.execute((Entity)entity);
        }
        if (buttonID == 28) {
            Test8Procedure.execute((Entity)entity);
        }
        if (buttonID == 32) {
            Test9Procedure.execute((Entity)entity);
        }
        if (buttonID == 36) {
            Test10Procedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        WinterUpdateMod.addNetworkMessage(TYPE, STREAM_CODEC, VuButtonMessage::handleData);
    }
}

