/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pinguin.network;

import java.util.HashMap;
import net.mcreator.pinguin.WinterUpdateMod;
import net.mcreator.pinguin.procedures.Fish1Procedure;
import net.mcreator.pinguin.procedures.Fish2Procedure;
import net.mcreator.pinguin.procedures.Fish3Procedure;
import net.mcreator.pinguin.procedures.Fish4Procedure;
import net.mcreator.pinguin.procedures.Fish5Procedure;
import net.mcreator.pinguin.world.inventory.FishinggMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record FishinggButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<FishinggButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"winter_update", (String)"fishingg_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, FishinggButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new FishinggButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<FishinggButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(FishinggButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                FishinggButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = FishinggMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            Fish1Procedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            Fish2Procedure.execute((Entity)entity);
        }
        if (buttonID == 8) {
            Fish3Procedure.execute((Entity)entity);
        }
        if (buttonID == 12) {
            Fish4Procedure.execute((Entity)entity);
        }
        if (buttonID == 16) {
            Fish5Procedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        WinterUpdateMod.addNetworkMessage(TYPE, STREAM_CODEC, FishinggButtonMessage::handleData);
    }
}

