/*
 * Decompiled with CFR 0.152.
 */
package artifacts.neoforge.data;

import artifacts.Artifacts;
import artifacts.neoforge.data.ConfiguredFeatures;
import artifacts.registry.ModFeatures;
import artifacts.world.placement.CampsiteCountPlacement;
import artifacts.world.placement.CampsiteHeightRangePlacement;
import artifacts.world.placement.CeilingHeightFilter;
import artifacts.world.placement.ConfigValueFilter;
import artifacts.world.placement.SurfaceFlatnessFilter;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.EnvironmentScanPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class PlacedFeatures {
    public static void create(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        Holder.Reference campsite = configuredFeatures.getOrThrow(ConfiguredFeatures.CAMPSITE);
        Holder.Reference minimalistCampsite = configuredFeatures.getOrThrow(ConfiguredFeatures.MINIMALIST_CAMPSITE);
        PlacedFeature undergroundCampsite = new PlacedFeature((Holder)campsite, PlacedFeatures.createModifiers(false));
        PlacedFeature undergroundMinimalistCampsite = new PlacedFeature((Holder)minimalistCampsite, PlacedFeatures.createModifiers(true));
        context.register(ModFeatures.UNDERGROUND_CAMPSITE, (Object)undergroundCampsite);
        context.register(ModFeatures.UNDERGROUND_MINIMALIST_CAMPSITE, (Object)undergroundMinimalistCampsite);
    }

    private static List<PlacementModifier> createModifiers(boolean isMinimalist) {
        return List.of(ConfigValueFilter.checkValue(Artifacts.CONFIG.general.campsite.minimalistCampsites, isMinimalist), CampsiteCountPlacement.campsiteCount(), RarityFilter.onAverageOnceEvery((int)10), InSquarePlacement.spread(), CampsiteHeightRangePlacement.campsiteHeightRange(), EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)8), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1)), CeilingHeightFilter.maxCeilingHeight(6), SurfaceFlatnessFilter.checkSurfaceFlatness(), BiomeFilter.biome());
    }
}

