/*
 * Decompiled with CFR 0.152.
 */
package net.combatroll.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.combatroll.client.CombatRollClient;
import net.combatroll.client.Keybindings;
import net.combatroll.client.gui.Drawable;
import net.combatroll.client.gui.HudElement;
import net.combatroll.client.gui.HudKeyVisuals;
import net.combatroll.config.ClientConfig;
import net.combatroll.config.HudConfig;
import net.combatroll.internals.RollManager;
import net.combatroll.internals.RollingEntity;
import net.combatroll.mixin.client.KeybindingAccessor;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;

public class HudRenderHelper {
    private static final ResourceLocation ARROW = new ResourceLocation("combatroll", "textures/hud/arrow.png");
    private static final ResourceLocation ARROW_BACKGROUND = new ResourceLocation("combatroll", "textures/hud/arrow_background.png");

    public static void render(GuiGraphics context, float tickDelta) {
        ViewModel viewModel;
        ClientConfig config = CombatRollClient.config;
        Minecraft client = Minecraft.m_91087_();
        LocalPlayer player = client.f_91074_;
        if (player == null) {
            viewModel = ViewModel.mock();
        } else {
            if (player.m_7500_() && !config.showHUDInCreative) {
                return;
            }
            if (player.m_5833_()) {
                return;
            }
            RollingEntity rollingPlayer = (RollingEntity)player;
            RollManager.CooldownInfo cooldownInfo = rollingPlayer.getRollManager().getCooldown();
            if (!config.showWhenFull && cooldownInfo.availableRolls() == cooldownInfo.maxRolls()) {
                return;
            }
            viewModel = ViewModel.create(cooldownInfo, tickDelta);
        }
        int screenWidth = client.m_91268_().m_85445_();
        int screenHeight = client.m_91268_().m_85446_();
        HudElement rollWidget = ((HudConfig)CombatRollClient.hudConfig.value).rollWidget;
        Vec2 originPoint = rollWidget.origin.getPoint(screenWidth, screenHeight);
        Vec2 drawOffset = rollWidget.offset;
        int horizontalSpacing = 8;
        int biggestTextureSize = 15;
        int widgetWidth = biggestTextureSize + horizontalSpacing * viewModel.elements.size();
        int widgetHeight = biggestTextureSize;
        int drawX = (int)(originPoint.f_82470_ + drawOffset.f_82470_);
        int drawY = (int)(originPoint.f_82471_ + drawOffset.f_82471_ - (float)(widgetHeight / 2));
        int drawnWith = 0;
        RenderSystem.enableBlend();
        for (ViewModel.Element element : viewModel.elements()) {
            int x = 0;
            int y = 0;
            boolean u = false;
            int v = 0;
            int width = 0;
            int height = 0;
            int textureSize = 0;
            x = drawX + drawnWith;
            y = drawY;
            u = false;
            v = 0;
            textureSize = 15;
            height = 15;
            width = 15;
            context.m_280246_(1.0f, 1.0f, 1.0f, (float)config.hudBackgroundOpacity / 100.0f);
            context.m_280163_(ARROW_BACKGROUND, x, y, (float)u, (float)v, width, height, textureSize, textureSize);
            int color = element.color;
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            int prevTextureSize = textureSize;
            textureSize = 13;
            int shift = (prevTextureSize - textureSize) / 2;
            width = textureSize;
            height = Math.round(element.full * (float)textureSize);
            x = drawX + drawnWith + shift;
            y = drawY + textureSize - height + shift;
            u = false;
            v = textureSize - height;
            context.m_280246_(red, green, blue, element.full);
            context.m_280163_(ARROW, x, y, (float)u, (float)v, width, height, textureSize, textureSize);
            drawnWith += horizontalSpacing;
        }
        context.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        if (config.showKeybinding) {
            Font textRenderer = client.f_91065_.m_93082_();
            int keybindingX = drawX + drawnWith / 2;
            int keybindingY = drawY + 1;
            Drawable.Anchor iconHAnchor = Drawable.Anchor.CENTER;
            Drawable.Anchor iconVAnchor = Drawable.Anchor.TRAILING;
            switch (config.keybindingLabelPosition) {
                case TOP: {
                    break;
                }
                case LEFT: {
                    keybindingX = drawX;
                    keybindingY = drawY + widgetHeight / 2;
                    iconHAnchor = Drawable.Anchor.TRAILING;
                    iconVAnchor = Drawable.Anchor.CENTER;
                }
            }
            if (viewModel.drawable != null) {
                viewModel.drawable.draw(context, keybindingX, keybindingY, iconHAnchor, iconVAnchor);
            } else if (viewModel.label != null) {
                String label = viewModel.label;
                int textLength = textRenderer.m_92895_(label);
                int buttonLength = textLength + HudKeyVisuals.buttonLeading.draw().width() + HudKeyVisuals.buttonTrailing.draw().width();
                if (iconHAnchor == Drawable.Anchor.TRAILING) {
                    keybindingX -= buttonLength / 2;
                }
                HudKeyVisuals.buttonLeading.draw(context, keybindingX - textLength / 2, keybindingY, Drawable.Anchor.TRAILING, iconVAnchor);
                HudKeyVisuals.buttonCenter.drawFlexibleWidth(context, keybindingX - textLength / 2, keybindingY, textLength, iconVAnchor);
                HudKeyVisuals.buttonTrailing.draw(context, keybindingX + textLength / 2, keybindingY, Drawable.Anchor.LEADING, iconVAnchor);
                Objects.requireNonNull(textRenderer);
                int textHeight = 9 + 1;
                int textY = keybindingY;
                switch (iconVAnchor) {
                    case LEADING: {
                        break;
                    }
                    case TRAILING: {
                        textY -= textHeight;
                        break;
                    }
                    case CENTER: {
                        textY -= textHeight / 2 - 1;
                    }
                }
                context.m_280137_(textRenderer, label, keybindingX, textY, 0xFFFFFF);
            }
        }
        context.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private record ViewModel(List<Element> elements, String label, @Nullable Drawable.Component drawable) {
        static ViewModel create(RollManager.CooldownInfo info, float tickDelta) {
            ClientConfig config = CombatRollClient.config;
            ArrayList<Element> elements = new ArrayList<Element>();
            for (int i = 0; i < info.maxRolls(); ++i) {
                int color = config.hudArrowColor;
                float full = 0.0f;
                if (i == info.availableRolls()) {
                    int sparkleTicks;
                    int missingTicks;
                    full = (float)info.elapsed() / (float)info.total();
                    full = Math.min(full, 1.0f);
                    if (config.playCooldownFlash && (missingTicks = info.total() - info.elapsed()) <= (sparkleTicks = 2)) {
                        float sparkle = (float)(sparkleTicks / 2) - ((float)(missingTicks - 1) + (1.0f - tickDelta)) / (float)sparkleTicks;
                        float red = (float)(color >> 16 & 0xFF) / 255.0f;
                        float green = (float)(color >> 8 & 0xFF) / 255.0f;
                        float blue = (float)(color & 0xFF) / 255.0f;
                        int redBits = (int)(ViewModel.mixNumberFloat(red, 1.0f, sparkle) * 255.0f);
                        int greenBits = (int)(ViewModel.mixNumberFloat(green, 1.0f, sparkle) * 255.0f);
                        int blueBits = (int)(ViewModel.mixNumberFloat(blue, 1.0f, sparkle) * 255.0f);
                        color = redBits;
                        color = (color << 8) + greenBits;
                        color = (color << 8) + blueBits;
                    }
                }
                if (i < info.availableRolls()) {
                    full = 1.0f;
                }
                elements.add(new Element(color, full));
            }
            KeyMapping keybinding = Keybindings.roll;
            String key = ((KeybindingAccessor)keybinding).getBoundKey().toString();
            Drawable.Component drawable = HudKeyVisuals.custom.get(key);
            String label = keybinding.m_90863_().getString().toUpperCase(Locale.US);
            label = ViewModel.acronym(label, 3);
            return new ViewModel(elements, label, drawable);
        }

        static ViewModel mock() {
            ClientConfig config = CombatRollClient.config;
            int color = config.hudArrowColor;
            return new ViewModel(List.of(new Element(color, 1.0f), new Element(color, 0.5f), new Element(color, 0.0f)), "R", null);
        }

        private static float mixNumberFloat(float a, float b, float bias) {
            return a + (b - a) * bias;
        }

        private static String acronym(String phrase, int maxLength) {
            StringBuilder result = new StringBuilder();
            for (String token : phrase.split("\\s+")) {
                result.append(token.toUpperCase().charAt(0));
            }
            String resultString = result.toString();
            if (resultString.length() > maxLength) {
                resultString = resultString.substring(0, maxLength);
            }
            return result.toString();
        }

        record Element(int color, float full) {
        }
    }
}

