/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.registry;

import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import quek.undergarden.capability.IUndergardenPortal;
import quek.undergarden.capability.UndergardenPortalCapability;

@Mod.EventBusSubscriber(modid="undergarden")
public class UndergardenCapabilities {
    public static final Capability<IUndergardenPortal> UNDERGARDEN_PORTAL_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IUndergardenPortal>(){});

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            UndergardenPortalCapability portal = new UndergardenPortalCapability(player);
            final LazyOptional capability = LazyOptional.of(() -> portal);
            ICapabilityProvider provider = new ICapabilityProvider(){

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                    return UNDERGARDEN_PORTAL_CAPABILITY.orEmpty(cap, capability);
                }
            };
            event.addCapability(new ResourceLocation("undergarden", "portal"), provider);
        }
    }
}

