/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.render.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import org.joml.Quaternionf;
import quek.undergarden.entity.UGBoat;

public class UGBoatRenderer
extends EntityRenderer<UGBoat> {
    private final Map<UGBoat.Type, Pair<ResourceLocation, BoatModel>> boatResources;

    public UGBoatRenderer(EntityRendererProvider.Context context, boolean chest) {
        super(context);
        this.f_114477_ = 0.8f;
        this.boatResources = (Map)Stream.of(UGBoat.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)new ResourceLocation("undergarden", UGBoatRenderer.getTextureLocation(type, chest)), (Object)this.createBoatModel(context, (UGBoat.Type)((Object)type), chest))));
    }

    private static ModelLayerLocation createLocation(String path, String model) {
        return new ModelLayerLocation(new ResourceLocation("undergarden", path), model);
    }

    public static ModelLayerLocation createBoatModelName(UGBoat.Type pType) {
        return UGBoatRenderer.createLocation("boat/" + pType.getName(), "main");
    }

    public static ModelLayerLocation createChestBoatModelName(UGBoat.Type type) {
        return UGBoatRenderer.createLocation("chest_boat/" + type.getName(), "main");
    }

    private BoatModel createBoatModel(EntityRendererProvider.Context context, UGBoat.Type type, boolean chest) {
        ModelLayerLocation modellayerlocation = chest ? UGBoatRenderer.createChestBoatModelName(type) : UGBoatRenderer.createBoatModelName(type);
        ModelPart modelpart = context.m_174023_(modellayerlocation);
        return chest ? new ChestBoatModel(modelpart) : new BoatModel(modelpart);
    }

    private static String getTextureLocation(UGBoat.Type type, boolean chest) {
        return chest ? "textures/entity/chest_boat/" + type.getName() + ".png" : "textures/entity/boat/" + type.getName() + ".png";
    }

    public void render(UGBoat entity, float yaw, float partialTicks, PoseStack stack, MultiBufferSource bufferSource, int light) {
        float bubbleAngle;
        stack.m_85836_();
        stack.m_85837_(0.0, 0.375, 0.0);
        stack.m_252781_(Axis.f_252436_.m_252977_(180.0f - yaw));
        float f = (float)entity.m_38385_() - partialTicks;
        float f1 = entity.m_38384_() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            stack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)f) * f * f1 / 10.0f * (float)entity.m_38386_()));
        }
        if (!Mth.m_14033_((float)(bubbleAngle = entity.m_38352_(partialTicks)), (float)0.0f)) {
            stack.m_252781_(new Quaternionf().setAngleAxis(entity.m_38352_(partialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<ResourceLocation, BoatModel> boatResources = this.boatResources.get((Object)entity.getUGBoatType());
        ResourceLocation texture = (ResourceLocation)boatResources.getFirst();
        BoatModel boat = (BoatModel)boatResources.getSecond();
        stack.m_85841_(-1.0f, -1.0f, 1.0f);
        stack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        boat.m_6973_((Boat)entity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = bufferSource.m_6299_(boat.m_103119_(texture));
        boat.m_7695_(stack, vertexconsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!entity.m_5842_()) {
            VertexConsumer vertexconsumer1 = bufferSource.m_6299_(RenderType.m_110478_());
            boat.m_102282_().m_104301_(stack, vertexconsumer1, light, OverlayTexture.f_118083_);
        }
        stack.m_85849_();
        super.m_7392_((Entity)entity, yaw, partialTicks, stack, bufferSource, light);
    }

    public ResourceLocation getTextureLocation(UGBoat entity) {
        return (ResourceLocation)this.boatResources.get((Object)entity.getUGBoatType()).getFirst();
    }
}

