/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.attributesmod.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.player.Player;
import net.puffish.attributesmod.api.DynamicModification;
import net.puffish.attributesmod.api.PuffishAttributes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class}, priority=1100)
public abstract class PlayerEntityMixin {
    private static final double VANILLA_KNOCKBACK = 0.4;

    @ModifyExpressionValue(method={"createPlayerAttributes"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;createLivingAttributes()Lnet/minecraft/entity/attribute/DefaultAttributeContainer$Builder;")})
    private static AttributeSupplier.Builder modifyExpressionValueAtCreateLivingAttributes(AttributeSupplier.Builder builder) {
        return builder.m_22266_(PuffishAttributes.STAMINA).m_22266_(PuffishAttributes.FORTUNE).m_22266_(PuffishAttributes.MINING_SPEED).m_22266_(PuffishAttributes.BREAKING_SPEED).m_22266_(PuffishAttributes.PICKAXE_SPEED).m_22266_(PuffishAttributes.AXE_SPEED).m_22266_(PuffishAttributes.SHOVEL_SPEED).m_22266_(PuffishAttributes.SPRINTING_SPEED).m_22266_(PuffishAttributes.KNOCKBACK).m_22266_(PuffishAttributes.REPAIR_COST).m_22266_(PuffishAttributes.NATURAL_REGENERATION).m_22266_(PuffishAttributes.TAMED_DAMAGE).m_22266_(PuffishAttributes.TAMED_RESISTANCE).m_22266_(PuffishAttributes.EXPERIENCE);
    }

    @Inject(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/enchantment/EnchantmentHelper;onTargetDamaged(Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/entity/Entity;)V")})
    private void injectAtAttack(Entity target, CallbackInfo ci) {
        Player player = (Player)this;
        double knockback = DynamicModification.create().withPositive(PuffishAttributes.KNOCKBACK, (LivingEntity)player).applyTo(0.4) - 0.4;
        float yaw = player.m_146908_() * ((float)Math.PI / 180);
        float sin = Mth.m_14031_((float)yaw);
        float cos = Mth.m_14089_((float)yaw);
        if (target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            livingEntity.m_147240_(knockback, (double)sin, (double)(-cos));
        } else {
            target.m_5997_((double)(-sin) * knockback, 0.0, (double)cos * knockback);
        }
    }

    @ModifyReturnValue(method={"getMovementSpeed()F"}, at={@At(value="RETURN")})
    private float injectAtGetMovementSpeed(float speed) {
        Player player = (Player)this;
        if (!player.m_20142_()) {
            return speed;
        }
        return DynamicModification.create().withPositive(PuffishAttributes.SPRINTING_SPEED, (LivingEntity)player).applyTo(speed);
    }

    @Inject(method={"getBlockBreakingSpeed", "getDigSpeed"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/effect/StatusEffectUtil;hasHaste(Lnet/minecraft/entity/LivingEntity;)Z")})
    private void injectAtGetBlockBreakingSpeed(CallbackInfoReturnable<Float> cir, @Local LocalFloatRef speed) {
        Player player = (Player)this;
        speed.set(DynamicModification.create().withPositive(PuffishAttributes.BREAKING_SPEED, (LivingEntity)player).applyTo(speed.get()));
    }
}

