/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.dimpaintings.config;

import com.mrbysco.dimpaintings.DimPaintings;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

public class DimensionalConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        DimPaintings.LOGGER.debug("Loaded Dimensional Painting's config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        DimPaintings.LOGGER.debug("Dimensional Painting's config just got changed on the file system!");
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue overworldToBed;
        public final ForgeConfigSpec.IntValue netherMaxY;
        public final ForgeConfigSpec.IntValue teleportCooldown;
        public final ForgeConfigSpec.BooleanValue disableNetherPortal;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("General settings").push("General");
            this.overworldToBed = builder.comment("Dictates if the overworld painting will teleport you back to your spawnpoint / bed (Similar to teleporting from the End to the Overworld)").define("overworldToBed", false);
            this.netherMaxY = builder.comment(new String[]{"Dictates the max Y at which the Nether Painting will place you in the Nether", "[For a vanilla nether it's recommended to keep the value between 10 and 120", "[51 = Spawn in a bubble at Y 50 if nothing] (Default: 120)"}).defineInRange("netherMaxY", 120, -2048, 2048);
            this.teleportCooldown = builder.comment("Amount of seconds between being able to teleport (Default: 4)").defineInRange("teleportCooldown", 4, 0, Integer.MAX_VALUE);
            this.disableNetherPortal = builder.comment("Disable nether portal creation (Default: false)").define("disableNetherPortal", false);
            builder.pop();
        }
    }
}

