/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.AdventureConfig;
import dev.shadowsoffire.apotheosis.adventure.loot.GemLootPoolEntry;
import dev.shadowsoffire.apotheosis.adventure.loot.LootController;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;

public class AffixLootModifier
extends LootModifier {
    public static final Codec<AffixLootModifier> CODEC = RecordCodecBuilder.create(inst -> AffixLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, AffixLootModifier::new));

    protected AffixLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (!Apotheosis.enableAdventure) {
            return generatedLoot;
        }
        for (AdventureConfig.LootPatternMatcher m : AdventureConfig.AFFIX_ITEM_LOOT_RULES) {
            if (!m.matches(context.getQueriedLootTableId())) continue;
            if (!(context.m_230907_().m_188501_() <= m.chance())) break;
            Player player = GemLootPoolEntry.findPlayer(context);
            if (player == null) {
                return generatedLoot;
            }
            ItemStack affixItem = LootController.createRandomLootItem(context.m_230907_(), null, player, (ServerLevelAccessor)context.m_78952_());
            if (affixItem.m_41619_()) break;
            affixItem.m_41783_().m_128379_("apoth_rchest", true);
            generatedLoot.add((Object)affixItem);
            break;
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

