/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.boss;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.AdventureConfig;
import dev.shadowsoffire.apotheosis.adventure.AdventureModule;
import dev.shadowsoffire.apotheosis.adventure.boss.ApothBoss;
import dev.shadowsoffire.apotheosis.adventure.boss.BossStats;
import dev.shadowsoffire.apotheosis.adventure.boss.Exclusion;
import dev.shadowsoffire.apotheosis.adventure.boss.MinibossRegistry;
import dev.shadowsoffire.apotheosis.adventure.compat.GameStagesCompat;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.util.NameHelper;
import dev.shadowsoffire.apotheosis.util.SupportingEntity;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.json.ChancedEffectInstance;
import dev.shadowsoffire.placebo.json.GearSet;
import dev.shadowsoffire.placebo.json.GearSetRegistry;
import dev.shadowsoffire.placebo.json.NBTAdapter;
import dev.shadowsoffire.placebo.json.RandomAttributeModifier;
import dev.shadowsoffire.placebo.reload.WeightedDynamicRegistry;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public final class ApothMiniboss
implements CodecProvider<ApothMiniboss>,
WeightedDynamicRegistry.ILuckyWeighted,
WeightedDynamicRegistry.IDimensional,
GameStagesCompat.IStaged,
MinibossRegistry.IEntityMatch {
    public static final String NAME_GEN = "use_name_generation";
    public static final Codec<ApothMiniboss> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("weight").forGetter(WeightedDynamicRegistry.ILuckyWeighted::getWeight), (App)PlaceboCodecs.nullableField((Codec)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE), (String)"quality", (Object)Float.valueOf(0.0f)).forGetter(WeightedDynamicRegistry.ILuckyWeighted::getQuality), (App)ExtraCodecs.f_184349_.fieldOf("chance").forGetter(a -> Float.valueOf(a.chance)), (App)PlaceboCodecs.nullableField((Codec)Codec.STRING, (String)"name", (Object)"").forGetter(a -> a.name), (App)PlaceboCodecs.setOf((Codec)ForgeRegistries.ENTITY_TYPES.getCodec()).fieldOf("entities").forGetter(a -> a.entities), (App)BossStats.CODEC.fieldOf("stats").forGetter(a -> a.stats), (App)PlaceboCodecs.nullableField((Codec)PlaceboCodecs.setOf((Codec)Codec.STRING), (String)"stages").forGetter(a -> Optional.ofNullable(a.stages)), (App)PlaceboCodecs.setOf((Codec)ResourceLocation.f_135803_).fieldOf("dimensions").forGetter(a -> a.dimensions), (App)PlaceboCodecs.nullableField((Codec)Codec.BOOL, (String)"affixed", (Object)false).forGetter(a -> a.affixed), (App)PlaceboCodecs.nullableField((Codec)GearSet.SetPredicate.CODEC.listOf(), (String)"valid_gear_sets", Collections.emptyList()).forGetter(a -> a.gearSets), (App)PlaceboCodecs.nullableField((Codec)NBTAdapter.EITHER_CODEC, (String)"nbt").forGetter(a -> Optional.ofNullable(a.nbt)), (App)PlaceboCodecs.nullableField((Codec)SupportingEntity.CODEC.listOf(), (String)"supporting_entities", Collections.emptyList()).forGetter(a -> a.support), (App)PlaceboCodecs.nullableField(SupportingEntity.CODEC, (String)"mount").forGetter(a -> Optional.ofNullable(a.mount)), (App)PlaceboCodecs.nullableField((Codec)Exclusion.CODEC.listOf(), (String)"exclusions", Collections.emptyList()).forGetter(a -> a.exclusions), (App)PlaceboCodecs.nullableField((Codec)Codec.BOOL, (String)"finalize", (Object)false).forGetter(a -> a.finalize)).apply((Applicative)inst, ApothMiniboss::new));
    protected final int weight;
    protected final float quality;
    protected final float chance;
    protected final String name;
    protected final Set<EntityType<?>> entities;
    protected final BossStats stats;
    @Nullable
    protected final Set<String> stages;
    protected final Set<ResourceLocation> dimensions;
    protected final boolean affixed;
    protected final List<GearSet.SetPredicate> gearSets;
    @Nullable
    protected final CompoundTag nbt;
    protected final List<SupportingEntity> support;
    @Nullable
    protected final SupportingEntity mount;
    protected final List<Exclusion> exclusions;
    protected final boolean finalize;

    public ApothMiniboss(int weight, float quality, float chance, String name, Set<EntityType<?>> entities, BossStats stats, Optional<Set<String>> stages, Set<ResourceLocation> dimensions, boolean affixed, List<GearSet.SetPredicate> gearSets, Optional<CompoundTag> nbt, List<SupportingEntity> support, Optional<SupportingEntity> mount, List<Exclusion> exclusions, boolean finalize) {
        this.weight = weight;
        this.quality = quality;
        this.chance = chance;
        this.name = name;
        this.entities = entities;
        this.stats = stats;
        this.stages = stages.orElse(null);
        this.dimensions = dimensions;
        this.affixed = affixed;
        this.gearSets = gearSets;
        this.nbt = nbt.orElse(null);
        this.support = support;
        this.mount = mount.orElse(null);
        this.exclusions = exclusions;
        this.finalize = finalize;
    }

    public int getWeight() {
        return this.weight;
    }

    public float getQuality() {
        return this.quality;
    }

    public float getChance() {
        return this.chance;
    }

    @Override
    public Set<EntityType<?>> getEntities() {
        return this.entities;
    }

    public void transformMiniboss(ServerLevelAccessor level, Mob mob, RandomSource random, float luck) {
        Vec3 pos = mob.m_20318_(0.0f);
        if (this.nbt != null && this.nbt.m_128441_("Passengers")) {
            ListTag passengers = this.nbt.m_128437_("Passengers", 10);
            for (int i = 0; i < passengers.size(); ++i) {
                Entity entity = EntityType.m_20645_((CompoundTag)passengers.m_128728_(i), (Level)level.m_6018_(), Function.identity());
                if (entity == null) continue;
                entity.m_7998_((Entity)mob, true);
            }
        }
        mob.m_146884_(pos);
        this.initBoss(random, mob, luck);
        if (this.nbt != null) {
            mob.m_7378_(this.nbt);
        }
        if (this.mount != null) {
            Mob mountedEntity = this.mount.create(mob.m_9236_(), mob.m_20185_() + 0.5, mob.m_20186_(), mob.m_20189_() + 0.5);
            mob.m_7998_((Entity)mountedEntity, true);
            level.m_7967_((Entity)mountedEntity);
        }
        if (this.support != null) {
            for (SupportingEntity support : this.support) {
                Mob supportingMob = support.create(mob.m_9236_(), mob.m_20185_() + 0.5, mob.m_20186_(), mob.m_20189_() + 0.5);
                level.m_7967_((Entity)supportingMob);
            }
        }
    }

    public void initBoss(RandomSource rand, Mob mob, float luck) {
        mob.getPersistentData().m_128379_("apoth.miniboss", true);
        int duration = mob instanceof Creeper ? 6000 : Integer.MAX_VALUE;
        for (ChancedEffectInstance inst : this.stats.effects()) {
            if (!(rand.m_188501_() <= inst.chance())) continue;
            mob.m_7292_(inst.create(rand, duration));
        }
        for (RandomAttributeModifier modif : this.stats.modifiers()) {
            modif.apply(rand, (LivingEntity)mob);
        }
        if (NAME_GEN.equals(this.name)) {
            NameHelper.setEntityName(rand, mob);
        } else if (!Strings.isNullOrEmpty((String)this.name)) {
            mob.m_6593_((Component)Component.m_237115_((String)this.name));
        }
        if (mob.m_8077_()) {
            mob.m_20340_(true);
        }
        if (!this.gearSets.isEmpty()) {
            GearSet set = GearSetRegistry.INSTANCE.getRandomSet(rand, luck, this.gearSets);
            Preconditions.checkNotNull((Object)set, (Object)String.format("Failed to find a valid gear set for the miniboss %s.", MinibossRegistry.INSTANCE.getKey(this)));
            set.apply((LivingEntity)mob);
        }
        int guaranteed = -1;
        if (this.affixed) {
            boolean anyValid = false;
            for (EquipmentSlot t : EquipmentSlot.values()) {
                ItemStack s = mob.m_6844_(t);
                if (s.m_41619_() || LootCategory.forItem(s).isNone()) continue;
                anyValid = true;
                break;
            }
            if (!anyValid) {
                AdventureModule.LOGGER.error("Attempted to affix a miniboss with ID " + String.valueOf(MinibossRegistry.INSTANCE.getKey(this)) + " but it is not wearing any affixable items!");
                return;
            }
            guaranteed = rand.m_188503_(6);
            ItemStack temp = mob.m_6844_(EquipmentSlot.values()[guaranteed]);
            while (temp.m_41619_() || LootCategory.forItem(temp) == LootCategory.NONE) {
                guaranteed = rand.m_188503_(6);
                temp = mob.m_6844_(EquipmentSlot.values()[guaranteed]);
            }
            LootRarity rarity = LootRarity.random(rand, luck, AdventureConfig.AFFIX_CONVERT_RARITIES.get(mob.m_9236_().m_46472_().m_135782_()));
            ApothBoss.modifyBossItem(temp, rand, mob.m_8077_() ? mob.m_7770_().getString() : "", luck, rarity, this.stats);
            mob.m_6593_((Component)((MutableComponent)mob.m_7770_()).m_130948_(Style.f_131099_.m_131148_(rarity.getColor())));
            mob.m_21409_(EquipmentSlot.values()[guaranteed], 2.0f);
        }
        for (EquipmentSlot s : EquipmentSlot.values()) {
            ItemStack stack = mob.m_6844_(s);
            if (stack.m_41619_() || s.ordinal() == guaranteed || !(rand.m_188501_() < this.stats.enchantChance())) continue;
            ApothBoss.enchantBossItem(rand, stack, Apotheosis.enableEnch ? this.stats.enchLevels()[0] : this.stats.enchLevels()[1], true);
            mob.m_8061_(s, stack);
        }
        mob.m_21153_(mob.m_21233_());
    }

    public ApothMiniboss validate(ResourceLocation key) {
        Preconditions.checkArgument((this.weight >= 0 ? 1 : 0) != 0, (Object)("Miniboss Item " + String.valueOf(key) + " has a negative weight!"));
        Preconditions.checkArgument((this.quality >= 0.0f ? 1 : 0) != 0, (Object)("Miniboss Item " + String.valueOf(key) + " has a negative quality!"));
        Preconditions.checkNotNull(this.entities, (Object)("Miniboss Item " + String.valueOf(key) + " has null entity match list!"));
        Preconditions.checkNotNull((Object)this.stats, (Object)("Miniboss Item " + String.valueOf(key) + " has no stats!"));
        return this;
    }

    public Set<ResourceLocation> getDimensions() {
        return this.dimensions;
    }

    @Override
    public Set<String> getStages() {
        return this.stages;
    }

    public Codec<? extends ApothMiniboss> getCodec() {
        return CODEC;
    }

    public boolean requiresNbtAccess() {
        return this.exclusions.stream().anyMatch(Exclusion::requiresNbtAccess);
    }

    public boolean isExcluded(Mob mob, ServerLevelAccessor level, MobSpawnType type) {
        CompoundTag tag = this.requiresNbtAccess() ? mob.m_20240_(new CompoundTag()) : null;
        return this.exclusions.stream().anyMatch(ex -> ex.isExcluded(mob, level, type, tag));
    }

    public boolean shouldFinalize() {
        return this.finalize;
    }
}

