/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.effect;

import com.google.common.base.Predicate;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.AdventureConfig;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;

public class CleavingAffix
extends Affix {
    public static final Codec<CleavingAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)LootRarity.mapCodec(CleaveValues.CODEC).fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, CleavingAffix::new));
    protected final Map<LootRarity, CleaveValues> values;
    private static boolean cleaving = false;

    public CleavingAffix(Map<LootRarity, CleaveValues> values) {
        super(AffixType.ABILITY);
        this.values = values;
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        return cat == LootCategory.HEAVY_WEAPON && this.values.containsKey(rarity);
    }

    @Override
    public MutableComponent getDescription(ItemStack stack, LootRarity rarity, float level) {
        return Component.m_237110_((String)("affix." + String.valueOf(this.getId()) + ".desc"), (Object[])new Object[]{CleavingAffix.fmt(100.0f * this.getChance(rarity, level)), this.getTargets(rarity, level)});
    }

    @Override
    public Component getAugmentingText(ItemStack stack, LootRarity rarity, float level) {
        int maxTargets;
        int minTargets;
        float maxChance;
        MutableComponent comp = this.getDescription(stack, rarity, level);
        float minChance = this.getChance(rarity, 0.0f);
        if (minChance != (maxChance = this.getChance(rarity, 1.0f))) {
            MutableComponent minComp = Component.m_237110_((String)"%s%%", (Object[])new Object[]{CleavingAffix.fmt(100.0f * minChance)});
            MutableComponent maxComp = Component.m_237110_((String)"%s%%", (Object[])new Object[]{CleavingAffix.fmt(100.0f * maxChance)});
            comp.m_7220_((Component)CleavingAffix.valueBounds((Component)minComp, (Component)maxComp));
        }
        if ((minTargets = this.getTargets(rarity, 0.0f)) != (maxTargets = this.getTargets(rarity, 1.0f))) {
            MutableComponent minComp = Component.m_237113_((String)CleavingAffix.fmt(minTargets));
            MutableComponent maxComp = Component.m_237113_((String)CleavingAffix.fmt(maxTargets));
            return comp.m_7220_((Component)CleavingAffix.valueBounds((Component)minComp, (Component)maxComp));
        }
        return comp;
    }

    private float getChance(LootRarity rarity, float level) {
        return this.values.get((Object)rarity).chance.get(level);
    }

    private int getTargets(LootRarity rarity, float level) {
        return this.values.get((Object)rarity).targets.getInt(level);
    }

    @Override
    public void doPostAttack(ItemStack stack, LootRarity rarity, float level, LivingEntity user, Entity target) {
        if ((double)Apotheosis.getLocalAtkStrength((Entity)user) >= 0.98 && !cleaving && !user.m_9236_().f_46443_) {
            cleaving = true;
            float chance = this.getChance(rarity, level);
            int targets = this.getTargets(rarity, level);
            if (user.m_9236_().f_46441_.m_188501_() < chance && user instanceof Player) {
                Player player = (Player)user;
                List nearby = target.m_9236_().m_6249_(target, new AABB(target.m_20183_()).m_82400_(6.0), CleavingAffix.cleavePredicate((Entity)user, target));
                for (Entity e : nearby) {
                    if (targets <= 0) continue;
                    user.f_20922_ = 300;
                    player.m_5706_(e);
                    --targets;
                }
            }
            cleaving = false;
        }
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    public static Predicate<Entity> cleavePredicate(Entity user, Entity target) {
        return e -> {
            LivingEntity le;
            if (e instanceof Animal && !(target instanceof Animal) || e instanceof AbstractVillager && !(target instanceof AbstractVillager)) {
                return false;
            }
            if (!AdventureConfig.cleaveHitsPlayers && e instanceof Player) {
                return false;
            }
            if (target instanceof Enemy && !(e instanceof Enemy)) {
                return false;
            }
            return e != user && e instanceof LivingEntity && (le = (LivingEntity)e).m_6084_();
        };
    }

    record CleaveValues(StepFunction chance, StepFunction targets) {
        public static final Codec<CleaveValues> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)StepFunction.CODEC.fieldOf("chance").forGetter(c -> c.chance), (App)StepFunction.CODEC.fieldOf("targets").forGetter(c -> c.targets)).apply((Applicative)inst, CleaveValues::new));
    }
}

