/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sololeveling.procedures;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.mcreator.sololeveling.entity.PortalEntity;
import net.mcreator.sololeveling.network.SoloLevelingModVariables;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class RenderShape2Procedure {
    private static BufferBuilder bufferBuilder = null;
    private static VertexBuffer vertexBuffer = null;
    private static VertexFormat.Mode mode = null;
    private static VertexFormat format = null;
    private static PoseStack poseStack = null;
    private static Matrix4f projectionMatrix = null;
    private static boolean worldCoordinate = true;
    private static Vec3 offset = Vec3.f_82478_;
    private static int currentStage = 0;
    private static int targetStage = 0;

    private static void add(double x, double y, double z, int color) {
        RenderShape2Procedure.add(x, y, z, 0.0f, 0.0f, color);
    }

    private static void add(double x, double y, double z, float u, float v, int color) {
        if (bufferBuilder == null || !bufferBuilder.m_85732_()) {
            return;
        }
        if (format == DefaultVertexFormat.f_85815_) {
            bufferBuilder.m_5483_(x, y, z).m_193479_(color).m_5752_();
        } else if (format == DefaultVertexFormat.f_85819_) {
            bufferBuilder.m_5483_(x, y, z).m_7421_(u, v).m_193479_(color).m_5752_();
        }
    }

    private static boolean begin(VertexFormat.Mode mode, VertexFormat format, boolean update) {
        if (bufferBuilder == null || !bufferBuilder.m_85732_()) {
            if (update) {
                RenderShape2Procedure.clear();
            }
            if (vertexBuffer == null) {
                if (format == DefaultVertexFormat.f_85815_) {
                    RenderShape2Procedure.mode = mode;
                    RenderShape2Procedure.format = format;
                    bufferBuilder = Tesselator.m_85913_().m_85915_();
                    bufferBuilder.m_166779_(mode, DefaultVertexFormat.f_85815_);
                    return true;
                }
                if (format == DefaultVertexFormat.f_85819_) {
                    RenderShape2Procedure.mode = mode;
                    RenderShape2Procedure.format = format;
                    bufferBuilder = Tesselator.m_85913_().m_85915_();
                    bufferBuilder.m_166779_(mode, DefaultVertexFormat.f_85819_);
                    return true;
                }
            }
        }
        return false;
    }

    private static void clear() {
        if (vertexBuffer != null) {
            vertexBuffer.close();
            vertexBuffer = null;
        }
    }

    private static void end() {
        if (bufferBuilder == null || !bufferBuilder.m_85732_()) {
            return;
        }
        if (vertexBuffer != null) {
            vertexBuffer.close();
        }
        vertexBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        vertexBuffer.m_85921_();
        vertexBuffer.m_231221_(bufferBuilder.m_231175_());
        VertexBuffer.m_85931_();
    }

    private static void offset(double x, double y, double z) {
        offset = new Vec3(x, y, z);
    }

    private static void release() {
        targetStage = 0;
    }

    private static VertexBuffer shape() {
        return vertexBuffer;
    }

    private static void system(boolean worldCoordinate) {
        RenderShape2Procedure.worldCoordinate = worldCoordinate;
    }

    private static boolean target(int targetStage) {
        if (targetStage == currentStage) {
            RenderShape2Procedure.targetStage = targetStage;
            return true;
        }
        return false;
    }

    private static void renderShape(VertexBuffer vertexBuffer, double x, double y, double z, float yaw, float pitch, float roll, float xScale, float yScale, float zScale, int color) {
        float k;
        float j;
        float i;
        if (currentStage == 0 || currentStage != targetStage) {
            return;
        }
        if (poseStack == null || projectionMatrix == null) {
            return;
        }
        if (vertexBuffer == null) {
            return;
        }
        if (worldCoordinate) {
            Vec3 pos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
            i = (float)(x - pos.m_7096_());
            j = (float)(y - pos.m_7098_());
            k = (float)(z - pos.m_7094_());
        } else {
            i = (float)x;
            j = (float)y;
            k = (float)z;
        }
        poseStack.m_85836_();
        poseStack.m_252880_(i, j, k);
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        poseStack.m_85841_(xScale, yScale, zScale);
        poseStack.m_85837_(offset.m_7096_(), offset.m_7098_(), offset.m_7094_());
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24) / 255.0f));
        vertexBuffer.m_85921_();
        vertexBuffer.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, vertexBuffer.m_166892_().hasUV(0) ? GameRenderer.m_172820_() : GameRenderer.m_172811_());
        VertexBuffer.m_85931_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    @SubscribeEvent
    public static void renderLevel(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY) {
            currentStage = 1;
            RenderSystem.depthMask((boolean)false);
            RenderShape2Procedure.renderShapes(event);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            currentStage = 0;
        } else if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            currentStage = 2;
            RenderSystem.depthMask((boolean)true);
            RenderShape2Procedure.renderShapes(event);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            currentStage = 0;
        }
    }

    private static void renderShapes(RenderLevelStageEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        Entity entity = minecraft.f_91063_.m_109153_().m_90592_();
        if (level != null && entity != null) {
            poseStack = event.getPoseStack();
            projectionMatrix = event.getProjectionMatrix();
            Vec3 pos = entity.m_20318_(event.getPartialTick());
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderShape2Procedure.execute((Event)event, (LevelAccessor)level, entity, event.getPartialTick(), event.getRenderTick());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
        }
    }

    public static void execute(LevelAccessor world, Entity entity, double partialTick, double ticks) {
        RenderShape2Procedure.execute(null, world, entity, partialTick, ticks);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, Entity entity, double partialTick, double ticks) {
        if (entity == null) {
            return;
        }
        Object shape = null;
        double i = 0.0;
        double rep = 0.0;
        double count = 0.0;
        double j = 0.0;
        double k = 0.0;
        double l = 0.0;
        double distance = 0.0;
        if (Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
            if (((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).sense_gates) {
                SoloLevelingModVariables.PlayerVariables playerVariables = new SoloLevelingModVariables.PlayerVariables();
                if (((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)playerVariables)).sense > 15.0) {
                    if (RenderShape2Procedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_, false)) {
                        RenderShape2Procedure.add(0.5, 0.5, 0.0, 0.0f, 0.0f, -1);
                        RenderShape2Procedure.add(0.5, -0.5, 0.0, 0.0f, 1.0f, -1);
                        RenderShape2Procedure.add(-0.5, -0.5, 0.0, 1.0f, 1.0f, -1);
                        RenderShape2Procedure.add(-0.5, 0.5, 0.0, 1.0f, 0.0f, -1);
                        RenderShape2Procedure.end();
                    }
                    if (RenderShape2Procedure.target(2)) {
                        RenderSystem.disableDepthTest();
                        if (world instanceof ClientLevel) {
                            for (Entity entityiterator : ((ClientLevel)world).m_104735_()) {
                                if (!(entityiterator instanceof PortalEntity)) continue;
                                distance = Math.sqrt(Math.pow(entity.m_20185_() - entityiterator.m_20185_(), 2.0) + Math.pow(entity.m_20189_() - entityiterator.m_20189_(), 2.0));
                                RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("solo_leveling:textures/indicator.png"));
                                RenderShape2Procedure.renderShape(RenderShape2Procedure.shape(), entityiterator.m_20185_(), entityiterator.m_20186_() + (double)entityiterator.m_20206_(), entityiterator.m_20189_(), entity.m_146908_(), 0.0f, 0.0f, (float)(2.0 + distance / 15.0), (float)(2.0 + distance / 15.0), (float)(2.0 + distance / 15.0), -1271778561);
                            }
                        }
                        RenderShape2Procedure.release();
                    }
                    RenderShape2Procedure.clear();
                    RenderSystem.enableDepthTest();
                }
            }
            if (((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).sense_monsters) {
                SoloLevelingModVariables.PlayerVariables playerVariables = new SoloLevelingModVariables.PlayerVariables();
                if (((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)playerVariables)).sense > 5.0) {
                    if (RenderShape2Procedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_, false)) {
                        RenderShape2Procedure.add(0.5, 0.5, 0.0, 0.0f, 0.0f, -1);
                        RenderShape2Procedure.add(0.5, -0.5, 0.0, 0.0f, 1.0f, -1);
                        RenderShape2Procedure.add(-0.5, -0.5, 0.0, 1.0f, 1.0f, -1);
                        RenderShape2Procedure.add(-0.5, 0.5, 0.0, 1.0f, 0.0f, -1);
                        RenderShape2Procedure.end();
                    }
                    if (RenderShape2Procedure.target(2)) {
                        RenderSystem.disableDepthTest();
                        if (world instanceof ClientLevel) {
                            for (Entity entityiterator : ((ClientLevel)world).m_104735_()) {
                                TamableAnimal _tamEnt;
                                if (!(entityiterator.getPersistentData().m_128459_("level") > 0.0) || entityiterator instanceof TamableAnimal && (_tamEnt = (TamableAnimal)entityiterator).m_21824_()) continue;
                                distance = Math.sqrt(Math.pow(entity.m_20185_() - entityiterator.m_20185_(), 2.0) + Math.pow(entity.m_20189_() - entityiterator.m_20189_(), 2.0));
                                RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("solo_leveling:textures/indicator.png"));
                                RenderShape2Procedure.renderShape(RenderShape2Procedure.shape(), entityiterator.m_20185_(), entityiterator.m_20186_() + (double)entityiterator.m_20206_() + 1.5, entityiterator.m_20189_(), entity.m_146908_(), 0.0f, 0.0f, (float)(0.5 + distance / 25.0), (float)(0.5 + distance / 25.0), (float)(0.5 + distance / 25.0), -1258343886);
                            }
                        }
                        RenderShape2Procedure.release();
                    }
                    RenderShape2Procedure.clear();
                    RenderSystem.enableDepthTest();
                }
            }
        }
        if (SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).slash_effect > 0.0) {
            if (RenderShape2Procedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_, false)) {
                rep = Math.toRadians(SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).slash_effect * 15.0);
                count = 0.0;
                for (int index0 = 0; index0 < 4; ++index0) {
                    RenderShape2Procedure.add(Math.sin(rep += 1.5707963267948966) * SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).slash_effect, 0.0, Math.cos(rep) * SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).slash_effect, !((count += 1.0) <= 2.0) ? 1 : 0, count == 2.0 || count == 3.0 ? 1 : 0, -1);
                }
                RenderShape2Procedure.end();
            }
            if (RenderShape2Procedure.target(2)) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("solo_leveling:textures/slash.png"));
                RenderSystem.disableDepthTest();
                RenderShape2Procedure.renderShape(RenderShape2Procedure.shape(), SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).effectX, SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).effectY + 1.0, SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).effectZ, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, -1);
                RenderShape2Procedure.renderShape(RenderShape2Procedure.shape(), SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).effectX, SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).effectY + 1.0, SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).effectZ, 0.0f, 180.0f, 0.0f, 1.0f, 1.0f, 1.0f, -1);
                RenderShape2Procedure.release();
            }
        }
        if (SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).kamish_gate && !SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).kamish_spawn) {
            if (RenderShape2Procedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_, false)) {
                RenderShape2Procedure.add(0.5, 0.0, 0.5, 0.0f, 0.0f, -1);
                RenderShape2Procedure.add(0.5, 0.0, -0.5, 0.0f, 1.0f, -1);
                RenderShape2Procedure.add(-0.5, 0.0, -0.5, 1.0f, 1.0f, -1);
                RenderShape2Procedure.add(-0.5, 0.0, 0.5, 1.0f, 0.0f, -1);
                RenderShape2Procedure.end();
            }
            if (RenderShape2Procedure.target(1)) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("solo_leveling:textures/kamish_gate.png"));
                RenderShape2Procedure.renderShape(RenderShape2Procedure.shape(), SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).kamish_X, 200.0, SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).kamish_Z, (float)(SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).kamish_gate_angle / 4000.0 * 360.0), 180.0f, 0.0f, 200.0f, 200.0f, 200.0f, -1765226276);
                RenderShape2Procedure.release();
            }
            RenderShape2Procedure.clear();
        }
        if (((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).display_health && world instanceof ClientLevel) {
            for (Entity entityiterator : ((ClientLevel)world).m_104735_()) {
                if (!(entityiterator.getPersistentData().m_128459_("level") > 0.0)) continue;
                if (RenderShape2Procedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_, false)) {
                    RenderShape2Procedure.add(0.85, 0.0, 0.15, 0.0f, 0.0f, -1);
                    RenderShape2Procedure.add(0.85, 0.0, -0.15, 0.0f, 1.0f, -1);
                    RenderShape2Procedure.add(-0.85, 0.0, -0.15, 1.0f, 1.0f, -1);
                    RenderShape2Procedure.add(-0.85, 0.0, 0.15, 1.0f, 0.0f, -1);
                    RenderShape2Procedure.end();
                }
                if (RenderShape2Procedure.target(2)) {
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("solo_leveling:textures/gray.png"));
                    RenderShape2Procedure.renderShape(RenderShape2Procedure.shape(), entityiterator.m_20185_(), entityiterator.m_20186_() + (double)entityiterator.m_20206_() + 0.7, entityiterator.m_20189_(), entity.m_146908_() + 180.0f, entity.m_146909_() * -1.0f + 90.0f, 0.0f, 1.0f, 1.0f, 1.0f, -922746881);
                    RenderShape2Procedure.release();
                }
                RenderShape2Procedure.clear();
                if (RenderShape2Procedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_, false)) {
                    float f;
                    float f2;
                    float f3;
                    LivingEntity _livEnt;
                    float f4;
                    LivingEntity _livEnt2;
                    if (entityiterator instanceof LivingEntity) {
                        _livEnt2 = (LivingEntity)entityiterator;
                        f4 = _livEnt2.m_21223_();
                    } else {
                        f4 = -1.0f;
                    }
                    if (entityiterator instanceof LivingEntity) {
                        _livEnt = (LivingEntity)entityiterator;
                        f3 = _livEnt.m_21233_();
                    } else {
                        f3 = -1.0f;
                    }
                    RenderShape2Procedure.add(-0.8 + 1.6 * (double)(f4 / f3), 0.0, 0.1, 0.0f, 0.0f, -1);
                    if (entityiterator instanceof LivingEntity) {
                        _livEnt2 = (LivingEntity)entityiterator;
                        f2 = _livEnt2.m_21223_();
                    } else {
                        f2 = -1.0f;
                    }
                    if (entityiterator instanceof LivingEntity) {
                        _livEnt = (LivingEntity)entityiterator;
                        f = _livEnt.m_21233_();
                    } else {
                        f = -1.0f;
                    }
                    RenderShape2Procedure.add(-0.8 + 1.6 * (double)(f2 / f), 0.0, -0.1, 0.0f, 1.0f, -1);
                    RenderShape2Procedure.add(-0.8, 0.0, -0.1, 1.0f, 1.0f, -1);
                    RenderShape2Procedure.add(-0.8, 0.0, 0.1, 1.0f, 0.0f, -1);
                    RenderShape2Procedure.end();
                }
                if (RenderShape2Procedure.target(2)) {
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("solo_leveling:textures/green.png"));
                    RenderShape2Procedure.renderShape(RenderShape2Procedure.shape(), entityiterator.m_20185_(), entityiterator.m_20186_() + (double)entityiterator.m_20206_() + 0.7, entityiterator.m_20189_(), entity.m_146908_() + 180.0f, entity.m_146909_() * -1.0f + 90.0f, 0.0f, 1.0f, 1.0f, 1.0f, -65386);
                    RenderShape2Procedure.release();
                }
                RenderShape2Procedure.clear();
            }
        }
        if (SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).blackhole_timer > 0.0) {
            if (RenderShape2Procedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_, false)) {
                for (int index1 = 0; index1 < 90; ++index1) {
                    for (int index2 = 0; index2 < 45; ++index2) {
                        k = 255.0 - j / 180.0 * 95.0;
                        l = 255.0 - (j + 4.0) / 180.0 * 95.0;
                        RenderShape2Procedure.add(Math.sin(Math.toRadians(i)) * Math.sin(Math.toRadians(j)) * 0.5, Math.cos(Math.toRadians(j)) * 0.5, Math.cos(Math.toRadians(i)) * Math.sin(Math.toRadians(j)) * 0.5, 0xFF000000 | (int)k << 16 | (int)k << 8 | (int)k);
                        RenderShape2Procedure.add(Math.sin(Math.toRadians(i)) * Math.sin(Math.toRadians(j + 4.0)) * 0.5, Math.cos(Math.toRadians(j + 4.0)) * 0.5, Math.cos(Math.toRadians(i)) * Math.sin(Math.toRadians(j + 4.0)) * 0.5, 0xFF000000 | (int)l << 16 | (int)l << 8 | (int)l);
                        RenderShape2Procedure.add(Math.sin(Math.toRadians(i + 4.0)) * Math.sin(Math.toRadians(j + 4.0)) * 0.5, Math.cos(Math.toRadians(j + 4.0)) * 0.5, Math.cos(Math.toRadians(i + 4.0)) * Math.sin(Math.toRadians(j + 4.0)) * 0.5, 0xFF000000 | (int)l << 16 | (int)l << 8 | (int)l);
                        RenderShape2Procedure.add(Math.sin(Math.toRadians(i + 4.0)) * Math.sin(Math.toRadians(j)) * 0.5, Math.cos(Math.toRadians(j)) * 0.5, Math.cos(Math.toRadians(i + 4.0)) * Math.sin(Math.toRadians(j)) * 0.5, 0xFF000000 | (int)k << 16 | (int)k << 8 | (int)k);
                        j += 4.0;
                    }
                    j = 0.0;
                    i += 4.0;
                }
                i = 0.0;
                RenderShape2Procedure.end();
            }
            if (RenderShape2Procedure.target(2)) {
                RenderShape2Procedure.renderShape(RenderShape2Procedure.shape(), SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).blackhole_X, SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).blackhole_Y, SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).blackholeZ, entity.m_146908_() + 180.0f, 90.0f, 0.0f, 2.7f, 2.7f, 2.7f, -16777216);
                RenderShape2Procedure.release();
            }
            RenderShape2Procedure.clear();
            if (RenderShape2Procedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_, false)) {
                RenderShape2Procedure.add(0.5, 0.0, 0.5, 0.0f, 0.0f, -1);
                RenderShape2Procedure.add(0.5, 0.0, -0.5, 0.0f, 1.0f, -1);
                RenderShape2Procedure.add(-0.5, 0.0, -0.5, 1.0f, 1.0f, -1);
                RenderShape2Procedure.add(-0.5, 0.0, 0.5, 1.0f, 0.0f, -1);
                RenderShape2Procedure.end();
            }
            if (RenderShape2Procedure.target(2)) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("solo_leveling:textures/blackhole_outer.png"));
                RenderShape2Procedure.renderShape(RenderShape2Procedure.shape(), SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).blackhole_X + entity.m_20154_().f_82479_ * 0.1, SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).blackhole_Y + Math.sin(0.15707963267948966 * ticks) * 0.2, SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).blackholeZ + entity.m_20154_().f_82481_ * 0.1, entity.m_146908_() + 180.0f, entity.m_146909_() * -1.0f + 35.0f, (float)(Math.sin(0.15707963267948966 * partialTick) * 20.0), 3.5f, 3.3f, 3.5f, -76);
                RenderShape2Procedure.renderShape(RenderShape2Procedure.shape(), SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).blackhole_X + entity.m_20154_().f_82479_ * 0.1, SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).blackhole_Y + Math.sin(0.15707963267948966 * ticks) * 0.2, SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).blackholeZ + entity.m_20154_().f_82481_ * 0.1, entity.m_146908_() + 180.0f, entity.m_146909_() * -1.0f + 90.0f, (float)(Math.sin(0.15707963267948966 * partialTick) * 20.0), 3.5f, 3.3f, 3.5f, -76);
                RenderShape2Procedure.release();
            }
            RenderShape2Procedure.clear();
        }
    }
}

