/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sololeveling.procedures;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.mcreator.sololeveling.entity.PortalEntity;
import net.mcreator.sololeveling.network.SoloLevelingModVariables;
import net.mcreator.sololeveling.procedures.GetCooldownOfSelectedSkillProcedure;
import net.mcreator.sololeveling.procedures.GetManaProcedure;
import net.mcreator.sololeveling.procedures.GetMaxManaProcedure;
import net.mcreator.sololeveling.procedures.GetSelectSkillProcedure;
import net.mcreator.sololeveling.procedures.ReturnFagFrontProcedure;
import net.mcreator.sololeveling.procedures.ReturnFilteredItemsPriceProcedure;
import net.mcreator.sololeveling.procedures.ReturnFilteredItemsProcedure;
import net.mcreator.sololeveling.procedures.ReturnFlagBackgroundProcedure;
import net.mcreator.sololeveling.procedures.ReturnFlagColorProcedure;
import net.mcreator.sololeveling.procedures.ReturnFlagSymbolProcedure;
import net.mcreator.sololeveling.procedures.ReturnGuildNameProcedure;
import net.mcreator.sololeveling.procedures.ReturnRuneSkillNoLagProcedure;
import net.mcreator.sololeveling.procedures.ReturnSkillsNoLagProcedure;
import net.mcreator.sololeveling.world.inventory.GuildCreateGuiMenu;
import net.mcreator.sololeveling.world.inventory.GuildListMenu;
import net.mcreator.sololeveling.world.inventory.LearnedSkillsMenuMenu;
import net.mcreator.sololeveling.world.inventory.MainMenuMenu;
import net.mcreator.sololeveling.world.inventory.MapGuiMenu;
import net.mcreator.sololeveling.world.inventory.NewShopMenu;
import net.mcreator.sololeveling.world.inventory.RewardMenuMenu;
import net.mcreator.sololeveling.world.inventory.SkillsMenuMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class RenderOverlayProcedure {
    private static Map<EntityType, Entity> data = new HashMap<EntityType, Entity>();
    private static GuiGraphics guiGraphics = null;
    private static float partialTick = 0.0f;
    private static int currentStage = 0;
    private static int targetStage = 0;

    private static boolean target(int targetStage) {
        if (targetStage == currentStage) {
            RenderOverlayProcedure.targetStage = targetStage;
            return true;
        }
        if (targetStage == 1 && currentStage != 0) {
            RenderOverlayProcedure.targetStage = currentStage;
            return true;
        }
        return false;
    }

    private static void release() {
        targetStage = 0;
    }

    public static void renderEntity(LevelAccessor levelAccessor, EntityType type, double x, double y, double depth, float yaw, float pitch, float roll, float scale, boolean modelOnly) {
        if (currentStage == 0 || currentStage != targetStage) {
            return;
        }
        if (type == null) {
            return;
        }
        if (levelAccessor instanceof ClientLevel) {
            ClientLevel level = (ClientLevel)levelAccessor;
            if (Minecraft.m_91087_().f_91063_.m_109153_() != null) {
                Entity entity = null;
                if (data.containsKey(type)) {
                    entity = data.get(type);
                } else {
                    entity = type.m_20615_((Level)level);
                    data.put(type, entity);
                }
                RenderOverlayProcedure.renderEntity(entity, 0.0f, x, y, depth, yaw, pitch, roll, scale, modelOnly);
            }
        }
    }

    public static void renderEntity(LevelAccessor levelAccessor, Entity entity, double x, double y, double depth, float yaw, float pitch, float roll, float scale, boolean modelOnly) {
        if (currentStage == 0 || currentStage != targetStage) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (levelAccessor instanceof ClientLevel && minecraft.f_91063_.m_109153_() != null) {
            RenderOverlayProcedure.renderEntity(entity, partialTick, x, y, depth, yaw, pitch, roll, scale, modelOnly);
        }
    }

    private static void renderEntity(Entity entity, float partialTick, double x, double y, double depth, float yaw, float pitch, float roll, float scale, boolean modelOnly) {
        if (entity == null) {
            return;
        }
        float offset = entity.m_20206_() / 2.0f;
        float yRotO = entity.f_19859_;
        float yRot = entity.m_146908_();
        float xRotO = entity.f_19860_;
        float xRot = entity.m_146909_();
        entity.f_19859_ = 180.0f;
        entity.m_146922_(180.0f);
        entity.f_19860_ = 0.0f;
        entity.m_146926_(0.0f);
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_85837_(x, y, -depth);
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll + 180.0f));
        poseStack.m_252931_(new Matrix4f().scaling(scale, scale, -scale));
        poseStack.m_252880_(0.0f, -offset, 0.0f);
        Lighting.m_166384_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            float yBodyRotO = livingEntity.f_20884_;
            float yBodyRot = livingEntity.f_20883_;
            float yHeadRotO = livingEntity.f_20886_;
            float yHeadRot = livingEntity.f_20885_;
            livingEntity.f_20884_ = 180.0f;
            livingEntity.f_20883_ = 180.0f;
            livingEntity.f_20886_ = 180.0f;
            livingEntity.f_20885_ = 180.0f;
            RenderOverlayProcedure.renderEntity((Entity)livingEntity, partialTick, poseStack, modelOnly);
            livingEntity.f_20884_ = yBodyRotO;
            livingEntity.f_20883_ = yBodyRot;
            livingEntity.f_20886_ = yHeadRotO;
            livingEntity.f_20885_ = yHeadRot;
        } else {
            RenderOverlayProcedure.renderEntity(entity, partialTick, poseStack, modelOnly);
        }
        Lighting.m_84931_();
        poseStack.m_85849_();
        entity.f_19859_ = yRotO;
        entity.m_146922_(yRot);
        entity.f_19860_ = xRotO;
        entity.m_146926_(xRot);
    }

    private static void renderEntity(Entity entity, float partialTick, PoseStack poseStack, boolean modelOnly) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (modelOnly) {
            boolean customNameVisible = entity.m_20151_();
            entity.m_20340_(false);
            minecraft.m_91290_().m_114382_(entity).m_7392_(entity, 0.0f, partialTick, poseStack, (MultiBufferSource)guiGraphics.m_280091_(), 0xF000F0);
            guiGraphics.m_280262_();
            entity.m_20340_(customNameVisible);
        } else {
            EntityRenderDispatcher renderer = minecraft.m_91290_();
            renderer.m_114468_(false);
            renderer.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, partialTick, poseStack, (MultiBufferSource)guiGraphics.m_280091_(), 0xF000F0);
            guiGraphics.m_280262_();
            renderer.m_114468_(true);
        }
    }

    public static void renderItem(LevelAccessor levelAccessor, ItemStack itemStack, double x, double y, double depth, float yaw, float pitch, float roll, float scale) {
        if (currentStage == 0 || currentStage != targetStage) {
            return;
        }
        if (itemStack.m_41619_()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (levelAccessor instanceof ClientLevel) {
            ClientLevel level = (ClientLevel)levelAccessor;
            if (minecraft.f_91063_.m_109153_() != null) {
                ItemRenderer renderer = minecraft.m_91291_();
                BakedModel bakedModel = renderer.m_174264_(itemStack, (Level)level, null, 0);
                PoseStack poseStack = guiGraphics.m_280168_();
                poseStack.m_85836_();
                poseStack.m_85837_(x, y, -depth);
                poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
                poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
                poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
                poseStack.m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
                poseStack.m_85841_(scale, scale, scale);
                if (!bakedModel.m_7547_()) {
                    Lighting.m_84930_();
                }
                renderer.m_115143_(itemStack, ItemDisplayContext.GUI, false, poseStack, (MultiBufferSource)guiGraphics.m_280091_(), 0xF000F0, OverlayTexture.f_118083_, bakedModel);
                guiGraphics.m_280262_();
                Lighting.m_84931_();
                poseStack.m_85849_();
            }
        }
    }

    public static void renderRectangle(float x1, float y1, float x2, float y2, float depth, int color) {
        float y4;
        float y3;
        float x4;
        float x3;
        if (currentStage == 0 || currentStage != targetStage) {
            return;
        }
        if (x1 <= x2) {
            x3 = x1;
            x4 = x2;
        } else {
            x3 = x2;
            x4 = x1;
        }
        if (y1 <= y2) {
            y3 = y1;
            y4 = y2;
        } else {
            y3 = y2;
            y4 = y1;
        }
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        int alpha = color >>> 24;
        Matrix4f matrix4f = guiGraphics.m_280168_().m_85850_().m_252922_();
        VertexConsumer vertexConsumer = guiGraphics.m_280091_().m_6299_(RenderType.m_285907_());
        vertexConsumer.m_252986_(matrix4f, x3, y3, -depth).m_6122_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_252986_(matrix4f, x3, y4, -depth).m_6122_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_252986_(matrix4f, x4, y4, -depth).m_6122_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_252986_(matrix4f, x4, y3, -depth).m_6122_(red, green, blue, alpha).m_5752_();
    }

    public static void renderShape(VertexBuffer vertexBuffer, double x, double y, double depth, float yaw, float pitch, float roll, float xScale, float yScale, float zScale, int color) {
        if (currentStage == 0 || currentStage != targetStage) {
            return;
        }
        if (vertexBuffer == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_85837_(x, y, -depth);
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        poseStack.m_85841_(xScale, yScale, zScale);
        PoseStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.m_85836_();
        modelViewStack.m_252931_(poseStack.m_85850_().m_252922_());
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24) / 255.0f));
        vertexBuffer.m_85921_();
        vertexBuffer.m_253207_(modelViewStack.m_85850_().m_252922_(), RenderSystem.getProjectionMatrix(), vertexBuffer.m_166892_().hasUV(0) ? GameRenderer.m_172820_() : GameRenderer.m_172811_());
        VertexBuffer.m_85931_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        modelViewStack.m_85849_();
        poseStack.m_85849_();
    }

    public static void renderTexts(String texts, float x, float y, float depth, float angle, float scale, int color, int alignment) {
        if (currentStage == 0 || currentStage != targetStage) {
            return;
        }
        Font font = Minecraft.m_91087_().f_91062_;
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        switch (alignment) {
            case 0: {
                offsetX = (float)(font.m_92895_(texts) - 1) * 0.5f;
                Objects.requireNonNull(font);
                offsetY = (float)(9 - 1) * 0.5f;
                break;
            }
            case 1: {
                Objects.requireNonNull(font);
                offsetY = (float)(9 - 1) * 0.5f;
                break;
            }
            case 2: {
                offsetX = (float)(font.m_92895_(texts) - 1) * -0.5f;
                Objects.requireNonNull(font);
                offsetY = (float)(9 - 1) * 0.5f;
                break;
            }
            case 3: {
                offsetX = (float)(font.m_92895_(texts) - 1) * 0.5f;
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                offsetX = (float)(font.m_92895_(texts) - 1) * -0.5f;
                break;
            }
            case 6: {
                offsetX = (float)(font.m_92895_(texts) - 1) * 0.5f;
                Objects.requireNonNull(font);
                offsetY = (float)(9 - 1) * -0.5f;
                break;
            }
            case 7: {
                Objects.requireNonNull(font);
                offsetY = (float)(9 - 1) * -0.5f;
                break;
            }
            case 8: {
                offsetX = (float)(font.m_92895_(texts) - 1) * -0.5f;
                Objects.requireNonNull(font);
                offsetY = (float)(9 - 1) * -0.5f;
            }
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(x + offsetX * scale, y + offsetY * scale, -depth);
        poseStack.m_252781_(Axis.f_252393_.m_252977_(angle));
        poseStack.m_85841_(scale, scale, 1.0f);
        float f = (float)(font.m_92895_(texts) - 1) * -0.5f;
        Objects.requireNonNull(font);
        poseStack.m_252880_(f, (float)(9 - 1) * -0.5f, 0.0f);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        font.m_271703_(texts, 0.0f, 0.0f, color, false, matrix4f, (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        poseStack.m_85849_();
    }

    public static void renderTexture(float x, float y, float depth, float angle, float scale, int color, int alignment) {
        if (currentStage == 0 || currentStage != targetStage) {
            return;
        }
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        switch (alignment) {
            case 0: {
                offsetX = 0.5f;
                offsetY = 0.5f;
                break;
            }
            case 1: {
                offsetY = 0.5f;
                break;
            }
            case 2: {
                offsetX = -0.5f;
                offsetY = 0.5f;
                break;
            }
            case 3: {
                offsetX = 0.5f;
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                offsetX = -0.5f;
                break;
            }
            case 6: {
                offsetX = 0.5f;
                offsetY = -0.5f;
                break;
            }
            case 7: {
                offsetY = -0.5f;
                break;
            }
            case 8: {
                offsetX = -0.5f;
                offsetY = -0.5f;
            }
        }
        RenderSystem.bindTexture((int)RenderSystem.getShaderTexture((int)0));
        int width = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        int height = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        int alpha = color >>> 24;
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(x, y, -depth);
        poseStack.m_252781_(Axis.f_252393_.m_252977_(angle));
        poseStack.m_85841_((float)width * scale, (float)height * scale, 1.0f);
        poseStack.m_252880_(offsetX, offsetY, 0.0f);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        RenderSystem.setShader(GameRenderer::m_172820_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferBuilder.m_252986_(matrix4f, -0.5f, -0.5f, 0.0f).m_7421_(0.0f, 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix4f, -0.5f, 0.5f, 0.0f).m_7421_(0.0f, 1.0f).m_6122_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix4f, 0.5f, 0.5f, 0.0f).m_7421_(1.0f, 1.0f).m_6122_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix4f, 0.5f, -0.5f, 0.0f).m_7421_(1.0f, 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        poseStack.m_85849_();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void renderGUI(RenderGuiEvent.Pre event) {
        currentStage = 2;
        guiGraphics = event.getGuiGraphics();
        partialTick = event.getPartialTick();
        RenderOverlayProcedure.renderOverlays((Event)event);
        currentStage = 0;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void renderScreen(ScreenEvent.Render.Post event) {
        currentStage = 3;
        guiGraphics = event.getGuiGraphics();
        partialTick = event.getPartialTick();
        RenderOverlayProcedure.renderOverlays((Event)event);
        currentStage = 0;
    }

    private static void renderOverlays(Event event) {
        Minecraft minecraft = Minecraft.m_91087_();
        double scale = minecraft.m_91268_().m_85449_();
        if (scale > 0.0) {
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderOverlayProcedure.execute(event);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
        }
    }

    public static void execute() {
        RenderOverlayProcedure.execute(null);
    }

    private static void execute(@Nullable Event event) {
        block53: {
            block54: {
                Level world;
                LocalPlayer entity;
                double pos;
                double id;
                block55: {
                    block63: {
                        block62: {
                            double rep;
                            ItemStack item;
                            block61: {
                                block59: {
                                    block60: {
                                        double distance;
                                        double rep2;
                                        double skill_count;
                                        double corY;
                                        double corX;
                                        block58: {
                                            double count;
                                            String texture;
                                            block56: {
                                                block57: {
                                                    texture = "";
                                                    String skill = "";
                                                    boolean can_scroll = false;
                                                    boolean can_set = false;
                                                    item = ItemStack.f_41583_;
                                                    id = 0.0;
                                                    count = 0.0;
                                                    rep = 0.0;
                                                    corX = 0.0;
                                                    corY = 0.0;
                                                    double check = 0.0;
                                                    skill_count = 0.0;
                                                    rep2 = 0.0;
                                                    distance = 0.0;
                                                    pos = 0.0;
                                                    if (!RenderOverlayProcedure.target(1)) break block53;
                                                    if (Minecraft.m_91087_().f_91074_ == null) break block54;
                                                    entity = Minecraft.m_91087_().f_91074_;
                                                    double x = entity.m_20185_();
                                                    double y = entity.m_20186_();
                                                    double z = entity.m_20189_();
                                                    world = entity.m_9236_();
                                                    ResourceKey dimension = entity.m_9236_().m_46472_();
                                                    if (!((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).awakened) break block55;
                                                    can_scroll = true;
                                                    if (Minecraft.m_91087_().f_91080_ == null) break block56;
                                                    if (!(entity instanceof Player)) break block57;
                                                    Player _plr1 = (Player)entity;
                                                    if (_plr1.f_36096_ instanceof SkillsMenuMenu) break block56;
                                                }
                                                if (!(entity instanceof Player)) break block58;
                                                Player _plr2 = (Player)entity;
                                                if (!(_plr2.f_36096_ instanceof MainMenuMenu)) break block58;
                                            }
                                            RenderOverlayProcedure.renderTexts("Stamina: " + new DecimalFormat("##").format(((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).stamina), 5.0f, Minecraft.m_91087_().m_91268_().m_85446_() - 30, 0.0f, 0.0f, 1.0f, 0xB4000000 | (int)(110.0 - 100.0 * (100.0 / (100.0 + ((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).stamina))) << 16 | (int)(200.0 * (100.0 / (100.0 + ((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).stamina))) << 8 | 0x3C, 6);
                                            RenderOverlayProcedure.renderTexts(GetSelectSkillProcedure.execute((Entity)entity), 5.0f, Minecraft.m_91087_().m_91268_().m_85446_() - 20, 0.0f, 0.0f, 1.0f, 0xB4000000 | (GetSelectSkillProcedure.execute((Entity)entity).length() > 9 ? 255 : 0) << 16 | 0 | 0xF0, 6);
                                            id = ((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).skill - 1.0;
                                            count = 1.0;
                                            for (int index0 = 0; index0 < 3; ++index0) {
                                                texture = "none";
                                                if (id < 0.0) {
                                                    id = 7.0;
                                                }
                                                if (id > 7.0) {
                                                    id = 0.0;
                                                }
                                                if (!(texture = ((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).skill_slots.m_41784_().m_128461_("skill" + new DecimalFormat("##").format(id)).replace(" ", "_").replace("'", "").toLowerCase()).equals("none") && !texture.equals("")) {
                                                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("solo_leveling:textures/skill_slot.png"));
                                                    RenderOverlayProcedure.renderTexture((float)((double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.1 + count * 20.0), (float)((double)Minecraft.m_91087_().m_91268_().m_85446_() - (double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.2), count == 0.0 ? 0 : -1, (float)(5.0 * count), (float)(count == 0.0 ? 0.6 : 0.4), (count == 0.0 ? 255 : 180) << 24 | 0xFF0000 | (count == 0.0 ? 255 : 180) << 8 | 0x96, 4);
                                                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("solo_leveling:textures/" + texture + ".png"));
                                                    RenderOverlayProcedure.renderTexture((float)((double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.1 + count * 20.0), (float)((double)Minecraft.m_91087_().m_91268_().m_85446_() - (double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.2), count == 0.0 ? 0 : -1, (float)(5.0 * count), (float)(count == 0.0 ? 0.4 : 0.25), (count == 0.0 ? 255 : 180) << 24 | (count == 0.0 ? 255 : 180) << 16 | (count == 0.0 ? 255 : 180) << 8 | (count == 0.0 ? 255 : 180), 4);
                                                }
                                                id += 1.0;
                                                count -= 1.0;
                                            }
                                        }
                                        if (Minecraft.m_91087_().f_91080_ == null && GetCooldownOfSelectedSkillProcedure.execute((Entity)entity) > 0.0) {
                                            RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("solo_leveling:textures/cd.png"));
                                            if (((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).whole_cd != 0.0) {
                                                for (int index1 = 0; index1 < (int)(100.0 * (GetCooldownOfSelectedSkillProcedure.execute((Entity)entity) / ((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).whole_cd)); ++index1) {
                                                    RenderOverlayProcedure.renderTexture((float)((double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.5 + Math.sin(rep += 0.06283185307179587) * (double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.02), (float)((double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.5 + Math.cos(rep) * (double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.02), 0.0f, 0.0f, 0.3f, -1, 4);
                                                }
                                            }
                                        }
                                        if (entity instanceof Player) {
                                            Player _plr33 = (Player)entity;
                                            if (_plr33.f_36096_ instanceof LearnedSkillsMenuMenu) {
                                                id = 1.0;
                                                rep = 0.0;
                                                double _setval = 0.0;
                                                entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(arg_0 -> RenderOverlayProcedure.lambda$execute$0(_setval, (Entity)entity, arg_0));
                                                rep2 = Math.toRadians(60.0 * Math.floor(((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).learned_skill_menu / 5.0));
                                                distance = 1.0;
                                                for (int index2 = 0; index2 < (int)((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).learned_skill_menu; ++index2) {
                                                    if (!((distance += 1.0) > 5.0)) continue;
                                                    distance = 1.0;
                                                }
                                                for (int index3 = 0; index3 < 6; ++index3) {
                                                    for (int index4 = 0; index4 < 5; ++index4) {
                                                        skill_count += 1.0;
                                                        corX = ((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).menuX - Math.sin(rep) * id * 30.0 + (double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.5 + Math.sin(rep2) * distance * 30.0;
                                                        corY = ((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).menuY - Math.cos(rep) * id * 30.0 + (double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.5 + Math.cos(rep2) * distance * 30.0;
                                                        if (!(Math.abs((double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.5 - corX) > 75.0) && !(Math.abs((double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.5 - corY) > 75.0)) {
                                                            RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("solo_leveling:textures/connect_line.png"));
                                                            RenderOverlayProcedure.renderTexture((float)corX, (float)corY, 0.0f, (float)(Math.toDegrees(rep) + 180.0), 0.5f, -1, 4);
                                                            if (ReturnRuneSkillNoLagProcedure.execute((Entity)entity, skill_count).equals("LOCKED")) {
                                                                RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("solo_leveling:textures/skill_locked.png"));
                                                            } else {
                                                                RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("solo_leveling:textures/skill_slot.png"));
                                                            }
                                                            RenderOverlayProcedure.renderTexture((float)corX, (float)corY, 0.0f, 0.0f, 0.5f, -1, 4);
                                                            RenderOverlayProcedure.renderTexts(ReturnRuneSkillNoLagProcedure.execute((Entity)entity, skill_count), (float)corX, (float)corY, 0.0f, 0.0f, 0.5f, -1, 4);
                                                        }
                                                        id += 1.0;
                                                    }
                                                    id = 1.0;
                                                    rep += 1.0471975511965976;
                                                }
                                            }
                                        }
                                        if (entity instanceof Player) {
                                            Player _plr50 = (Player)entity;
                                            if (_plr50.f_36096_ instanceof SkillsMenuMenu) {
                                                id = 1.0;
                                                rep = 0.0;
                                                double _setval = 0.0;
                                                entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(arg_0 -> RenderOverlayProcedure.lambda$execute$1(_setval, (Entity)entity, arg_0));
                                                rep2 = Math.toRadians(60.0 * Math.floor(((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).skill_menu / 5.0));
                                                distance = 1.0;
                                                for (int index5 = 0; index5 < (int)((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).skill_menu; ++index5) {
                                                    if (!((distance += 1.0) > 5.0)) continue;
                                                    distance = 1.0;
                                                }
                                                for (int index6 = 0; index6 < 6; ++index6) {
                                                    for (int index7 = 0; index7 < 5; ++index7) {
                                                        skill_count += 1.0;
                                                        corX = ((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).menuX - Math.sin(rep) * id * 30.0 + (double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.5 + Math.sin(rep2) * distance * 30.0;
                                                        corY = ((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).menuY - Math.cos(rep) * id * 30.0 + (double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.5 + Math.cos(rep2) * distance * 30.0;
                                                        if (!(Math.abs((double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.5 - corX) > 75.0) && !(Math.abs((double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.5 - corY) > 75.0)) {
                                                            RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("solo_leveling:textures/connect_line.png"));
                                                            RenderOverlayProcedure.renderTexture((float)corX, (float)corY, 0.0f, (float)(Math.toDegrees(rep) + 180.0), 0.5f, -1, 4);
                                                            if (ReturnSkillsNoLagProcedure.execute((Entity)entity, skill_count).equals("LOCKED")) {
                                                                RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("solo_leveling:textures/skill_locked.png"));
                                                            } else {
                                                                RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("solo_leveling:textures/skill_slot.png"));
                                                            }
                                                            RenderOverlayProcedure.renderTexture((float)corX, (float)corY, 0.0f, 0.0f, 0.5f, -1, 4);
                                                            RenderOverlayProcedure.renderTexts(ReturnSkillsNoLagProcedure.execute((Entity)entity, skill_count), (float)corX, (float)corY, 0.0f, 0.0f, 0.5f, -1, 4);
                                                        }
                                                        id += 1.0;
                                                    }
                                                    id = 1.0;
                                                    rep += 1.0471975511965976;
                                                }
                                            }
                                        }
                                        SoloLevelingModVariables.PlayerVariables playerVariables = new SoloLevelingModVariables.PlayerVariables();
                                        if (Math.floor(((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)playerVariables)).level_up_alarm) >= 5.0) {
                                            RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("solo_leveling:textures/orvmenu.png"));
                                            RenderOverlayProcedure.renderTexture((float)((double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.5), (float)((double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.5), 0.0f, 0.0f, 1.0f, (int)(180.0 * (((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).level_up_alarm / 80.0)) << 24 | 0xFF0000 | 0xFF00 | 0xFF, 4);
                                            RenderOverlayProcedure.renderTexts("Alarm!", (float)((double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.5 - 0.0), (float)((double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.5 - 20.0), 0.0f, 0.0f, 2.0f, (int)(255.0 * (((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).level_up_alarm / 80.0)) << 24 | 0xC80000 | 0xC800 | 0xFF, 4);
                                            RenderOverlayProcedure.renderTexts("You leveled up! ", (float)((double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.5 - 0.0), (float)((double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.5 - 0.0), 0.0f, 0.0f, 1.3f, (int)(230.0 * (((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).level_up_alarm / 80.0)) << 24 | 0xC80000 | 0xC800 | 0xC8, 4);
                                            RenderOverlayProcedure.renderTexts("Current level: " + new DecimalFormat("##").format(((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).level), (float)((double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.5 - 0.0), (float)((double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.5 + 12.0), 0.0f, 0.0f, 1.3f, (int)(230.0 * (((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).level_up_alarm / 80.0)) << 24 | 0xC80000 | 0xC800 | 0xC8, 4);
                                        }
                                        if (Minecraft.m_91087_().f_91080_ == null) break block59;
                                        if (!(entity instanceof Player)) break block60;
                                        Player _plr86 = (Player)entity;
                                        if (_plr86.f_36096_ instanceof SkillsMenuMenu) break block59;
                                    }
                                    if (!(entity instanceof Player)) break block61;
                                    Player _plr87 = (Player)entity;
                                    if (!(_plr87.f_36096_ instanceof MainMenuMenu)) break block61;
                                }
                                if (GetMaxManaProcedure.execute((Entity)entity) > 0.0) {
                                    rep = 0.0;
                                    for (int index8 = 0; index8 < (int)(318.0 * (((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).mana / GetMaxManaProcedure.execute((Entity)entity)) > 318.0 ? 318.0 : 318.0 * (((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).mana / GetMaxManaProcedure.execute((Entity)entity))); ++index8) {
                                        RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("solo_leveling:textures/fill25.png"));
                                        RenderOverlayProcedure.renderTexture((float)(2.0 + rep), Minecraft.m_91087_().m_91268_().m_85446_() - 20, 0.0f, 0.0f, 0.25f, 0x78230000 | (int)(10.0 * (((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).mana / GetMaxManaProcedure.execute((Entity)entity))) << 8 | (int)(250.0 * (((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).mana / GetMaxManaProcedure.execute((Entity)entity))), 0);
                                        rep += 0.25;
                                    }
                                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("solo_leveling:textures/bar25.png"));
                                    RenderOverlayProcedure.renderTexture(2.0f, Minecraft.m_91087_().m_91268_().m_85446_() - 20, 0.0f, 0.0f, 0.25f, -1, 0);
                                    RenderOverlayProcedure.renderTexts(GetManaProcedure.execute((Entity)entity), 6.0f, Minecraft.m_91087_().m_91268_().m_85446_() - 19, 0.0f, 0.0f, 0.8f, 0xFFFF5000 | (int)(180.0 * (((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).mana / GetMaxManaProcedure.execute((Entity)entity))), 0);
                                }
                            }
                            if (entity instanceof Player) {
                                Player _plr101 = (Player)entity;
                                if (_plr101.f_36096_ instanceof NewShopMenu) {
                                    id = ((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).gui_scroll + 1.0;
                                    for (rep = 0.0; rep < 8.0; rep += 1.0) {
                                        if (ReturnFilteredItemsProcedure.execute((Entity)entity, id).m_41720_() != ItemStack.f_41583_.m_41720_()) {
                                            item = ReturnFilteredItemsProcedure.execute((Entity)entity, id);
                                            RenderOverlayProcedure.renderItem((LevelAccessor)world, item, (double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.5 - 70.0 + rep * 20.0, (double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.5 - 40.0, -15.0, 0.0f, 0.0f, rep == 0.0 ? 0 : -5, rep == 0.0 ? 18 : 14);
                                            if (rep == 0.0) {
                                                RenderOverlayProcedure.renderTexts(item.m_41611_().getString(), (float)((double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.5 - 70.0 + rep * 20.0), (float)((double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.5 - 40.0 + 20.0), 0.0f, 0.0f, 0.5f, -1644801, 1);
                                            }
                                            RenderOverlayProcedure.renderTexts(new DecimalFormat("##").format(ReturnFilteredItemsPriceProcedure.execute((Entity)entity, id)) + "$", (float)((double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.5 - 70.0 + rep * 20.0), (float)((double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.5 - 40.0 + 20.0 + (double)(rep == 0.0 ? 10 : -5)), 0.0f, 0.0f, 0.5f, (rep == 0.0 ? 255 : 150) << 24 | 0xE60000 | 0xFF00 | 0xE6, 1);
                                        }
                                        id += 1.0;
                                    }
                                    RenderOverlayProcedure.renderTexts("Balance: " + new DecimalFormat("##.#").format(((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).Money) + "$", (float)((double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.5), (float)((double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.5), 0.0f, 0.0f, 0.8f, -1638426, 1);
                                }
                            }
                            if (entity instanceof Player) {
                                Player _plr120 = (Player)entity;
                                if (_plr120.f_36096_ instanceof RewardMenuMenu) {
                                    RenderOverlayProcedure.renderItem((LevelAccessor)world, ((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).reward_1, (double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.5 - 70.0, (double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.5, -150.0, 0.0f, 0.0f, 0.0f, 16.0f);
                                    RenderOverlayProcedure.renderItem((LevelAccessor)world, ((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).reward_2, (double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.5, (double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.5, -150.0, 0.0f, 0.0f, 0.0f, 16.0f);
                                    RenderOverlayProcedure.renderItem((LevelAccessor)world, ((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).reward_3, (double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.5 + 70.0, (double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.5, -150.0, 0.0f, 0.0f, 0.0f, 16.0f);
                                }
                            }
                            if (!(entity instanceof Player)) break block62;
                            Player _plr130 = (Player)entity;
                            if (_plr130.f_36096_ instanceof SkillsMenuMenu) break block63;
                        }
                        if (!(entity instanceof Player)) break block55;
                        Player _plr131 = (Player)entity;
                        if (!(_plr131.f_36096_ instanceof LearnedSkillsMenuMenu)) break block55;
                    }
                    RenderOverlayProcedure.renderTexts(((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).picked_skill, (float)(Minecraft.m_91087_().f_91067_.m_91589_() / Minecraft.m_91087_().m_91268_().m_85449_()), (float)(Minecraft.m_91087_().f_91067_.m_91594_() / Minecraft.m_91087_().m_91268_().m_85449_()), 0.0f, 0.0f, 1.0f, -26881, 6);
                }
                if (entity instanceof Player) {
                    Player _plr136 = (Player)entity;
                    if (_plr136.f_36096_ instanceof MapGuiMenu) {
                        RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("solo_leveling:textures/indicator.png"));
                        RenderOverlayProcedure.renderTexture((float)((double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.5), (float)((double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.5), 0.0f, 180.0f - entity.m_146908_(), 0.5f, -65281, 4);
                        if (Minecraft.m_91087_().f_91067_.m_91589_() / Minecraft.m_91087_().m_91268_().m_85449_() < (double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.5 + 40.0 && Minecraft.m_91087_().f_91067_.m_91589_() / Minecraft.m_91087_().m_91268_().m_85449_() > (double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.5 - 40.0 && Minecraft.m_91087_().f_91067_.m_91594_() / Minecraft.m_91087_().m_91268_().m_85449_() < (double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.5 + 80.0 && Minecraft.m_91087_().f_91067_.m_91594_() / Minecraft.m_91087_().m_91268_().m_85449_() > (double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.5 - 80.0) {
                            RenderOverlayProcedure.renderTexts("X: " + new DecimalFormat("##").format(entity.m_20185_() + ((double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.5 - Minecraft.m_91087_().f_91067_.m_91589_() / Minecraft.m_91087_().m_91268_().m_85449_()) * 5.0) + " Z: " + new DecimalFormat("##").format(entity.m_20189_() + ((double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.5 - Minecraft.m_91087_().f_91067_.m_91594_() / Minecraft.m_91087_().m_91268_().m_85449_()) * 5.0), (float)(Minecraft.m_91087_().f_91067_.m_91589_() / Minecraft.m_91087_().m_91268_().m_85449_()), (float)(Minecraft.m_91087_().f_91067_.m_91594_() / Minecraft.m_91087_().m_91268_().m_85449_()), -5.0f, 0.0f, 0.5f, -12806556, 3);
                        }
                        if (world instanceof ClientLevel) {
                            for (Entity entityiterator : ((ClientLevel)world).m_104735_()) {
                                if (!(entityiterator instanceof PortalEntity) || !((double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.5 + (entity.m_20185_() - entityiterator.m_20185_()) / 5.0 < (double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.5 + 40.0) || !((double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.5 + (entity.m_20185_() - entityiterator.m_20185_()) / 5.0 > (double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.5 - 40.0) || !((double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.5 + (entity.m_20189_() - entityiterator.m_20189_()) / 5.0 < (double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.5 + 80.0) || !((double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.5 + (entity.m_20189_() - entityiterator.m_20189_()) / 5.0 > (double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.5 - 80.0)) continue;
                                RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("solo_leveling:textures/gate.png"));
                                RenderOverlayProcedure.renderTexture((float)((double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.5 + (entity.m_20185_() - entityiterator.m_20185_()) / 5.0), (float)((double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.5 + (entity.m_20189_() - entityiterator.m_20189_()) / 5.0), 0.0f, 0.0f, 0.8f, -1, 4);
                            }
                        }
                    }
                }
                if (entity instanceof Player) {
                    Player _plr190 = (Player)entity;
                    if (_plr190.f_36096_ instanceof GuildCreateGuiMenu) {
                        RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("solo_leveling:textures/" + ReturnFlagBackgroundProcedure.execute(((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).guild_flag_background) + ".png"));
                        RenderOverlayProcedure.renderTexture((float)((double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.5), (float)((double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.5), 0.0f, 0.0f, 1.0f, (int)ReturnFlagColorProcedure.execute(((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).guild_flag_background_color), 4);
                        RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("solo_leveling:textures/" + ReturnFlagSymbolProcedure.execute(((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).guild_flag_symbol) + ".png"));
                        RenderOverlayProcedure.renderTexture((float)((double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.5), (float)((double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.5), 0.0f, 0.0f, 1.0f, (int)ReturnFlagColorProcedure.execute(((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).guild_flag_symbol_color), 4);
                        RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("solo_leveling:textures/" + ReturnFagFrontProcedure.execute(((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).guild_flag_front) + ".png"));
                        RenderOverlayProcedure.renderTexture((float)((double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.5), (float)((double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.5), 0.0f, 0.0f, 1.0f, (int)ReturnFlagColorProcedure.execute(((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).guild_flag_front_color), 4);
                    }
                }
                if (entity instanceof Player) {
                    Player _plr206 = (Player)entity;
                    if (_plr206.f_36096_ instanceof GuildListMenu) {
                        id = ((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).guild_list_scroll;
                        pos = 0.0;
                        for (int index10 = 0; index10 < (int)(SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).guild_last_id + 5.0); ++index10) {
                            if (Math.abs((double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.5 - 50.0 + (pos += 1.0) * 12.0 - ((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).guild_list_scroll_actual * 12.0) > (double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.5 + 45.0 || Math.abs((double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.5 - 50.0 + pos * 12.0 - ((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).guild_list_scroll_actual * 12.0) < (double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.5 - 70.0) continue;
                            RenderOverlayProcedure.renderTexts("guild: " + ReturnGuildNameProcedure.execute((LevelAccessor)world, pos), (float)((double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.5 - 30.0), (float)((double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.5 - 50.0 + pos * 12.0 - ((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).guild_list_scroll_actual * 12.0), 0.0f, 0.0f, 0.5f, 0xFFC80000 | (Math.round(pos) == Math.round(((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).guild_list_scroll + 1.0) ? 200 : 0) << 8 | 0x64, 6);
                            RenderOverlayProcedure.renderTexts(SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).guilds.m_41784_().m_128461_(ReturnGuildNameProcedure.execute((LevelAccessor)world, pos) + "_moto"), (float)((double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.5 - 30.0), (float)((double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.5 - 50.0 + pos * 12.0 - ((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).guild_list_scroll_actual * 12.0 + 4.0), 0.0f, 0.0f, 0.3f, 0xFFC80000 | (Math.round(pos) == Math.round(((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).guild_list_scroll + 1.0) ? 200 : 0) << 8 | 0x64, 6);
                            if (Math.round(pos) == Math.round(((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).guild_list_scroll + 1.0)) {
                                RenderOverlayProcedure.renderTexts("score: " + SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).guilds.m_41784_().m_128459_(ReturnGuildNameProcedure.execute((LevelAccessor)world, pos) + "_score"), (float)((double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.5 - 50.0), (float)((double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.5 - 50.0 + pos * 12.0 - ((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).guild_list_scroll_actual * 12.0 + 4.0), 0.0f, 0.0f, 0.3f, -3644316, 6);
                            }
                            if (ReturnGuildNameProcedure.execute((LevelAccessor)world, pos).isEmpty()) continue;
                            RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("solo_leveling:textures/" + ReturnFlagBackgroundProcedure.execute(SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).guilds.m_41784_().m_128459_(ReturnGuildNameProcedure.execute((LevelAccessor)world, pos) + "_flag_background")) + ".png"));
                            RenderOverlayProcedure.renderTexture((float)((double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.5 + 5.0), (float)((double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.5 - 50.0 + pos * 12.0 - ((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).guild_list_scroll_actual * 12.0), 0.0f, 0.0f, 0.8f, (int)ReturnFlagColorProcedure.execute(SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).guilds.m_41784_().m_128459_(ReturnGuildNameProcedure.execute((LevelAccessor)world, pos) + "_flag_background_color")), 6);
                            RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("solo_leveling:textures/" + ReturnFlagSymbolProcedure.execute(SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).guilds.m_41784_().m_128459_(ReturnGuildNameProcedure.execute((LevelAccessor)world, pos) + "_flag_symbol")) + ".png"));
                            RenderOverlayProcedure.renderTexture((float)((double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.5 + 5.0), (float)((double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.5 - 50.0 + pos * 12.0 - ((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).guild_list_scroll_actual * 12.0), 0.0f, 0.0f, 0.8f, (int)ReturnFlagColorProcedure.execute(SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).guilds.m_41784_().m_128459_(ReturnGuildNameProcedure.execute((LevelAccessor)world, pos) + "_flag_symbol_color")), 6);
                            RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("solo_leveling:textures/" + ReturnFagFrontProcedure.execute(SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).guilds.m_41784_().m_128459_(ReturnGuildNameProcedure.execute((LevelAccessor)world, pos) + "_flag_front")) + ".png"));
                            RenderOverlayProcedure.renderTexture((float)((double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.5 + 5.0), (float)((double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.5 - 50.0 + pos * 12.0 - ((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).guild_list_scroll_actual * 12.0), 0.0f, 0.0f, 0.8f, (int)ReturnFlagColorProcedure.execute(SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).guilds.m_41784_().m_128459_(ReturnGuildNameProcedure.execute((LevelAccessor)world, pos) + "_flag_front_color")), 6);
                        }
                    }
                }
            }
            RenderOverlayProcedure.release();
        }
    }

    private static /* synthetic */ void lambda$execute$1(double _setval, Entity entity, SoloLevelingModVariables.PlayerVariables capability) {
        capability.Skill_ID = _setval;
        capability.syncPlayerVariables(entity);
    }

    private static /* synthetic */ void lambda$execute$0(double _setval, Entity entity, SoloLevelingModVariables.PlayerVariables capability) {
        capability.Skill_ID_Stone = _setval;
        capability.syncPlayerVariables(entity);
    }
}

