/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sololeveling.procedures;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.mcreator.sololeveling.init.SoloLevelingModBlocks;
import net.mcreator.sololeveling.init.SoloLevelingModMobEffects;
import net.mcreator.sololeveling.network.SoloLevelingModVariables;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class RenderEntityProcedure {
    private static RenderLevelStageEvent provider = null;
    private static Map<EntityType, Entity> data = new HashMap<EntityType, Entity>();

    public static void renderBackground(String texts, double x, double y, double z, float yaw, float pitch, float roll, float scale, int color) {
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
        Vec3 pos = provider.getCamera().m_90583_();
        PoseStack poseStack = provider.getPoseStack();
        poseStack.m_85836_();
        poseStack.m_85837_(x - pos.m_7096_(), y - pos.m_7098_(), z - pos.m_7094_());
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        poseStack.m_85841_(scale, -scale, 1.0f);
        float f = (float)(font.m_92895_(texts) - 1) * -0.5f;
        Objects.requireNonNull(font);
        poseStack.m_252880_(f, (float)(9 - 1) * -0.5f, 0.0f);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        font.m_271703_(texts, 0.0f, 0.0f, 0, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.SEE_THROUGH, color, 0xF000F0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    public static void renderBlock(BlockState blockState, double x, double y, double z, float yaw, float pitch, float roll, float scale, boolean glowing) {
        BlockPos blockPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        Vec3 pos = provider.getCamera().m_90583_();
        int packedLight = glowing ? 0xF000F0 : LevelRenderer.m_109541_((BlockAndTintGetter)Minecraft.m_91087_().f_91073_, (BlockPos)blockPos);
        PoseStack poseStack = provider.getPoseStack();
        poseStack.m_85836_();
        poseStack.m_85837_(x - pos.m_7096_(), y - pos.m_7098_(), z - pos.m_7094_());
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderEntityProcedure.renderBlockModel(blockState, blockPos, poseStack, packedLight);
        RenderEntityProcedure.renderBlockEntity(blockState, blockPos, poseStack, packedLight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    private static void renderBlockEntity(BlockState blockState, BlockPos blockPos, PoseStack poseStack, int packedLight) {
        Block block = blockState.m_60734_();
        if (block instanceof EntityBlock) {
            BlockEntityRenderer blockEntityRenderer;
            EntityBlock entityBlock = (EntityBlock)block;
            Minecraft minecraft = Minecraft.m_91087_();
            ClientLevel level = minecraft.f_91073_;
            BlockEntity blockEntity = entityBlock.m_142194_(blockPos, blockState);
            if (blockEntity != null && (blockEntityRenderer = minecraft.m_167982_().m_112265_(blockEntity)) != null) {
                MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
                blockEntity.m_142339_((Level)level);
                blockEntityRenderer.m_6922_(blockEntity, 0.0f, poseStack, (MultiBufferSource)bufferSource, packedLight, OverlayTexture.f_118083_);
            }
        }
    }

    private static void renderBlockModel(BlockState blockState, BlockPos blockPos, PoseStack poseStack, int packedLight) {
        if (blockState.m_60799_() == RenderShape.MODEL) {
            Minecraft minecraft = Minecraft.m_91087_();
            ClientLevel level = minecraft.f_91073_;
            MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
            BlockRenderDispatcher dispatcher = minecraft.m_91289_();
            ModelBlockRenderer renderer = dispatcher.m_110937_();
            BakedModel bakedModel = dispatcher.m_110910_(blockState);
            ModelData modelData = bakedModel.getModelData((BlockAndTintGetter)level, blockPos, blockState, ModelData.builder().build());
            PoseStack.Pose pose = poseStack.m_85850_();
            int color = minecraft.m_91298_().m_92582_(blockState, (Level)level, blockPos);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            for (RenderType renderType : bakedModel.getRenderTypes(blockState, RandomSource.m_216335_((long)42L), modelData)) {
                renderer.renderModel(pose, bufferSource.m_6299_(Sheets.m_110792_()), blockState, bakedModel, red, green, blue, packedLight, OverlayTexture.f_118083_, modelData, renderType);
            }
        }
    }

    public static void renderEntity(EntityType type, double x, double y, double z, float yaw, float pitch, float roll, float scale, boolean glowing) {
        Entity entity;
        if (type == null) {
            return;
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (data.containsKey(type)) {
            entity = data.get(type);
            if (entity.m_9236_() != level) {
                entity = type.m_20615_((Level)level);
                data.put(type, entity);
            }
        } else {
            entity = type.m_20615_((Level)level);
            data.put(type, entity);
        }
        RenderEntityProcedure.renderEntity(entity, 0.0f, x, y, z, yaw, pitch, roll, scale, glowing ? 0xF000F0 : LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)BlockPos.m_274561_((double)x, (double)y, (double)z)));
    }

    public static void renderEntity(Entity entity, double x, double y, double z, float yaw, float pitch, float roll, float scale, boolean glowing) {
        float partialTick = provider.getPartialTick();
        int packedLight = glowing ? 0xF000F0 : Minecraft.m_91087_().m_91290_().m_114394_(entity, partialTick);
        RenderEntityProcedure.renderEntity(entity, partialTick, x, y, z, yaw, pitch, roll, scale, packedLight);
    }

    private static void renderEntity(Entity entity, float partialTick, double x, double y, double z, float yaw, float pitch, float roll, float scale, int packedLight) {
        if (entity == null) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
        EntityRenderer renderer = minecraft.m_91290_().m_114382_(entity);
        Vec3 pos = provider.getCamera().m_90583_();
        float offset = entity.m_20206_() / 2.0f * scale;
        PoseStack poseStack = provider.getPoseStack();
        poseStack.m_85836_();
        poseStack.m_85837_(x - pos.m_7096_(), y + (double)offset - pos.m_7098_(), z - pos.m_7094_());
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        poseStack.m_252880_(0.0f, -offset, 0.0f);
        poseStack.m_85841_(scale, scale, scale);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        renderer.m_7392_(entity, entity.m_5675_(partialTick), partialTick, poseStack, (MultiBufferSource)bufferSource, packedLight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    public static void renderItem(ItemStack itemStack, double x, double y, double z, float yaw, float pitch, float roll, float scale, boolean flipping, boolean glowing) {
        Minecraft minecraft = Minecraft.m_91087_();
        MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
        ItemRenderer renderer = minecraft.m_91291_();
        Vec3 pos = provider.getCamera().m_90583_();
        int packedLight = glowing ? 0xF000F0 : LevelRenderer.m_109541_((BlockAndTintGetter)minecraft.f_91073_, (BlockPos)BlockPos.m_274561_((double)x, (double)y, (double)z));
        PoseStack poseStack = provider.getPoseStack();
        poseStack.m_85836_();
        poseStack.m_85837_(x - pos.m_7096_(), y - pos.m_7098_(), z - pos.m_7094_());
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        poseStack.m_85841_(scale, scale, scale);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        renderer.m_269491_(null, itemStack, ItemDisplayContext.FIXED, flipping, poseStack, (MultiBufferSource)bufferSource, (Level)minecraft.f_91073_, packedLight, OverlayTexture.f_118083_, 0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    public static void renderLine(double x1, double y1, double z1, double x2, double y2, double z2, int color) {
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        Vec3 pos = provider.getCamera().m_90583_();
        Vector3f normal = new Vec3(x2 - x1, y2 - y1, z2 - z1).m_82541_().m_252839_();
        Matrix4f matrix4f = provider.getPoseStack().m_85850_().m_252922_();
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110504_());
        vertexConsumer.m_252986_(matrix4f, (float)(x1 - pos.m_7096_()), (float)(y1 - pos.m_7098_()), (float)(z1 - pos.m_7094_())).m_193479_(color).m_5601_(normal.x(), normal.y(), normal.z()).m_5752_();
        vertexConsumer.m_252986_(matrix4f, (float)(x2 - pos.m_7096_()), (float)(y2 - pos.m_7098_()), (float)(z2 - pos.m_7094_())).m_193479_(color).m_5601_(normal.x(), normal.y(), normal.z()).m_5752_();
    }

    public static void renderTexts(String texts, double x, double y, double z, float yaw, float pitch, float roll, float scale, int color, boolean glowing) {
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
        Vec3 pos = provider.getCamera().m_90583_();
        int packedLight = glowing ? 0xF000F0 : LevelRenderer.m_109541_((BlockAndTintGetter)minecraft.f_91073_, (BlockPos)BlockPos.m_274561_((double)x, (double)y, (double)z));
        PoseStack poseStack = provider.getPoseStack();
        poseStack.m_85836_();
        poseStack.m_85837_(x - pos.m_7096_(), y - pos.m_7098_(), z - pos.m_7094_());
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        poseStack.m_85841_(scale, -scale, 1.0f);
        float f = (float)(font.m_92895_(texts) - 1) * -0.5f;
        Objects.requireNonNull(font);
        poseStack.m_252880_(f, (float)(9 - 1) * -0.5f, 0.0f);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        font.m_271703_(texts, 0.0f, 0.0f, color, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, packedLight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    @SubscribeEvent
    public static void renderModels(RenderLevelStageEvent event) {
        provider = event;
        if (provider.getStage() == RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            Entity entity = provider.getCamera().m_90592_();
            Vec3 pos = entity.m_20318_(provider.getPartialTick());
            RenderEntityProcedure.execute((Event)provider, (LevelAccessor)level, entity);
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
        }
    }

    public static void execute(LevelAccessor world, Entity entity) {
        RenderEntityProcedure.execute(null, world, entity);
    }

    private static void execute(@Nullable Event event, final LevelAccessor world, Entity entity) {
        LivingEntity _livEnt17;
        BlockState blockState;
        if (entity == null) {
            return;
        }
        Object target = null;
        Direction dir = Direction.NORTH;
        double count = 0.0;
        double target_x = 0.0;
        double target_y = 0.0;
        double target_z = 0.0;
        double rep = 0.0;
        double angle = 0.0;
        double distance = 0.0;
        double range = 0.0;
        HitResult hitResult = Minecraft.m_91087_().f_91077_;
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult _blockHitResult = (BlockHitResult)hitResult;
            blockState = world.m_8055_(_blockHitResult.m_82425_());
        } else {
            blockState = Blocks.f_50016_.m_49966_();
        }
        if (blockState.m_60734_() == SoloLevelingModBlocks.TRADER_BLOCK.get()) {
            dir = new Object(){

                public Direction getDirection(BlockPos pos) {
                    Comparable comparable;
                    BlockState _bs = world.m_8055_(pos);
                    Property property = _bs.m_60734_().m_49965_().m_61081_("facing");
                    if (property != null && (comparable = _bs.m_61143_(property)) instanceof Direction) {
                        Direction _dir = (Direction)comparable;
                        return _dir;
                    }
                    if (_bs.m_61138_((Property)BlockStateProperties.f_61365_)) {
                        return Direction.m_122387_((Direction.Axis)((Direction.Axis)_bs.m_61143_((Property)BlockStateProperties.f_61365_)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
                    }
                    if (_bs.m_61138_((Property)BlockStateProperties.f_61364_)) {
                        return Direction.m_122387_((Direction.Axis)((Direction.Axis)_bs.m_61143_((Property)BlockStateProperties.f_61364_)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
                    }
                    return Direction.NORTH;
                }
            }.getDirection(new BlockPos(entity.m_9236_().m_45547_(new ClipContext(entity.m_20299_(1.0f), entity.m_20299_(1.0f).m_82549_(entity.m_20252_(1.0f).m_82490_(5.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, entity)).m_82425_().m_123341_(), entity.m_9236_().m_45547_(new ClipContext(entity.m_20299_(1.0f), entity.m_20299_(1.0f).m_82549_(entity.m_20252_(1.0f).m_82490_(5.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, entity)).m_82425_().m_123342_(), entity.m_9236_().m_45547_(new ClipContext(entity.m_20299_(1.0f), entity.m_20299_(1.0f).m_82549_(entity.m_20252_(1.0f).m_82490_(5.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, entity)).m_82425_().m_123343_()));
            RenderEntityProcedure.renderItem(new Object(){

                public ItemStack getItemStack(LevelAccessor world, BlockPos pos, int slotid) {
                    AtomicReference<ItemStack> _retval = new AtomicReference<ItemStack>(ItemStack.f_41583_);
                    BlockEntity _ent = world.m_7702_(pos);
                    if (_ent != null) {
                        _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41777_()));
                    }
                    return _retval.get();
                }
            }.getItemStack(world, new BlockPos(entity.m_9236_().m_45547_(new ClipContext(entity.m_20299_(1.0f), entity.m_20299_(1.0f).m_82549_(entity.m_20252_(1.0f).m_82490_(5.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, entity)).m_82425_().m_123341_(), entity.m_9236_().m_45547_(new ClipContext(entity.m_20299_(1.0f), entity.m_20299_(1.0f).m_82549_(entity.m_20252_(1.0f).m_82490_(5.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, entity)).m_82425_().m_123342_(), entity.m_9236_().m_45547_(new ClipContext(entity.m_20299_(1.0f), entity.m_20299_(1.0f).m_82549_(entity.m_20252_(1.0f).m_82490_(5.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, entity)).m_82425_().m_123343_()), 0), (double)entity.m_9236_().m_45547_(new ClipContext(entity.m_20299_(1.0f), entity.m_20299_(1.0f).m_82549_(entity.m_20252_(1.0f).m_82490_(5.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, entity)).m_82425_().m_123341_() + 0.5 + (double)dir.m_122429_() * 0.7, (double)entity.m_9236_().m_45547_(new ClipContext(entity.m_20299_(1.0f), entity.m_20299_(1.0f).m_82549_(entity.m_20252_(1.0f).m_82490_(5.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, entity)).m_82425_().m_123342_() + 0.5, (double)entity.m_9236_().m_45547_(new ClipContext(entity.m_20299_(1.0f), entity.m_20299_(1.0f).m_82549_(entity.m_20252_(1.0f).m_82490_(5.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, entity)).m_82425_().m_123343_() + 0.5 + (double)dir.m_122431_() * 0.7, (float)Math.toDegrees(Math.asin(dir.m_122429_())), 0.0f, 0.0f, 0.5f, true, false);
        }
        if (entity instanceof LivingEntity && (_livEnt17 = (LivingEntity)entity).m_21023_((MobEffect)SoloLevelingModMobEffects.ILLUSION.get()) && world instanceof ClientLevel) {
            for (Entity entityiterator : ((ClientLevel)world).m_104735_()) {
                if (entityiterator == entity) continue;
                distance = Math.sqrt(Math.pow(entity.m_20185_() - entityiterator.m_20185_(), 2.0) + Math.pow(entity.m_20189_() - entityiterator.m_20189_(), 2.0));
                rep = 0.0;
                angle = 0.0;
                for (int index0 = 0; index0 < 7; ++index0) {
                    RenderEntityProcedure.renderEntity(entityiterator, entity.m_20185_() + Math.sin(rep += 0.8975979010256552) * distance, entityiterator.m_20186_(), entity.m_20189_() + Math.cos(rep) * distance, (float)angle, 0.0f, 0.0f, 1.0f, false);
                    angle += 51.0;
                }
            }
        }
        if (SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).wave_range > 0.0) {
            rep = 0.0;
            range = SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).wave_range;
            for (int index1 = 0; index1 < 120; ++index1) {
                RenderEntityProcedure.renderBlock(world.m_8055_(BlockPos.m_274561_((double)((double)Math.round(SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).effectX + Math.sin(rep += 0.05235987755982988) * range) + 0.5), (double)(SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).effectY - 1.0), (double)((double)Math.round(SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).effectZ + Math.cos(rep) * range) + 0.5))), (double)Math.round(SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).effectX + Math.sin(rep) * range) + 0.5, SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).effectY + 0.1, (double)Math.round(SoloLevelingModVariables.MapVariables.get((LevelAccessor)world).effectZ + Math.cos(rep) * range) + 0.5, 0.0f, 0.0f, 0.0f, 1.1f, false);
            }
        }
        if (Math.round(((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).damage_show_timer) > 1L) {
            RenderEntityProcedure.renderTexts("DMG: " + new DecimalFormat("##.##").format(((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).damage_show_value), ((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).damage_show_X, ((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).damage_show_Y, ((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).damage_show_Z, Minecraft.m_91087_().f_91063_.m_109153_().m_90590_() + 180.0f, Minecraft.m_91087_().f_91063_.m_109153_().m_90589_() * -1.0f, 0.0f, 0.025f, (int)(55.0 + 200.0 * (((SoloLevelingModVariables.PlayerVariables)entity.getCapability(SoloLevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SoloLevelingModVariables.PlayerVariables())).damage_show_timer / 80.0)) << 24 | 0xFF0000 | 0 | 0, true);
        }
    }
}

