/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sololeveling.network;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.mcreator.sololeveling.SoloLevelingMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SoloLevelingModVariables {
    public static String skill_name = "";
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        SoloLevelingMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        SoloLevelingMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        SoloLevelingMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final int target;
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
            this.target = buffer.readInt();
        }

        public PlayerVariablesSyncMessage(PlayerVariables data, int entityid) {
            this.data = data;
            this.target = entityid;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
            buffer.writeInt(message.target);
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.m_9236_().m_6815_(message.target).getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.level = message.data.level;
                    variables.xp = message.data.xp;
                    variables.player_class = message.data.player_class;
                    variables.Strength = message.data.Strength;
                    variables.Agility = message.data.Agility;
                    variables.Vitality = message.data.Vitality;
                    variables.Intelligence = message.data.Intelligence;
                    variables.attack_cd = message.data.attack_cd;
                    variables.in_combat = message.data.in_combat;
                    variables.awakened = message.data.awakened;
                    variables.mana = message.data.mana;
                    variables.hp = message.data.hp;
                    variables.points = message.data.points;
                    variables.skill_slots = message.data.skill_slots;
                    variables.skill = message.data.skill;
                    variables.title = message.data.title;
                    variables.speed_limit = message.data.speed_limit;
                    variables.ShowDamage = message.data.ShowDamage;
                    variables.skill_page = message.data.skill_page;
                    variables.total_damage = message.data.total_damage;
                    variables.player_gate_id = message.data.player_gate_id;
                    variables.exitX = message.data.exitX;
                    variables.exitY = message.data.exitY;
                    variables.exitZ = message.data.exitZ;
                    variables.soliders_in_shadow = message.data.soliders_in_shadow;
                    variables.igris_arise = message.data.igris_arise;
                    variables.kamish_arise = message.data.kamish_arise;
                    variables.cleared_dungeon = message.data.cleared_dungeon;
                    variables.shaking_on = message.data.shaking_on;
                    variables.view_angle = message.data.view_angle;
                    variables.hide_overlay = message.data.hide_overlay;
                    variables.target_lock = message.data.target_lock;
                    variables.lock_on = message.data.lock_on;
                    variables.bonus_resistance_timer = message.data.bonus_resistance_timer;
                    variables.bonus_resistance = message.data.bonus_resistance;
                    variables.enter_dimension = message.data.enter_dimension;
                    variables.exit_dimension = message.data.exit_dimension;
                    variables.in_dungeon = message.data.in_dungeon;
                    variables.Money = message.data.Money;
                    variables.gui_scroll = message.data.gui_scroll;
                    variables.gui_item_price = message.data.gui_item_price;
                    variables.power_buff = message.data.power_buff;
                    variables.power_buff_timer = message.data.power_buff_timer;
                    variables.speed_buff = message.data.speed_buff;
                    variables.speed_buff_timer = message.data.speed_buff_timer;
                    variables.health_buff = message.data.health_buff;
                    variables.health_buff_tiumer = message.data.health_buff_tiumer;
                    variables.guild_name = message.data.guild_name;
                    variables.quest_id = message.data.quest_id;
                    variables.QuestName = message.data.QuestName;
                    variables.QuestDescription = message.data.QuestDescription;
                    variables.QuestGoal = message.data.QuestGoal;
                    variables.quest_current_finished = message.data.quest_current_finished;
                    variables.quest_des_part1 = message.data.quest_des_part1;
                    variables.quest_des_part2 = message.data.quest_des_part2;
                    variables.quest_des_part3 = message.data.quest_des_part3;
                    variables.quest_start = message.data.quest_start;
                    variables.bery_arise = message.data.bery_arise;
                    variables.guild_owner = message.data.guild_owner;
                    variables.invited_to_guild = message.data.invited_to_guild;
                    variables.army_follow = message.data.army_follow;
                    variables.secret_dungeon_tries = message.data.secret_dungeon_tries;
                    variables.day = message.data.day;
                    variables.DailyQuest = message.data.DailyQuest;
                    variables.daily_quest_goal = message.data.daily_quest_goal;
                    variables.daily_quest_goal_2 = message.data.daily_quest_goal_2;
                    variables.sneaking = message.data.sneaking;
                    variables.enable_daily_quests = message.data.enable_daily_quests;
                    variables.special_reward = message.data.special_reward;
                    variables.punishment_timer = message.data.punishment_timer;
                    variables.pX = message.data.pX;
                    variables.pY = message.data.pY;
                    variables.pZ = message.data.pZ;
                    variables.p_old_dimension = message.data.p_old_dimension;
                    variables.ice_bears_arise = message.data.ice_bears_arise;
                    variables.demon_castle_floor = message.data.demon_castle_floor;
                    variables.do_not_round = message.data.do_not_round;
                    variables.guild_name_show = message.data.guild_name_show;
                    variables.guild_scroll = message.data.guild_scroll;
                    variables.update_tick_count = message.data.update_tick_count;
                    variables.cleared_gates = message.data.cleared_gates;
                    variables.hide_class = message.data.hide_class;
                    variables.kaisel_arise = message.data.kaisel_arise;
                    variables.learned_skills = message.data.learned_skills;
                    variables.learned_skills_save = message.data.learned_skills_save;
                    variables.orcs_shadows = message.data.orcs_shadows;
                    variables.tusk_arise = message.data.tusk_arise;
                    variables.wolf_slayer_progress = message.data.wolf_slayer_progress;
                    variables.goblin_slayer_progress = message.data.goblin_slayer_progress;
                    variables.golem_slayer_progress = message.data.golem_slayer_progress;
                    variables.demon_slayer_progress = message.data.demon_slayer_progress;
                    variables.sense = message.data.sense;
                    variables.sense_gates = message.data.sense_gates;
                    variables.sense_monsters = message.data.sense_monsters;
                    variables.display_health = message.data.display_health;
                    variables.display_name = message.data.display_name;
                    variables.transformation = message.data.transformation;
                    variables.Dialog = message.data.Dialog;
                    variables.DialogID = message.data.DialogID;
                    variables.Answer1 = message.data.Answer1;
                    variables.Answer2 = message.data.Answer2;
                    variables.Answer3 = message.data.Answer3;
                    variables.ans1_continue = message.data.ans1_continue;
                    variables.ans2_continue = message.data.ans2_continue;
                    variables.ans3_continue = message.data.ans3_continue;
                    variables.special_dialog_event = message.data.special_dialog_event;
                    variables.special1 = message.data.special1;
                    variables.special2 = message.data.special2;
                    variables.special3 = message.data.special3;
                    variables.Talker = message.data.Talker;
                    variables.knight_form = message.data.knight_form;
                    variables.whole_cd = message.data.whole_cd;
                    variables.menuX = message.data.menuX;
                    variables.menuY = message.data.menuY;
                    variables.Skill_ID = message.data.Skill_ID;
                    variables.skill_menu = message.data.skill_menu;
                    variables.level_up_alarm = message.data.level_up_alarm;
                    variables.army_cd = message.data.army_cd;
                    variables.lock_yaw = message.data.lock_yaw;
                    variables.lock_pitch = message.data.lock_pitch;
                    variables.animation = message.data.animation;
                    variables.loaded = message.data.loaded;
                    variables.filter_weapons = message.data.filter_weapons;
                    variables.filter_armor = message.data.filter_armor;
                    variables.filter_word = message.data.filter_word;
                    variables.filtered_items = message.data.filtered_items;
                    variables.damage_show_X = message.data.damage_show_X;
                    variables.damage_show_Y = message.data.damage_show_Y;
                    variables.damage_show_Z = message.data.damage_show_Z;
                    variables.join_world = message.data.join_world;
                    variables.reward_1 = message.data.reward_1;
                    variables.reward_2 = message.data.reward_2;
                    variables.reward_3 = message.data.reward_3;
                    variables.got_Reward = message.data.got_Reward;
                    variables.run_X = message.data.run_X;
                    variables.run_Y = message.data.run_Y;
                    variables.run_Z = message.data.run_Z;
                    variables.damage_show_timer = message.data.damage_show_timer;
                    variables.damage_show_value = message.data.damage_show_value;
                    variables.damage_vx_show = message.data.damage_vx_show;
                    variables.damage_vz_show = message.data.damage_vz_show;
                    variables.cr_particles = message.data.cr_particles;
                    variables.cr_animation = message.data.cr_animation;
                    variables.cr_trajectory = message.data.cr_trajectory;
                    variables.cr_range = message.data.cr_range;
                    variables.cr_strength_scale = message.data.cr_strength_scale;
                    variables.cr_int_scale = message.data.cr_int_scale;
                    variables.cr_agillity_scale = message.data.cr_agillity_scale;
                    variables.cr_vitallity_scale = message.data.cr_vitallity_scale;
                    variables.cr_sense_scale = message.data.cr_sense_scale;
                    variables.cr_cd = message.data.cr_cd;
                    variables.cr_effect = message.data.cr_effect;
                    variables.cr_cost = message.data.cr_cost;
                    variables.cr_speed = message.data.cr_speed;
                    variables.cr_icon = message.data.cr_icon;
                    variables.cr_forward = message.data.cr_forward;
                    variables.cr_jump = message.data.cr_jump;
                    variables.cr_delay = message.data.cr_delay;
                    variables.cr_repetition = message.data.cr_repetition;
                    variables.cr_level_requirement = message.data.cr_level_requirement;
                    variables.cr_repetetion_delay = message.data.cr_repetetion_delay;
                    variables.cr_default_damage = message.data.cr_default_damage;
                    variables.cr_skill_position = message.data.cr_skill_position;
                    variables.left_arm = message.data.left_arm;
                    variables.right_arm = message.data.right_arm;
                    variables.left_leg = message.data.left_leg;
                    variables.right_leg = message.data.right_leg;
                    variables.right_hand_cd = message.data.right_hand_cd;
                    variables.left_hand_cd = message.data.left_hand_cd;
                    variables.left_leg_cd = message.data.left_leg_cd;
                    variables.right_leg_cd = message.data.right_leg_cd;
                    variables.picked_skill = message.data.picked_skill;
                    variables.block_cd = message.data.block_cd;
                    variables.guild_flag_id = message.data.guild_flag_id;
                    variables.guild_flag_background = message.data.guild_flag_background;
                    variables.guild_flag_symbol = message.data.guild_flag_symbol;
                    variables.guild_flag_front = message.data.guild_flag_front;
                    variables.guild_flag_background_color = message.data.guild_flag_background_color;
                    variables.guild_flag_symbol_color = message.data.guild_flag_symbol_color;
                    variables.guild_flag_front_color = message.data.guild_flag_front_color;
                    variables.guild_list_scroll = message.data.guild_list_scroll;
                    variables.guild_list_scroll_actual = message.data.guild_list_scroll_actual;
                    variables.stamina = message.data.stamina;
                    variables.red_gate_timer = message.data.red_gate_timer;
                    variables.learned_skill_menu = message.data.learned_skill_menu;
                    variables.Skill_ID_Stone = message.data.Skill_ID_Stone;
                    variables.ant_shadows = message.data.ant_shadows;
                    variables.shadow_army = message.data.shadow_army;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double level = 0.0;
        public double xp = 0.0;
        public String player_class = "NONE";
        public double Strength = 0.0;
        public double Agility = 0.0;
        public double Vitality = 0.0;
        public double Intelligence = 0.0;
        public double attack_cd = 0.0;
        public double in_combat = 0.0;
        public boolean awakened = false;
        public double mana = 0.0;
        public double hp = 0.0;
        public double points = 0.0;
        public ItemStack skill_slots = ItemStack.f_41583_;
        public double skill = 0.0;
        public String title = "NONE";
        public double speed_limit = 100.0;
        public boolean ShowDamage = true;
        public double skill_page = 0.0;
        public double total_damage = 0.0;
        public double player_gate_id = 0.0;
        public double exitX = 0.0;
        public double exitY = 0.0;
        public double exitZ = 0.0;
        public double soliders_in_shadow = 0.0;
        public boolean igris_arise = false;
        public boolean kamish_arise = false;
        public boolean cleared_dungeon = false;
        public double shaking_on = 0.0;
        public double view_angle = 0.0;
        public boolean hide_overlay = false;
        public String target_lock = "\"\"";
        public boolean lock_on = false;
        public double bonus_resistance_timer = 0.0;
        public double bonus_resistance = 0.0;
        public boolean enter_dimension = false;
        public boolean exit_dimension = false;
        public boolean in_dungeon = false;
        public double Money = 0.0;
        public double gui_scroll = 0.0;
        public double gui_item_price = 0.0;
        public double power_buff = 0.0;
        public double power_buff_timer = 0.0;
        public double speed_buff = 0.0;
        public double speed_buff_timer = 0.0;
        public double health_buff = 0.0;
        public double health_buff_tiumer = 0.0;
        public String guild_name = "NONE";
        public double quest_id = 0.0;
        public String QuestName = "";
        public String QuestDescription = "\"\"";
        public double QuestGoal = 0.0;
        public double quest_current_finished = 0.0;
        public String quest_des_part1 = "\"\"";
        public String quest_des_part2 = "\"\"";
        public String quest_des_part3 = "\"\"";
        public double quest_start = 0.0;
        public boolean bery_arise = false;
        public boolean guild_owner = false;
        public String invited_to_guild = "\"\"";
        public boolean army_follow = false;
        public double secret_dungeon_tries = 0.0;
        public double day = 0.0;
        public boolean DailyQuest = false;
        public double daily_quest_goal = 0.0;
        public double daily_quest_goal_2 = 0.0;
        public boolean sneaking = false;
        public boolean enable_daily_quests = true;
        public boolean special_reward = false;
        public double punishment_timer = 0.0;
        public double pX = 0.0;
        public double pY = 0.0;
        public double pZ = 0.0;
        public String p_old_dimension = "\"\"";
        public double ice_bears_arise = 0.0;
        public double demon_castle_floor = 0.0;
        public boolean do_not_round = false;
        public String guild_name_show = "\"\"";
        public double guild_scroll = 0.0;
        public double update_tick_count = 0.0;
        public double cleared_gates = 0.0;
        public boolean hide_class = false;
        public boolean kaisel_arise = false;
        public double learned_skills = 0.0;
        public ItemStack learned_skills_save = ItemStack.f_41583_;
        public double orcs_shadows = 0.0;
        public boolean tusk_arise = false;
        public double wolf_slayer_progress = 0.0;
        public double goblin_slayer_progress = 0.0;
        public double golem_slayer_progress = 0.0;
        public double demon_slayer_progress = 0.0;
        public double sense = 0.0;
        public boolean sense_gates = true;
        public boolean sense_monsters = true;
        public boolean display_health = true;
        public boolean display_name = true;
        public boolean transformation = false;
        public String Dialog = "\"\"";
        public double DialogID = 0.0;
        public String Answer1 = "\"\"";
        public String Answer2 = "\"\"";
        public String Answer3 = "\"\"";
        public double ans1_continue = 0.0;
        public double ans2_continue = 0.0;
        public double ans3_continue = 0.0;
        public double special_dialog_event = 0.0;
        public double special1 = 0.0;
        public double special2 = 0.0;
        public double special3 = 0.0;
        public String Talker = "\"\"";
        public boolean knight_form = false;
        public double whole_cd = 0.0;
        public double menuX = 0.0;
        public double menuY = 0.0;
        public double Skill_ID = 0.0;
        public double skill_menu = 0.0;
        public double level_up_alarm = 0.0;
        public boolean army_cd = false;
        public double lock_yaw = 0.0;
        public double lock_pitch = 0.0;
        public double animation = 0.0;
        public boolean loaded = false;
        public boolean filter_weapons = false;
        public boolean filter_armor = false;
        public String filter_word = "";
        public ItemStack filtered_items = ItemStack.f_41583_;
        public double damage_show_X = 0.0;
        public double damage_show_Y = 0.0;
        public double damage_show_Z = 0.0;
        public boolean join_world = false;
        public ItemStack reward_1 = ItemStack.f_41583_;
        public ItemStack reward_2 = ItemStack.f_41583_;
        public ItemStack reward_3 = ItemStack.f_41583_;
        public boolean got_Reward = false;
        public double run_X = 0.0;
        public double run_Y = 0.0;
        public double run_Z = 0.0;
        public double damage_show_timer = 0.0;
        public double damage_show_value = 0.0;
        public double damage_vx_show = 0.0;
        public double damage_vz_show = 0.0;
        public double cr_particles = 0.0;
        public double cr_animation = 0.0;
        public double cr_trajectory = 0.0;
        public double cr_range = 0.0;
        public double cr_strength_scale = 0.0;
        public double cr_int_scale = 0.0;
        public double cr_agillity_scale = 0.0;
        public double cr_vitallity_scale = 0.0;
        public double cr_sense_scale = 0.0;
        public double cr_cd = 0.0;
        public double cr_effect = 0.0;
        public double cr_cost = 0.0;
        public double cr_speed = 0.0;
        public double cr_icon = 0.0;
        public double cr_forward = 0.0;
        public double cr_jump = 0.0;
        public double cr_delay = 0.0;
        public double cr_repetition = 0.0;
        public double cr_level_requirement = 0.0;
        public double cr_repetetion_delay = 0.0;
        public double cr_default_damage = 0.0;
        public double cr_skill_position = 0.0;
        public boolean left_arm = false;
        public boolean right_arm = false;
        public boolean left_leg = false;
        public boolean right_leg = false;
        public double right_hand_cd = 0.0;
        public double left_hand_cd = 0.0;
        public double left_leg_cd = 0.0;
        public double right_leg_cd = 0.0;
        public String picked_skill = "\"\"";
        public double block_cd = 0.0;
        public double guild_flag_id = 0.0;
        public double guild_flag_background = 0.0;
        public double guild_flag_symbol = 0.0;
        public double guild_flag_front = 0.0;
        public double guild_flag_background_color = 0.0;
        public double guild_flag_symbol_color = 0.0;
        public double guild_flag_front_color = 0.0;
        public double guild_list_scroll = 0.0;
        public double guild_list_scroll_actual = 0.0;
        public double stamina = 0.0;
        public double red_gate_timer = 0.0;
        public double learned_skill_menu = 0.0;
        public double Skill_ID_Stone = 0.0;
        public double ant_shadows = 0.0;
        public ItemStack shadow_army = ItemStack.f_41583_;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                SoloLevelingMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)entity.m_9236_()).m_46472_()), (Object)new PlayerVariablesSyncMessage(this, entity.m_19879_()));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("level", this.level);
            nbt.m_128347_("xp", this.xp);
            nbt.m_128359_("player_class", this.player_class);
            nbt.m_128347_("Strength", this.Strength);
            nbt.m_128347_("Agility", this.Agility);
            nbt.m_128347_("Vitality", this.Vitality);
            nbt.m_128347_("Intelligence", this.Intelligence);
            nbt.m_128347_("attack_cd", this.attack_cd);
            nbt.m_128347_("in_combat", this.in_combat);
            nbt.m_128379_("awakened", this.awakened);
            nbt.m_128347_("mana", this.mana);
            nbt.m_128347_("hp", this.hp);
            nbt.m_128347_("points", this.points);
            nbt.m_128365_("skill_slots", (Tag)this.skill_slots.m_41739_(new CompoundTag()));
            nbt.m_128347_("skill", this.skill);
            nbt.m_128359_("title", this.title);
            nbt.m_128347_("speed_limit", this.speed_limit);
            nbt.m_128379_("ShowDamage", this.ShowDamage);
            nbt.m_128347_("skill_page", this.skill_page);
            nbt.m_128347_("total_damage", this.total_damage);
            nbt.m_128347_("player_gate_id", this.player_gate_id);
            nbt.m_128347_("exitX", this.exitX);
            nbt.m_128347_("exitY", this.exitY);
            nbt.m_128347_("exitZ", this.exitZ);
            nbt.m_128347_("soliders_in_shadow", this.soliders_in_shadow);
            nbt.m_128379_("igris_arise", this.igris_arise);
            nbt.m_128379_("kamish_arise", this.kamish_arise);
            nbt.m_128379_("cleared_dungeon", this.cleared_dungeon);
            nbt.m_128347_("shaking_on", this.shaking_on);
            nbt.m_128347_("view_angle", this.view_angle);
            nbt.m_128379_("hide_overlay", this.hide_overlay);
            nbt.m_128359_("target_lock", this.target_lock);
            nbt.m_128379_("lock_on", this.lock_on);
            nbt.m_128347_("bonus_resistance_timer", this.bonus_resistance_timer);
            nbt.m_128347_("bonus_resistance", this.bonus_resistance);
            nbt.m_128379_("enter_dimension", this.enter_dimension);
            nbt.m_128379_("exit_dimension", this.exit_dimension);
            nbt.m_128379_("in_dungeon", this.in_dungeon);
            nbt.m_128347_("Money", this.Money);
            nbt.m_128347_("gui_scroll", this.gui_scroll);
            nbt.m_128347_("gui_item_price", this.gui_item_price);
            nbt.m_128347_("power_buff", this.power_buff);
            nbt.m_128347_("power_buff_timer", this.power_buff_timer);
            nbt.m_128347_("speed_buff", this.speed_buff);
            nbt.m_128347_("speed_buff_timer", this.speed_buff_timer);
            nbt.m_128347_("health_buff", this.health_buff);
            nbt.m_128347_("health_buff_tiumer", this.health_buff_tiumer);
            nbt.m_128359_("guild_name", this.guild_name);
            nbt.m_128347_("quest_id", this.quest_id);
            nbt.m_128359_("QuestName", this.QuestName);
            nbt.m_128359_("QuestDescription", this.QuestDescription);
            nbt.m_128347_("QuestGoal", this.QuestGoal);
            nbt.m_128347_("quest_current_finished", this.quest_current_finished);
            nbt.m_128359_("quest_des_part1", this.quest_des_part1);
            nbt.m_128359_("quest_des_part2", this.quest_des_part2);
            nbt.m_128359_("quest_des_part3", this.quest_des_part3);
            nbt.m_128347_("quest_start", this.quest_start);
            nbt.m_128379_("bery_arise", this.bery_arise);
            nbt.m_128379_("guild_owner", this.guild_owner);
            nbt.m_128359_("invited_to_guild", this.invited_to_guild);
            nbt.m_128379_("army_follow", this.army_follow);
            nbt.m_128347_("secret_dungeon_tries", this.secret_dungeon_tries);
            nbt.m_128347_("day", this.day);
            nbt.m_128379_("DailyQuest", this.DailyQuest);
            nbt.m_128347_("daily_quest_goal", this.daily_quest_goal);
            nbt.m_128347_("daily_quest_goal_2", this.daily_quest_goal_2);
            nbt.m_128379_("sneaking", this.sneaking);
            nbt.m_128379_("enable_daily_quests", this.enable_daily_quests);
            nbt.m_128379_("special_reward", this.special_reward);
            nbt.m_128347_("punishment_timer", this.punishment_timer);
            nbt.m_128347_("pX", this.pX);
            nbt.m_128347_("pY", this.pY);
            nbt.m_128347_("pZ", this.pZ);
            nbt.m_128359_("p_old_dimension", this.p_old_dimension);
            nbt.m_128347_("ice_bears_arise", this.ice_bears_arise);
            nbt.m_128347_("demon_castle_floor", this.demon_castle_floor);
            nbt.m_128379_("do_not_round", this.do_not_round);
            nbt.m_128359_("guild_name_show", this.guild_name_show);
            nbt.m_128347_("guild_scroll", this.guild_scroll);
            nbt.m_128347_("update_tick_count", this.update_tick_count);
            nbt.m_128347_("cleared_gates", this.cleared_gates);
            nbt.m_128379_("hide_class", this.hide_class);
            nbt.m_128379_("kaisel_arise", this.kaisel_arise);
            nbt.m_128347_("learned_skills", this.learned_skills);
            nbt.m_128365_("learned_skills_save", (Tag)this.learned_skills_save.m_41739_(new CompoundTag()));
            nbt.m_128347_("orcs_shadows", this.orcs_shadows);
            nbt.m_128379_("tusk_arise", this.tusk_arise);
            nbt.m_128347_("wolf_slayer_progress", this.wolf_slayer_progress);
            nbt.m_128347_("goblin_slayer_progress", this.goblin_slayer_progress);
            nbt.m_128347_("golem_slayer_progress", this.golem_slayer_progress);
            nbt.m_128347_("demon_slayer_progress", this.demon_slayer_progress);
            nbt.m_128347_("sense", this.sense);
            nbt.m_128379_("sense_gates", this.sense_gates);
            nbt.m_128379_("sense_monsters", this.sense_monsters);
            nbt.m_128379_("display_health", this.display_health);
            nbt.m_128379_("display_name", this.display_name);
            nbt.m_128379_("transformation", this.transformation);
            nbt.m_128359_("Dialog", this.Dialog);
            nbt.m_128347_("DialogID", this.DialogID);
            nbt.m_128359_("Answer1", this.Answer1);
            nbt.m_128359_("Answer2", this.Answer2);
            nbt.m_128359_("Answer3", this.Answer3);
            nbt.m_128347_("ans1_continue", this.ans1_continue);
            nbt.m_128347_("ans2_continue", this.ans2_continue);
            nbt.m_128347_("ans3_continue", this.ans3_continue);
            nbt.m_128347_("special_dialog_event", this.special_dialog_event);
            nbt.m_128347_("special1", this.special1);
            nbt.m_128347_("special2", this.special2);
            nbt.m_128347_("special3", this.special3);
            nbt.m_128359_("Talker", this.Talker);
            nbt.m_128379_("knight_form", this.knight_form);
            nbt.m_128347_("whole_cd", this.whole_cd);
            nbt.m_128347_("menuX", this.menuX);
            nbt.m_128347_("menuY", this.menuY);
            nbt.m_128347_("Skill_ID", this.Skill_ID);
            nbt.m_128347_("skill_menu", this.skill_menu);
            nbt.m_128347_("level_up_alarm", this.level_up_alarm);
            nbt.m_128379_("army_cd", this.army_cd);
            nbt.m_128347_("lock_yaw", this.lock_yaw);
            nbt.m_128347_("lock_pitch", this.lock_pitch);
            nbt.m_128347_("animation", this.animation);
            nbt.m_128379_("loaded", this.loaded);
            nbt.m_128379_("filter_weapons", this.filter_weapons);
            nbt.m_128379_("filter_armor", this.filter_armor);
            nbt.m_128359_("filter_word", this.filter_word);
            nbt.m_128365_("filtered_items", (Tag)this.filtered_items.m_41739_(new CompoundTag()));
            nbt.m_128347_("damage_show_X", this.damage_show_X);
            nbt.m_128347_("damage_show_Y", this.damage_show_Y);
            nbt.m_128347_("damage_show_Z", this.damage_show_Z);
            nbt.m_128379_("join_world", this.join_world);
            nbt.m_128365_("reward_1", (Tag)this.reward_1.m_41739_(new CompoundTag()));
            nbt.m_128365_("reward_2", (Tag)this.reward_2.m_41739_(new CompoundTag()));
            nbt.m_128365_("reward_3", (Tag)this.reward_3.m_41739_(new CompoundTag()));
            nbt.m_128379_("got_Reward", this.got_Reward);
            nbt.m_128347_("run_X", this.run_X);
            nbt.m_128347_("run_Y", this.run_Y);
            nbt.m_128347_("run_Z", this.run_Z);
            nbt.m_128347_("damage_show_timer", this.damage_show_timer);
            nbt.m_128347_("damage_show_value", this.damage_show_value);
            nbt.m_128347_("damage_vx_show", this.damage_vx_show);
            nbt.m_128347_("damage_vz_show", this.damage_vz_show);
            nbt.m_128347_("cr_particles", this.cr_particles);
            nbt.m_128347_("cr_animation", this.cr_animation);
            nbt.m_128347_("cr_trajectory", this.cr_trajectory);
            nbt.m_128347_("cr_range", this.cr_range);
            nbt.m_128347_("cr_strength_scale", this.cr_strength_scale);
            nbt.m_128347_("cr_int_scale", this.cr_int_scale);
            nbt.m_128347_("cr_agillity_scale", this.cr_agillity_scale);
            nbt.m_128347_("cr_vitallity_scale", this.cr_vitallity_scale);
            nbt.m_128347_("cr_sense_scale", this.cr_sense_scale);
            nbt.m_128347_("cr_cd", this.cr_cd);
            nbt.m_128347_("cr_effect", this.cr_effect);
            nbt.m_128347_("cr_cost", this.cr_cost);
            nbt.m_128347_("cr_speed", this.cr_speed);
            nbt.m_128347_("cr_icon", this.cr_icon);
            nbt.m_128347_("cr_forward", this.cr_forward);
            nbt.m_128347_("cr_jump", this.cr_jump);
            nbt.m_128347_("cr_delay", this.cr_delay);
            nbt.m_128347_("cr_repetition", this.cr_repetition);
            nbt.m_128347_("cr_level_requirement", this.cr_level_requirement);
            nbt.m_128347_("cr_repetetion_delay", this.cr_repetetion_delay);
            nbt.m_128347_("cr_default_damage", this.cr_default_damage);
            nbt.m_128347_("cr_skill_position", this.cr_skill_position);
            nbt.m_128379_("left_arm", this.left_arm);
            nbt.m_128379_("right_arm", this.right_arm);
            nbt.m_128379_("left_leg", this.left_leg);
            nbt.m_128379_("right_leg", this.right_leg);
            nbt.m_128347_("right_hand_cd", this.right_hand_cd);
            nbt.m_128347_("left_hand_cd", this.left_hand_cd);
            nbt.m_128347_("left_leg_cd", this.left_leg_cd);
            nbt.m_128347_("right_leg_cd", this.right_leg_cd);
            nbt.m_128359_("picked_skill", this.picked_skill);
            nbt.m_128347_("block_cd", this.block_cd);
            nbt.m_128347_("guild_flag_id", this.guild_flag_id);
            nbt.m_128347_("guild_flag_background", this.guild_flag_background);
            nbt.m_128347_("guild_flag_symbol", this.guild_flag_symbol);
            nbt.m_128347_("guild_flag_front", this.guild_flag_front);
            nbt.m_128347_("guild_flag_background_color", this.guild_flag_background_color);
            nbt.m_128347_("guild_flag_symbol_color", this.guild_flag_symbol_color);
            nbt.m_128347_("guild_flag_front_color", this.guild_flag_front_color);
            nbt.m_128347_("guild_list_scroll", this.guild_list_scroll);
            nbt.m_128347_("guild_list_scroll_actual", this.guild_list_scroll_actual);
            nbt.m_128347_("stamina", this.stamina);
            nbt.m_128347_("red_gate_timer", this.red_gate_timer);
            nbt.m_128347_("learned_skill_menu", this.learned_skill_menu);
            nbt.m_128347_("Skill_ID_Stone", this.Skill_ID_Stone);
            nbt.m_128347_("ant_shadows", this.ant_shadows);
            nbt.m_128365_("shadow_army", (Tag)this.shadow_army.m_41739_(new CompoundTag()));
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt;
            if (tag == null) {
                tag = this.writeNBT();
            }
            if ((nbt = (CompoundTag)tag) == null) {
                nbt = (CompoundTag)this.writeNBT();
            }
            this.level = nbt.m_128459_("level");
            this.xp = nbt.m_128459_("xp");
            this.player_class = nbt.m_128461_("player_class");
            this.Strength = nbt.m_128459_("Strength");
            this.Agility = nbt.m_128459_("Agility");
            this.Vitality = nbt.m_128459_("Vitality");
            this.Intelligence = nbt.m_128459_("Intelligence");
            this.attack_cd = nbt.m_128459_("attack_cd");
            this.in_combat = nbt.m_128459_("in_combat");
            this.awakened = nbt.m_128471_("awakened");
            this.mana = nbt.m_128459_("mana");
            this.hp = nbt.m_128459_("hp");
            this.points = nbt.m_128459_("points");
            this.skill_slots = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("skill_slots"));
            this.skill = nbt.m_128459_("skill");
            this.title = nbt.m_128461_("title");
            this.speed_limit = nbt.m_128459_("speed_limit");
            this.ShowDamage = nbt.m_128471_("ShowDamage");
            this.skill_page = nbt.m_128459_("skill_page");
            this.total_damage = nbt.m_128459_("total_damage");
            this.player_gate_id = nbt.m_128459_("player_gate_id");
            this.exitX = nbt.m_128459_("exitX");
            this.exitY = nbt.m_128459_("exitY");
            this.exitZ = nbt.m_128459_("exitZ");
            this.soliders_in_shadow = nbt.m_128459_("soliders_in_shadow");
            this.igris_arise = nbt.m_128471_("igris_arise");
            this.kamish_arise = nbt.m_128471_("kamish_arise");
            this.cleared_dungeon = nbt.m_128471_("cleared_dungeon");
            this.shaking_on = nbt.m_128459_("shaking_on");
            this.view_angle = nbt.m_128459_("view_angle");
            this.hide_overlay = nbt.m_128471_("hide_overlay");
            this.target_lock = nbt.m_128461_("target_lock");
            this.lock_on = nbt.m_128471_("lock_on");
            this.bonus_resistance_timer = nbt.m_128459_("bonus_resistance_timer");
            this.bonus_resistance = nbt.m_128459_("bonus_resistance");
            this.enter_dimension = nbt.m_128471_("enter_dimension");
            this.exit_dimension = nbt.m_128471_("exit_dimension");
            this.in_dungeon = nbt.m_128471_("in_dungeon");
            this.Money = nbt.m_128459_("Money");
            this.gui_scroll = nbt.m_128459_("gui_scroll");
            this.gui_item_price = nbt.m_128459_("gui_item_price");
            this.power_buff = nbt.m_128459_("power_buff");
            this.power_buff_timer = nbt.m_128459_("power_buff_timer");
            this.speed_buff = nbt.m_128459_("speed_buff");
            this.speed_buff_timer = nbt.m_128459_("speed_buff_timer");
            this.health_buff = nbt.m_128459_("health_buff");
            this.health_buff_tiumer = nbt.m_128459_("health_buff_tiumer");
            this.guild_name = nbt.m_128461_("guild_name");
            this.quest_id = nbt.m_128459_("quest_id");
            this.QuestName = nbt.m_128461_("QuestName");
            this.QuestDescription = nbt.m_128461_("QuestDescription");
            this.QuestGoal = nbt.m_128459_("QuestGoal");
            this.quest_current_finished = nbt.m_128459_("quest_current_finished");
            this.quest_des_part1 = nbt.m_128461_("quest_des_part1");
            this.quest_des_part2 = nbt.m_128461_("quest_des_part2");
            this.quest_des_part3 = nbt.m_128461_("quest_des_part3");
            this.quest_start = nbt.m_128459_("quest_start");
            this.bery_arise = nbt.m_128471_("bery_arise");
            this.guild_owner = nbt.m_128471_("guild_owner");
            this.invited_to_guild = nbt.m_128461_("invited_to_guild");
            this.army_follow = nbt.m_128471_("army_follow");
            this.secret_dungeon_tries = nbt.m_128459_("secret_dungeon_tries");
            this.day = nbt.m_128459_("day");
            this.DailyQuest = nbt.m_128471_("DailyQuest");
            this.daily_quest_goal = nbt.m_128459_("daily_quest_goal");
            this.daily_quest_goal_2 = nbt.m_128459_("daily_quest_goal_2");
            this.sneaking = nbt.m_128471_("sneaking");
            this.enable_daily_quests = nbt.m_128471_("enable_daily_quests");
            this.special_reward = nbt.m_128471_("special_reward");
            this.punishment_timer = nbt.m_128459_("punishment_timer");
            this.pX = nbt.m_128459_("pX");
            this.pY = nbt.m_128459_("pY");
            this.pZ = nbt.m_128459_("pZ");
            this.p_old_dimension = nbt.m_128461_("p_old_dimension");
            this.ice_bears_arise = nbt.m_128459_("ice_bears_arise");
            this.demon_castle_floor = nbt.m_128459_("demon_castle_floor");
            this.do_not_round = nbt.m_128471_("do_not_round");
            this.guild_name_show = nbt.m_128461_("guild_name_show");
            this.guild_scroll = nbt.m_128459_("guild_scroll");
            this.update_tick_count = nbt.m_128459_("update_tick_count");
            this.cleared_gates = nbt.m_128459_("cleared_gates");
            this.hide_class = nbt.m_128471_("hide_class");
            this.kaisel_arise = nbt.m_128471_("kaisel_arise");
            this.learned_skills = nbt.m_128459_("learned_skills");
            this.learned_skills_save = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("learned_skills_save"));
            this.orcs_shadows = nbt.m_128459_("orcs_shadows");
            this.tusk_arise = nbt.m_128471_("tusk_arise");
            this.wolf_slayer_progress = nbt.m_128459_("wolf_slayer_progress");
            this.goblin_slayer_progress = nbt.m_128459_("goblin_slayer_progress");
            this.golem_slayer_progress = nbt.m_128459_("golem_slayer_progress");
            this.demon_slayer_progress = nbt.m_128459_("demon_slayer_progress");
            this.sense = nbt.m_128459_("sense");
            this.sense_gates = nbt.m_128471_("sense_gates");
            this.sense_monsters = nbt.m_128471_("sense_monsters");
            this.display_health = nbt.m_128471_("display_health");
            this.display_name = nbt.m_128471_("display_name");
            this.transformation = nbt.m_128471_("transformation");
            this.Dialog = nbt.m_128461_("Dialog");
            this.DialogID = nbt.m_128459_("DialogID");
            this.Answer1 = nbt.m_128461_("Answer1");
            this.Answer2 = nbt.m_128461_("Answer2");
            this.Answer3 = nbt.m_128461_("Answer3");
            this.ans1_continue = nbt.m_128459_("ans1_continue");
            this.ans2_continue = nbt.m_128459_("ans2_continue");
            this.ans3_continue = nbt.m_128459_("ans3_continue");
            this.special_dialog_event = nbt.m_128459_("special_dialog_event");
            this.special1 = nbt.m_128459_("special1");
            this.special2 = nbt.m_128459_("special2");
            this.special3 = nbt.m_128459_("special3");
            this.Talker = nbt.m_128461_("Talker");
            this.knight_form = nbt.m_128471_("knight_form");
            this.whole_cd = nbt.m_128459_("whole_cd");
            this.menuX = nbt.m_128459_("menuX");
            this.menuY = nbt.m_128459_("menuY");
            this.Skill_ID = nbt.m_128459_("Skill_ID");
            this.skill_menu = nbt.m_128459_("skill_menu");
            this.level_up_alarm = nbt.m_128459_("level_up_alarm");
            this.army_cd = nbt.m_128471_("army_cd");
            this.lock_yaw = nbt.m_128459_("lock_yaw");
            this.lock_pitch = nbt.m_128459_("lock_pitch");
            this.animation = nbt.m_128459_("animation");
            this.loaded = nbt.m_128471_("loaded");
            this.filter_weapons = nbt.m_128471_("filter_weapons");
            this.filter_armor = nbt.m_128471_("filter_armor");
            this.filter_word = nbt.m_128461_("filter_word");
            this.filtered_items = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("filtered_items"));
            this.damage_show_X = nbt.m_128459_("damage_show_X");
            this.damage_show_Y = nbt.m_128459_("damage_show_Y");
            this.damage_show_Z = nbt.m_128459_("damage_show_Z");
            this.join_world = nbt.m_128471_("join_world");
            this.reward_1 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("reward_1"));
            this.reward_2 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("reward_2"));
            this.reward_3 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("reward_3"));
            this.got_Reward = nbt.m_128471_("got_Reward");
            this.run_X = nbt.m_128459_("run_X");
            this.run_Y = nbt.m_128459_("run_Y");
            this.run_Z = nbt.m_128459_("run_Z");
            this.damage_show_timer = nbt.m_128459_("damage_show_timer");
            this.damage_show_value = nbt.m_128459_("damage_show_value");
            this.damage_vx_show = nbt.m_128459_("damage_vx_show");
            this.damage_vz_show = nbt.m_128459_("damage_vz_show");
            this.cr_particles = nbt.m_128459_("cr_particles");
            this.cr_animation = nbt.m_128459_("cr_animation");
            this.cr_trajectory = nbt.m_128459_("cr_trajectory");
            this.cr_range = nbt.m_128459_("cr_range");
            this.cr_strength_scale = nbt.m_128459_("cr_strength_scale");
            this.cr_int_scale = nbt.m_128459_("cr_int_scale");
            this.cr_agillity_scale = nbt.m_128459_("cr_agillity_scale");
            this.cr_vitallity_scale = nbt.m_128459_("cr_vitallity_scale");
            this.cr_sense_scale = nbt.m_128459_("cr_sense_scale");
            this.cr_cd = nbt.m_128459_("cr_cd");
            this.cr_effect = nbt.m_128459_("cr_effect");
            this.cr_cost = nbt.m_128459_("cr_cost");
            this.cr_speed = nbt.m_128459_("cr_speed");
            this.cr_icon = nbt.m_128459_("cr_icon");
            this.cr_forward = nbt.m_128459_("cr_forward");
            this.cr_jump = nbt.m_128459_("cr_jump");
            this.cr_delay = nbt.m_128459_("cr_delay");
            this.cr_repetition = nbt.m_128459_("cr_repetition");
            this.cr_level_requirement = nbt.m_128459_("cr_level_requirement");
            this.cr_repetetion_delay = nbt.m_128459_("cr_repetetion_delay");
            this.cr_default_damage = nbt.m_128459_("cr_default_damage");
            this.cr_skill_position = nbt.m_128459_("cr_skill_position");
            this.left_arm = nbt.m_128471_("left_arm");
            this.right_arm = nbt.m_128471_("right_arm");
            this.left_leg = nbt.m_128471_("left_leg");
            this.right_leg = nbt.m_128471_("right_leg");
            this.right_hand_cd = nbt.m_128459_("right_hand_cd");
            this.left_hand_cd = nbt.m_128459_("left_hand_cd");
            this.left_leg_cd = nbt.m_128459_("left_leg_cd");
            this.right_leg_cd = nbt.m_128459_("right_leg_cd");
            this.picked_skill = nbt.m_128461_("picked_skill");
            this.block_cd = nbt.m_128459_("block_cd");
            this.guild_flag_id = nbt.m_128459_("guild_flag_id");
            this.guild_flag_background = nbt.m_128459_("guild_flag_background");
            this.guild_flag_symbol = nbt.m_128459_("guild_flag_symbol");
            this.guild_flag_front = nbt.m_128459_("guild_flag_front");
            this.guild_flag_background_color = nbt.m_128459_("guild_flag_background_color");
            this.guild_flag_symbol_color = nbt.m_128459_("guild_flag_symbol_color");
            this.guild_flag_front_color = nbt.m_128459_("guild_flag_front_color");
            this.guild_list_scroll = nbt.m_128459_("guild_list_scroll");
            this.guild_list_scroll_actual = nbt.m_128459_("guild_list_scroll_actual");
            this.stamina = nbt.m_128459_("stamina");
            this.red_gate_timer = nbt.m_128459_("red_gate_timer");
            this.learned_skill_menu = nbt.m_128459_("learned_skill_menu");
            this.Skill_ID_Stone = nbt.m_128459_("Skill_ID_Stone");
            this.ant_shadows = nbt.m_128459_("ant_shadows");
            this.shadow_army = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("shadow_army"));
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("solo_leveling", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "solo_leveling_mapvars";
        public ItemStack portal_id = ItemStack.f_41583_;
        public boolean gate_spawning = true;
        public String dungeon_theme = "\"\"";
        public ItemStack guilds = ItemStack.f_41583_;
        public boolean shadow_monarch = false;
        public double max_gates = 0.0;
        public double economy = 0.0;
        public double dropped_keys = 0.0;
        public boolean gate_balance = true;
        public boolean monarch_of_beginning_spawned = false;
        public boolean IceMonarchAttack = false;
        public double hour = 0.0;
        public boolean block_lock_on = false;
        public boolean kamish_tooth = false;
        public boolean death_punishment = false;
        public double wall_attemps = 0.0;
        public double update_tick_skip = 1.0;
        public boolean white_monarch = false;
        public double dungeon_level = 0.0;
        public double tusk_size = 1.0;
        public double wave_range = 0.0;
        public double effectX = 0.0;
        public double effectY = 0.0;
        public double effectZ = 0.0;
        public double slash_effect = 0.0;
        public double rulers_abillity_holders = 0.0;
        public boolean kamish_spawn = false;
        public double kamish_X = 0.0;
        public double kamish_Z = 0.0;
        public double kamish_timer = 0.0;
        public boolean kamish_gate = false;
        public double kamish_gate_angle = 0.0;
        public double blackhole_X = 0.0;
        public double blackhole_Y = 0.0;
        public double blackholeZ = 0.0;
        public double blackhole_timer = 0.0;
        public double gate_radius = 0.0;
        public ItemStack shop_list = ItemStack.f_41583_;
        public boolean set_shop = false;
        public boolean daily_quest24 = false;
        public double knife_X = 0.0;
        public double knife_Y = 0.0;
        public double knife_Z = 0.0;
        public String thrower = "\"\"";
        public double gate_X = 0.0;
        public double gate_Y = 0.0;
        public double gate_Z = 0.0;
        public double gate_count_room = 0.0;
        public Direction gate_direction = Direction.NORTH;
        public double gate_line = 0.0;
        public boolean can_place_room = false;
        public double random = 0.0;
        public double monster_rank = 0.0;
        public double monsters = 0.0;
        public double crystals_gate = 0.0;
        public double gate_boss_room = 0.0;
        public boolean spawned_boss = false;
        public double cleared_ID = 0.0;
        public double particle_array_length = 0.0;
        public ItemStack particle_array = ItemStack.f_41583_;
        public double tick_count = 0.0;
        public double tick_time = 0.0;
        public double guild_last_id = 0.0;
        public double difficulty = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            if (nbt == null) {
                nbt = this.m_7176_(new CompoundTag());
            }
            this.portal_id = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("portal_id"));
            this.gate_spawning = nbt.m_128471_("gate_spawning");
            this.dungeon_theme = nbt.m_128461_("dungeon_theme");
            this.guilds = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("guilds"));
            this.shadow_monarch = nbt.m_128471_("shadow_monarch");
            this.max_gates = nbt.m_128459_("max_gates");
            this.economy = nbt.m_128459_("economy");
            this.dropped_keys = nbt.m_128459_("dropped_keys");
            this.gate_balance = nbt.m_128471_("gate_balance");
            this.monarch_of_beginning_spawned = nbt.m_128471_("monarch_of_beginning_spawned");
            this.IceMonarchAttack = nbt.m_128471_("IceMonarchAttack");
            this.hour = nbt.m_128459_("hour");
            this.block_lock_on = nbt.m_128471_("block_lock_on");
            this.kamish_tooth = nbt.m_128471_("kamish_tooth");
            this.death_punishment = nbt.m_128471_("death_punishment");
            this.wall_attemps = nbt.m_128459_("wall_attemps");
            this.update_tick_skip = nbt.m_128459_("update_tick_skip");
            this.white_monarch = nbt.m_128471_("white_monarch");
            this.dungeon_level = nbt.m_128459_("dungeon_level");
            this.tusk_size = nbt.m_128459_("tusk_size");
            this.wave_range = nbt.m_128459_("wave_range");
            this.effectX = nbt.m_128459_("effectX");
            this.effectY = nbt.m_128459_("effectY");
            this.effectZ = nbt.m_128459_("effectZ");
            this.slash_effect = nbt.m_128459_("slash_effect");
            this.rulers_abillity_holders = nbt.m_128459_("rulers_abillity_holders");
            this.kamish_spawn = nbt.m_128471_("kamish_spawn");
            this.kamish_X = nbt.m_128459_("kamish_X");
            this.kamish_Z = nbt.m_128459_("kamish_Z");
            this.kamish_timer = nbt.m_128459_("kamish_timer");
            this.kamish_gate = nbt.m_128471_("kamish_gate");
            this.kamish_gate_angle = nbt.m_128459_("kamish_gate_angle");
            this.blackhole_X = nbt.m_128459_("blackhole_X");
            this.blackhole_Y = nbt.m_128459_("blackhole_Y");
            this.blackholeZ = nbt.m_128459_("blackholeZ");
            this.blackhole_timer = nbt.m_128459_("blackhole_timer");
            this.gate_radius = nbt.m_128459_("gate_radius");
            this.shop_list = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("shop_list"));
            this.set_shop = nbt.m_128471_("set_shop");
            this.daily_quest24 = nbt.m_128471_("daily_quest24");
            this.knife_X = nbt.m_128459_("knife_X");
            this.knife_Y = nbt.m_128459_("knife_Y");
            this.knife_Z = nbt.m_128459_("knife_Z");
            this.thrower = nbt.m_128461_("thrower");
            this.gate_X = nbt.m_128459_("gate_X");
            this.gate_Y = nbt.m_128459_("gate_Y");
            this.gate_Z = nbt.m_128459_("gate_Z");
            this.gate_count_room = nbt.m_128459_("gate_count_room");
            this.gate_direction = Direction.m_122376_((int)nbt.m_128451_("gate_direction"));
            this.gate_line = nbt.m_128459_("gate_line");
            this.can_place_room = nbt.m_128471_("can_place_room");
            this.random = nbt.m_128459_("random");
            this.monster_rank = nbt.m_128459_("monster_rank");
            this.monsters = nbt.m_128459_("monsters");
            this.crystals_gate = nbt.m_128459_("crystals_gate");
            this.gate_boss_room = nbt.m_128459_("gate_boss_room");
            this.spawned_boss = nbt.m_128471_("spawned_boss");
            this.cleared_ID = nbt.m_128459_("cleared_ID");
            this.particle_array_length = nbt.m_128459_("particle_array_length");
            this.particle_array = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("particle_array"));
            this.tick_count = nbt.m_128459_("tick_count");
            this.tick_time = nbt.m_128459_("tick_time");
            this.guild_last_id = nbt.m_128459_("guild_last_id");
            this.difficulty = nbt.m_128459_("difficulty");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128365_("portal_id", (Tag)this.portal_id.m_41739_(new CompoundTag()));
            nbt.m_128379_("gate_spawning", this.gate_spawning);
            nbt.m_128359_("dungeon_theme", this.dungeon_theme);
            nbt.m_128365_("guilds", (Tag)this.guilds.m_41739_(new CompoundTag()));
            nbt.m_128379_("shadow_monarch", this.shadow_monarch);
            nbt.m_128347_("max_gates", this.max_gates);
            nbt.m_128347_("economy", this.economy);
            nbt.m_128347_("dropped_keys", this.dropped_keys);
            nbt.m_128379_("gate_balance", this.gate_balance);
            nbt.m_128379_("monarch_of_beginning_spawned", this.monarch_of_beginning_spawned);
            nbt.m_128379_("IceMonarchAttack", this.IceMonarchAttack);
            nbt.m_128347_("hour", this.hour);
            nbt.m_128379_("block_lock_on", this.block_lock_on);
            nbt.m_128379_("kamish_tooth", this.kamish_tooth);
            nbt.m_128379_("death_punishment", this.death_punishment);
            nbt.m_128347_("wall_attemps", this.wall_attemps);
            nbt.m_128347_("update_tick_skip", this.update_tick_skip);
            nbt.m_128379_("white_monarch", this.white_monarch);
            nbt.m_128347_("dungeon_level", this.dungeon_level);
            nbt.m_128347_("tusk_size", this.tusk_size);
            nbt.m_128347_("wave_range", this.wave_range);
            nbt.m_128347_("effectX", this.effectX);
            nbt.m_128347_("effectY", this.effectY);
            nbt.m_128347_("effectZ", this.effectZ);
            nbt.m_128347_("slash_effect", this.slash_effect);
            nbt.m_128347_("rulers_abillity_holders", this.rulers_abillity_holders);
            nbt.m_128379_("kamish_spawn", this.kamish_spawn);
            nbt.m_128347_("kamish_X", this.kamish_X);
            nbt.m_128347_("kamish_Z", this.kamish_Z);
            nbt.m_128347_("kamish_timer", this.kamish_timer);
            nbt.m_128379_("kamish_gate", this.kamish_gate);
            nbt.m_128347_("kamish_gate_angle", this.kamish_gate_angle);
            nbt.m_128347_("blackhole_X", this.blackhole_X);
            nbt.m_128347_("blackhole_Y", this.blackhole_Y);
            nbt.m_128347_("blackholeZ", this.blackholeZ);
            nbt.m_128347_("blackhole_timer", this.blackhole_timer);
            nbt.m_128347_("gate_radius", this.gate_radius);
            nbt.m_128365_("shop_list", (Tag)this.shop_list.m_41739_(new CompoundTag()));
            nbt.m_128379_("set_shop", this.set_shop);
            nbt.m_128379_("daily_quest24", this.daily_quest24);
            nbt.m_128347_("knife_X", this.knife_X);
            nbt.m_128347_("knife_Y", this.knife_Y);
            nbt.m_128347_("knife_Z", this.knife_Z);
            nbt.m_128359_("thrower", this.thrower);
            nbt.m_128347_("gate_X", this.gate_X);
            nbt.m_128347_("gate_Y", this.gate_Y);
            nbt.m_128347_("gate_Z", this.gate_Z);
            nbt.m_128347_("gate_count_room", this.gate_count_room);
            nbt.m_128405_("gate_direction", this.gate_direction.m_122411_());
            nbt.m_128347_("gate_line", this.gate_line);
            nbt.m_128379_("can_place_room", this.can_place_room);
            nbt.m_128347_("random", this.random);
            nbt.m_128347_("monster_rank", this.monster_rank);
            nbt.m_128347_("monsters", this.monsters);
            nbt.m_128347_("crystals_gate", this.crystals_gate);
            nbt.m_128347_("gate_boss_room", this.gate_boss_room);
            nbt.m_128379_("spawned_boss", this.spawned_boss);
            nbt.m_128347_("cleared_ID", this.cleared_ID);
            nbt.m_128347_("particle_array_length", this.particle_array_length);
            nbt.m_128365_("particle_array", (Tag)this.particle_array.m_41739_(new CompoundTag()));
            nbt.m_128347_("tick_count", this.tick_count);
            nbt.m_128347_("tick_time", this.tick_time);
            nbt.m_128347_("guild_last_id", this.guild_last_id);
            nbt.m_128347_("difficulty", this.difficulty);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                SoloLevelingMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "solo_leveling_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                SoloLevelingMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.level = original.level;
            clone.xp = original.xp;
            clone.player_class = original.player_class;
            clone.Strength = original.Strength;
            clone.Agility = original.Agility;
            clone.Vitality = original.Vitality;
            clone.Intelligence = original.Intelligence;
            clone.attack_cd = original.attack_cd;
            clone.in_combat = original.in_combat;
            clone.awakened = original.awakened;
            clone.mana = original.mana;
            clone.hp = original.hp;
            clone.points = original.points;
            clone.skill_slots = original.skill_slots;
            clone.skill = original.skill;
            clone.title = original.title;
            clone.speed_limit = original.speed_limit;
            clone.ShowDamage = original.ShowDamage;
            clone.skill_page = original.skill_page;
            clone.total_damage = original.total_damage;
            clone.player_gate_id = original.player_gate_id;
            clone.exitX = original.exitX;
            clone.exitY = original.exitY;
            clone.exitZ = original.exitZ;
            clone.soliders_in_shadow = original.soliders_in_shadow;
            clone.igris_arise = original.igris_arise;
            clone.kamish_arise = original.kamish_arise;
            clone.cleared_dungeon = original.cleared_dungeon;
            clone.shaking_on = original.shaking_on;
            clone.view_angle = original.view_angle;
            clone.hide_overlay = original.hide_overlay;
            clone.target_lock = original.target_lock;
            clone.lock_on = original.lock_on;
            clone.bonus_resistance_timer = original.bonus_resistance_timer;
            clone.bonus_resistance = original.bonus_resistance;
            clone.enter_dimension = original.enter_dimension;
            clone.exit_dimension = original.exit_dimension;
            clone.in_dungeon = original.in_dungeon;
            clone.Money = original.Money;
            clone.gui_scroll = original.gui_scroll;
            clone.gui_item_price = original.gui_item_price;
            clone.power_buff = original.power_buff;
            clone.power_buff_timer = original.power_buff_timer;
            clone.speed_buff = original.speed_buff;
            clone.health_buff = original.health_buff;
            clone.health_buff_tiumer = original.health_buff_tiumer;
            clone.guild_name = original.guild_name;
            clone.quest_id = original.quest_id;
            clone.QuestName = original.QuestName;
            clone.QuestDescription = original.QuestDescription;
            clone.QuestGoal = original.QuestGoal;
            clone.quest_current_finished = original.quest_current_finished;
            clone.quest_des_part1 = original.quest_des_part1;
            clone.quest_des_part2 = original.quest_des_part2;
            clone.quest_des_part3 = original.quest_des_part3;
            clone.quest_start = original.quest_start;
            clone.bery_arise = original.bery_arise;
            clone.guild_owner = original.guild_owner;
            clone.invited_to_guild = original.invited_to_guild;
            clone.army_follow = original.army_follow;
            clone.secret_dungeon_tries = original.secret_dungeon_tries;
            clone.day = original.day;
            clone.DailyQuest = original.DailyQuest;
            clone.daily_quest_goal = original.daily_quest_goal;
            clone.daily_quest_goal_2 = original.daily_quest_goal_2;
            clone.sneaking = original.sneaking;
            clone.enable_daily_quests = original.enable_daily_quests;
            clone.special_reward = original.special_reward;
            clone.punishment_timer = original.punishment_timer;
            clone.pX = original.pX;
            clone.pY = original.pY;
            clone.pZ = original.pZ;
            clone.p_old_dimension = original.p_old_dimension;
            clone.ice_bears_arise = original.ice_bears_arise;
            clone.demon_castle_floor = original.demon_castle_floor;
            clone.do_not_round = original.do_not_round;
            clone.guild_name_show = original.guild_name_show;
            clone.guild_scroll = original.guild_scroll;
            clone.update_tick_count = original.update_tick_count;
            clone.cleared_gates = original.cleared_gates;
            clone.hide_class = original.hide_class;
            clone.kaisel_arise = original.kaisel_arise;
            clone.learned_skills = original.learned_skills;
            clone.learned_skills_save = original.learned_skills_save;
            clone.orcs_shadows = original.orcs_shadows;
            clone.tusk_arise = original.tusk_arise;
            clone.wolf_slayer_progress = original.wolf_slayer_progress;
            clone.goblin_slayer_progress = original.goblin_slayer_progress;
            clone.golem_slayer_progress = original.golem_slayer_progress;
            clone.demon_slayer_progress = original.demon_slayer_progress;
            clone.sense = original.sense;
            clone.sense_gates = original.sense_gates;
            clone.sense_monsters = original.sense_monsters;
            clone.display_health = original.display_health;
            clone.display_name = original.display_name;
            clone.transformation = original.transformation;
            clone.Dialog = original.Dialog;
            clone.DialogID = original.DialogID;
            clone.Answer1 = original.Answer1;
            clone.Answer2 = original.Answer2;
            clone.Answer3 = original.Answer3;
            clone.ans1_continue = original.ans1_continue;
            clone.ans2_continue = original.ans2_continue;
            clone.ans3_continue = original.ans3_continue;
            clone.special_dialog_event = original.special_dialog_event;
            clone.special1 = original.special1;
            clone.special2 = original.special2;
            clone.special3 = original.special3;
            clone.Talker = original.Talker;
            clone.knight_form = original.knight_form;
            clone.whole_cd = original.whole_cd;
            clone.menuX = original.menuX;
            clone.menuY = original.menuY;
            clone.Skill_ID = original.Skill_ID;
            clone.skill_menu = original.skill_menu;
            clone.level_up_alarm = original.level_up_alarm;
            clone.army_cd = original.army_cd;
            clone.lock_yaw = original.lock_yaw;
            clone.lock_pitch = original.lock_pitch;
            clone.animation = original.animation;
            clone.loaded = original.loaded;
            clone.filter_weapons = original.filter_weapons;
            clone.filter_armor = original.filter_armor;
            clone.filter_word = original.filter_word;
            clone.filtered_items = original.filtered_items;
            clone.damage_show_X = original.damage_show_X;
            clone.damage_show_Y = original.damage_show_Y;
            clone.damage_show_Z = original.damage_show_Z;
            clone.join_world = original.join_world;
            clone.reward_1 = original.reward_1;
            clone.reward_2 = original.reward_2;
            clone.reward_3 = original.reward_3;
            clone.got_Reward = original.got_Reward;
            clone.run_X = original.run_X;
            clone.run_Y = original.run_Y;
            clone.run_Z = original.run_Z;
            clone.damage_show_timer = original.damage_show_timer;
            clone.damage_show_value = original.damage_show_value;
            clone.damage_vx_show = original.damage_vx_show;
            clone.damage_vz_show = original.damage_vz_show;
            clone.cr_particles = original.cr_particles;
            clone.cr_animation = original.cr_animation;
            clone.cr_trajectory = original.cr_trajectory;
            clone.cr_range = original.cr_range;
            clone.cr_strength_scale = original.cr_strength_scale;
            clone.cr_int_scale = original.cr_int_scale;
            clone.cr_agillity_scale = original.cr_agillity_scale;
            clone.cr_vitallity_scale = original.cr_vitallity_scale;
            clone.cr_sense_scale = original.cr_sense_scale;
            clone.cr_cd = original.cr_cd;
            clone.cr_effect = original.cr_effect;
            clone.cr_cost = original.cr_cost;
            clone.cr_speed = original.cr_speed;
            clone.cr_icon = original.cr_icon;
            clone.cr_forward = original.cr_forward;
            clone.cr_jump = original.cr_jump;
            clone.cr_delay = original.cr_delay;
            clone.cr_repetition = original.cr_repetition;
            clone.cr_level_requirement = original.cr_level_requirement;
            clone.cr_repetetion_delay = original.cr_repetetion_delay;
            clone.cr_default_damage = original.cr_default_damage;
            clone.cr_skill_position = original.cr_skill_position;
            clone.left_arm = original.left_arm;
            clone.right_arm = original.right_arm;
            clone.left_leg = original.left_leg;
            clone.right_leg = original.right_leg;
            clone.right_hand_cd = original.right_hand_cd;
            clone.left_hand_cd = original.left_hand_cd;
            clone.left_leg_cd = original.left_leg_cd;
            clone.right_leg_cd = original.right_leg_cd;
            clone.picked_skill = original.picked_skill;
            clone.block_cd = original.block_cd;
            clone.guild_flag_id = original.guild_flag_id;
            clone.guild_flag_background = original.guild_flag_background;
            clone.guild_flag_symbol = original.guild_flag_symbol;
            clone.guild_flag_front = original.guild_flag_front;
            clone.guild_flag_background_color = original.guild_flag_background_color;
            clone.guild_flag_symbol_color = original.guild_flag_symbol_color;
            clone.guild_flag_front_color = original.guild_flag_front_color;
            clone.guild_list_scroll = original.guild_list_scroll;
            clone.guild_list_scroll_actual = original.guild_list_scroll_actual;
            clone.stamina = original.stamina;
            clone.red_gate_timer = original.red_gate_timer;
            clone.learned_skill_menu = original.learned_skill_menu;
            clone.Skill_ID_Stone = original.Skill_ID_Stone;
            clone.ant_shadows = original.ant_shadows;
            clone.shadow_army = original.shadow_army;
            if (!event.isWasDeath()) {
                clone.speed_buff_timer = original.speed_buff_timer;
            }
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    SoloLevelingMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    SoloLevelingMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                SoloLevelingMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

