/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sololeveling.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.mcreator.sololeveling.SoloLevelingMod;
import net.mcreator.sololeveling.procedures.ClearSkillSlotsProcedure;
import net.mcreator.sololeveling.procedures.OpenLearnedSkillsProcedure;
import net.mcreator.sololeveling.procedures.ScrollSkillMenuNextProcedure;
import net.mcreator.sololeveling.procedures.ScrollSkillMenuPrevProcedure;
import net.mcreator.sololeveling.procedures.SetEighthSlotProcedure;
import net.mcreator.sololeveling.procedures.SetFifthSlotProcedure;
import net.mcreator.sololeveling.procedures.SetFirstSlotProcedure;
import net.mcreator.sololeveling.procedures.SetForthSlotProcedure;
import net.mcreator.sololeveling.procedures.SetPickSkillProcedure;
import net.mcreator.sololeveling.procedures.SetSecondSlotProcedure;
import net.mcreator.sololeveling.procedures.SetSeventhSlotProcedure;
import net.mcreator.sololeveling.procedures.SetSixthSlotProcedure;
import net.mcreator.sololeveling.procedures.SetThirdSlotProcedure;
import net.mcreator.sololeveling.world.inventory.SkillsMenuMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SkillsMenuButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;
    private HashMap<String, String> textstate;

    public SkillsMenuButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.textstate = SkillsMenuButtonMessage.readTextState(buffer);
    }

    public SkillsMenuButtonMessage(int buttonID, int x, int y, int z, HashMap<String, String> textstate) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
        this.textstate = textstate;
    }

    public static void buffer(SkillsMenuButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        SkillsMenuButtonMessage.writeTextState(message.textstate, buffer);
    }

    public static void handler(SkillsMenuButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            HashMap<String, String> textstate = message.textstate;
            SkillsMenuButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z, textstate);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z, HashMap<String, String> textstate) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = SkillsMenuMenu.guistate;
        for (Map.Entry<String, String> entry : textstate.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            guistate.put(key, value);
        }
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            SetFirstSlotProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            ClearSkillSlotsProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            OpenLearnedSkillsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            ScrollSkillMenuPrevProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            ScrollSkillMenuNextProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            SetPickSkillProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 6) {
            SetSecondSlotProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            SetThirdSlotProcedure.execute((Entity)entity);
        }
        if (buttonID == 8) {
            SetForthSlotProcedure.execute((Entity)entity);
        }
        if (buttonID == 9) {
            SetFifthSlotProcedure.execute((Entity)entity);
        }
        if (buttonID == 10) {
            SetSixthSlotProcedure.execute((Entity)entity);
        }
        if (buttonID == 11) {
            SetSeventhSlotProcedure.execute((Entity)entity);
        }
        if (buttonID == 12) {
            SetEighthSlotProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        SoloLevelingMod.addNetworkMessage(SkillsMenuButtonMessage.class, SkillsMenuButtonMessage::buffer, SkillsMenuButtonMessage::new, SkillsMenuButtonMessage::handler);
    }

    public static void writeTextState(HashMap<String, String> map, FriendlyByteBuf buffer) {
        buffer.writeInt(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            buffer.m_130083_((Component)Component.m_237113_((String)entry.getKey()));
            buffer.m_130083_((Component)Component.m_237113_((String)entry.getValue()));
        }
    }

    public static HashMap<String, String> readTextState(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < size; ++i) {
            String key = buffer.m_130238_().getString();
            String value = buffer.m_130238_().getString();
            map.put(key, value);
        }
        return map;
    }
}

