/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sololeveling.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.mcreator.sololeveling.SoloLevelingMod;
import net.mcreator.sololeveling.procedures.CreateGuildPhoneButtonProcedure;
import net.mcreator.sololeveling.procedures.GuildNextFlagColorProcedure;
import net.mcreator.sololeveling.procedures.GuildNextFlagFrontColorProcedure;
import net.mcreator.sololeveling.procedures.GuildNextFlagFrontProcedure;
import net.mcreator.sololeveling.procedures.GuildNextFlagProcedure;
import net.mcreator.sololeveling.procedures.GuildNextFlagSymbolColorProcedure;
import net.mcreator.sololeveling.procedures.GuildNextFlagSymbolProcedure;
import net.mcreator.sololeveling.procedures.GuildPrevFlagColorProcedure;
import net.mcreator.sololeveling.procedures.GuildPrevFlagFrontColorProcedure;
import net.mcreator.sololeveling.procedures.GuildPrevFlagFrontProcedure;
import net.mcreator.sololeveling.procedures.GuildPrevFlagProcedure;
import net.mcreator.sololeveling.procedures.GuildPrevFlagSymbolColorProcedure;
import net.mcreator.sololeveling.procedures.GuildPrevFlagSymbolProcedure;
import net.mcreator.sololeveling.procedures.OpenPhoneGuiProcedure;
import net.mcreator.sololeveling.world.inventory.GuildCreateGuiMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GuildCreateGuiButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;
    private HashMap<String, String> textstate;

    public GuildCreateGuiButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.textstate = GuildCreateGuiButtonMessage.readTextState(buffer);
    }

    public GuildCreateGuiButtonMessage(int buttonID, int x, int y, int z, HashMap<String, String> textstate) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
        this.textstate = textstate;
    }

    public static void buffer(GuildCreateGuiButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        GuildCreateGuiButtonMessage.writeTextState(message.textstate, buffer);
    }

    public static void handler(GuildCreateGuiButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            HashMap<String, String> textstate = message.textstate;
            GuildCreateGuiButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z, textstate);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z, HashMap<String, String> textstate) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = GuildCreateGuiMenu.guistate;
        for (Map.Entry<String, String> entry : textstate.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            guistate.put(key, value);
        }
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            CreateGuildPhoneButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, guistate);
        }
        if (buttonID == 1) {
            OpenPhoneGuiProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            GuildPrevFlagProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            GuildNextFlagProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            GuildPrevFlagSymbolProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            GuildNextFlagSymbolProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            GuildPrevFlagFrontProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            GuildNextFlagFrontProcedure.execute((Entity)entity);
        }
        if (buttonID == 8) {
            GuildPrevFlagColorProcedure.execute((Entity)entity);
        }
        if (buttonID == 9) {
            GuildNextFlagColorProcedure.execute((Entity)entity);
        }
        if (buttonID == 10) {
            GuildPrevFlagSymbolColorProcedure.execute((Entity)entity);
        }
        if (buttonID == 11) {
            GuildNextFlagSymbolColorProcedure.execute((Entity)entity);
        }
        if (buttonID == 12) {
            GuildPrevFlagFrontColorProcedure.execute((Entity)entity);
        }
        if (buttonID == 13) {
            GuildNextFlagFrontColorProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        SoloLevelingMod.addNetworkMessage(GuildCreateGuiButtonMessage.class, GuildCreateGuiButtonMessage::buffer, GuildCreateGuiButtonMessage::new, GuildCreateGuiButtonMessage::handler);
    }

    public static void writeTextState(HashMap<String, String> map, FriendlyByteBuf buffer) {
        buffer.writeInt(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            buffer.m_130083_((Component)Component.m_237113_((String)entry.getKey()));
            buffer.m_130083_((Component)Component.m_237113_((String)entry.getValue()));
        }
    }

    public static HashMap<String, String> readTextState(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < size; ++i) {
            String key = buffer.m_130238_().getString();
            String value = buffer.m_130238_().getString();
            map.put(key, value);
        }
        return map;
    }
}

