/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.client.renderer.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.goblintraders.entity.AbstractGoblinEntity;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class GoblinTraderModel
extends HierarchicalModel<AbstractGoblinEntity>
implements ArmedModel,
HeadedModel {
    public final ModelPart root;
    public final ModelPart head;
    public final ModelPart hood;
    public final ModelPart body;
    public final ModelPart rightArm;
    public final ModelPart leftArm;
    public final ModelPart rightLeg;
    public final ModelPart leftLeg;
    public final ModelPart nose;
    public final ModelPart rightEar;
    public final ModelPart leftEar;
    public final ModelPart bag;
    public float headTilt;
    public float armAngle;

    public GoblinTraderModel(ModelPart part) {
        this.root = part;
        this.head = part.m_171324_("head");
        this.hood = part.m_171324_("hood");
        this.body = part.m_171324_("body");
        this.rightArm = part.m_171324_("right_arm");
        this.leftArm = part.m_171324_("left_arm");
        this.rightLeg = part.m_171324_("right_leg");
        this.leftLeg = part.m_171324_("left_leg");
        this.nose = this.head.m_171324_("nose");
        this.rightEar = this.head.m_171324_("right_ear");
        this.leftEar = this.head.m_171324_("left_ear");
        this.bag = this.body.m_171324_("bag");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171481_(-4.0f, -6.0f, -3.0f, 8.0f, 6.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)16.0f, (float)0.0f));
        head.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171481_(0.0f, -2.0f, 0.0f, 0.0f, 4.0f, 4.0f), PartPose.m_171423_((float)-4.0f, (float)-3.0f, (float)1.0f, (float)0.0f, (float)-0.785f, (float)0.0f));
        head.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(8, 8).m_171481_(0.0f, -2.0f, 0.0f, 0.0f, 4.0f, 4.0f), PartPose.m_171423_((float)4.0f, (float)-3.0f, (float)1.0f, (float)0.0f, (float)0.785f, (float)0.0f));
        head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171481_(-1.0f, 0.0f, -2.0f, 2.0f, 4.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)-3.0f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(12, 12).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)16.0f, (float)0.0f));
        body.m_171599_("bag", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171481_(-2.5f, -2.0f, 2.0f, 5.0f, 7.0f, 3.0f), PartPose.f_171404_);
        root.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(30, 0).m_171481_(-1.0f, -1.0f, -1.0f, 2.0f, 5.0f, 2.0f), PartPose.m_171419_((float)-3.0f, (float)17.0f, (float)0.0f));
        root.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(38, 0).m_171481_(-1.0f, -1.0f, -1.0f, 2.0f, 5.0f, 2.0f), PartPose.m_171419_((float)3.0f, (float)17.0f, (float)0.0f));
        root.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(26, 9).m_171481_(-1.0f, 0.0f, -1.5f, 2.0f, 4.0f, 3.0f), PartPose.m_171419_((float)-1.0f, (float)20.0f, (float)0.0f));
        root.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(36, 9).m_171481_(-1.0f, 0.0f, -1.5f, 2.0f, 4.0f, 3.0f), PartPose.m_171419_((float)1.0f, (float)20.0f, (float)0.0f));
        root.m_171599_("hood", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-4.0f, -6.0f, -3.0f, 8.0f, 8.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)16.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)46, (int)46);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void setupAnim(AbstractGoblinEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        float rotateFactor = (float)entity.m_20184_().m_82556_();
        rotateFactor /= 0.2f;
        if ((rotateFactor = rotateFactor * rotateFactor * rotateFactor) < 1.0f) {
            rotateFactor = 1.0f;
        }
        if (entity.m_6844_(EquipmentSlot.MAINHAND).m_41619_()) {
            this.rightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f / rotateFactor;
            this.leftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f / rotateFactor;
        } else {
            this.rightArm.f_104203_ = 0.0f;
            this.leftArm.f_104203_ = 0.0f;
        }
        this.rightArm.f_104203_ -= (float)Math.toRadians(this.armAngle);
        this.leftArm.f_104203_ -= (float)Math.toRadians(this.armAngle);
        this.rightArm.f_104204_ = 0.0f;
        this.rightArm.f_104205_ = 0.0f;
        this.leftArm.f_104204_ = 0.0f;
        this.leftArm.f_104205_ = 0.0f;
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount / rotateFactor;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount / rotateFactor;
        Quaternionf quaternionYaw = new Quaternionf().rotationY(org.joml.Math.toRadians((float)headYaw));
        Quaternionf quaternionPitch = new Quaternionf().rotationX(org.joml.Math.toRadians((float)headPitch));
        Quaternionf quaternionRoll = new Quaternionf().rotationZ(org.joml.Math.toRadians((float)this.headTilt));
        Quaternionf finalRotation = new Quaternionf((Quaternionfc)quaternionPitch).mul((Quaternionfc)quaternionYaw).mul((Quaternionfc)quaternionRoll);
        Vector3f euler = new Vector3f();
        finalRotation.getEulerAnglesZXY(euler);
        this.head.f_104203_ = euler.x;
        this.head.f_104204_ = euler.y;
        this.head.f_104205_ = euler.z;
        this.hood.m_104315_(this.head);
        if (this.f_102608_ > 0.0f) {
            ModelPart arm = this.rightArm;
            float progress = this.f_102608_;
            this.body.f_104204_ = Mth.m_14031_((float)(Mth.m_14116_((float)progress) * ((float)Math.PI * 2))) * 0.2f;
            this.rightArm.f_104204_ += this.body.f_104204_;
            this.leftArm.f_104204_ += this.body.f_104204_;
            this.leftArm.f_104203_ += this.body.f_104204_;
            progress = 1.0f - this.f_102608_;
            progress *= progress;
            progress *= progress;
            progress = 1.0f - progress;
            float f2 = Mth.m_14031_((float)(progress * (float)Math.PI));
            float f3 = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -(this.head.f_104203_ - 0.7f) * 0.75f;
            arm.f_104203_ = (float)((double)arm.f_104203_ - ((double)f2 * 1.2 + (double)f3));
            arm.f_104204_ += this.body.f_104204_ * 2.0f;
            arm.f_104205_ += Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -0.4f;
        }
        if (entity.isSitting() || entity.m_6117_()) {
            this.rightLeg.f_104203_ = (float)Math.toRadians(-90.0);
            this.rightLeg.f_104204_ = (float)Math.toRadians(30.0);
            this.leftLeg.f_104203_ = (float)Math.toRadians(-90.0);
            this.leftLeg.f_104204_ = (float)Math.toRadians(-30.0);
            if (entity.m_6117_()) {
                double rotateX = Math.toRadians(-90.0 + 5.0 * Math.sin(ageInTicks));
                this.rightArm.f_104203_ = (float)rotateX;
                this.leftArm.f_104203_ = (float)rotateX;
            }
        } else {
            this.rightLeg.f_104204_ = (float)Math.toRadians(0.0);
            this.leftLeg.f_104204_ = (float)Math.toRadians(0.0);
        }
    }

    public void m_6002_(HumanoidArm arm, PoseStack poseStack) {
        switch (arm) {
            case LEFT: {
                this.leftArm.m_104299_(poseStack);
                poseStack.m_85837_(-0.235, -0.15, 0.25);
                poseStack.m_85841_(0.75f, 0.75f, 0.75f);
                break;
            }
            case RIGHT: {
                this.rightArm.m_104299_(poseStack);
                poseStack.m_85837_(0.235, -0.15, 0.25);
                poseStack.m_85841_(0.75f, 0.75f, 0.75f);
            }
        }
    }

    public ModelPart m_5585_() {
        return this.head;
    }
}

