/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.facet.taxonomy;

import guideme.internal.shaded.lucene.facet.FacetsCollector;
import guideme.internal.shaded.lucene.facet.FacetsConfig;
import guideme.internal.shaded.lucene.facet.taxonomy.AssociationAggregationFunction;
import guideme.internal.shaded.lucene.facet.taxonomy.IntTaxonomyFacets;
import guideme.internal.shaded.lucene.facet.taxonomy.TaxonomyReader;
import guideme.internal.shaded.lucene.index.BinaryDocValues;
import guideme.internal.shaded.lucene.index.DocValues;
import guideme.internal.shaded.lucene.search.ConjunctionUtils;
import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.util.BitUtil;
import guideme.internal.shaded.lucene.util.BytesRef;
import java.io.IOException;
import java.util.List;

public class TaxonomyFacetIntAssociations
extends IntTaxonomyFacets {
    public TaxonomyFacetIntAssociations(TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc, AssociationAggregationFunction aggregationFunction) throws IOException {
        this("$facets", taxoReader, config, fc, aggregationFunction);
    }

    public TaxonomyFacetIntAssociations(String indexFieldName, TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc, AssociationAggregationFunction aggregationFunction) throws IOException {
        super(indexFieldName, taxoReader, config, aggregationFunction, fc);
        this.aggregateValues(aggregationFunction, fc.getMatchingDocs());
    }

    private void aggregateValues(AssociationAggregationFunction aggregationFunction, List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            if (hits.totalHits == 0) continue;
            this.initializeValueCounters();
            BinaryDocValues dv = DocValues.getBinary(hits.context.reader(), this.indexFieldName);
            DocIdSetIterator it = ConjunctionUtils.intersectIterators(List.of(hits.bits.iterator(), dv));
            int doc = it.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                BytesRef bytesRef = dv.binaryValue();
                byte[] bytes = bytesRef.bytes;
                int end = bytesRef.offset + bytesRef.length;
                for (int offset = bytesRef.offset; offset < end; offset += 4) {
                    int ord = BitUtil.VH_BE_INT.get(bytes, offset);
                    int value = BitUtil.VH_BE_INT.get(bytes, offset += 4);
                    int currentValue = this.getValue(ord);
                    int newValue = aggregationFunction.aggregate(currentValue, value);
                    this.setValue(ord, newValue);
                    this.setCount(ord, this.getCount(ord) + 1);
                }
                doc = it.nextDoc();
            }
        }
    }
}

