/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.codecs;

import guideme.internal.shaded.lucene.codecs.PointsReader;
import guideme.internal.shaded.lucene.index.FieldInfo;
import guideme.internal.shaded.lucene.index.MergeState;
import guideme.internal.shaded.lucene.index.PointValues;
import java.io.Closeable;
import java.io.IOException;

public abstract class PointsWriter
implements Closeable {
    protected PointsWriter() {
    }

    public abstract void writeField(FieldInfo var1, PointsReader var2) throws IOException;

    protected void mergeOneField(final MergeState mergeState, final FieldInfo fieldInfo) throws IOException {
        long maxPointCount = 0L;
        for (int i = 0; i < mergeState.pointsReaders.length; ++i) {
            PointValues values;
            FieldInfo readerFieldInfo;
            PointsReader pointsReader = mergeState.pointsReaders[i];
            if (pointsReader == null || (readerFieldInfo = mergeState.fieldInfos[i].fieldInfo(fieldInfo.name)) == null || readerFieldInfo.getPointDimensionCount() <= 0 || (values = pointsReader.getValues(fieldInfo.name)) == null) continue;
            maxPointCount += values.size();
        }
        final long finalMaxPointCount = maxPointCount;
        this.writeField(fieldInfo, new PointsReader(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public PointValues getValues(final String fieldName) {
                if (!fieldName.equals(fieldInfo.name)) {
                    throw new IllegalArgumentException("field name must match the field being merged");
                }
                return new PointValues(){

                    @Override
                    public PointValues.PointTree getPointTree() {
                        return new PointValues.PointTree(){

                            @Override
                            public PointValues.PointTree clone() {
                                throw new UnsupportedOperationException();
                            }

                            @Override
                            public boolean moveToChild() {
                                return false;
                            }

                            @Override
                            public boolean moveToSibling() {
                                return false;
                            }

                            @Override
                            public boolean moveToParent() {
                                return false;
                            }

                            @Override
                            public byte[] getMinPackedValue() {
                                throw new UnsupportedOperationException();
                            }

                            @Override
                            public byte[] getMaxPackedValue() {
                                throw new UnsupportedOperationException();
                            }

                            @Override
                            public long size() {
                                return finalMaxPointCount;
                            }

                            @Override
                            public void visitDocIDs(PointValues.IntersectVisitor visitor) {
                                throw new UnsupportedOperationException();
                            }

                            @Override
                            public void visitDocValues(final PointValues.IntersectVisitor mergedVisitor) throws IOException {
                                for (int i = 0; i < mergeState.pointsReaders.length; ++i) {
                                    PointValues values;
                                    FieldInfo readerFieldInfo;
                                    PointsReader pointsReader = mergeState.pointsReaders[i];
                                    if (pointsReader == null || (readerFieldInfo = mergeState.fieldInfos[i].fieldInfo(fieldName)) == null || readerFieldInfo.getPointDimensionCount() == 0 || (values = pointsReader.getValues(fieldName)) == null) continue;
                                    final MergeState.DocMap docMap = mergeState.docMaps[i];
                                    values.getPointTree().visitDocValues(new PointValues.IntersectVisitor(){

                                        @Override
                                        public void visit(int docID) {
                                            throw new IllegalStateException();
                                        }

                                        @Override
                                        public void visit(int docID, byte[] packedValue) throws IOException {
                                            int newDocID = docMap.get(docID);
                                            if (newDocID != -1) {
                                                mergedVisitor.visit(newDocID, packedValue);
                                            }
                                        }

                                        @Override
                                        public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                                            return PointValues.Relation.CELL_CROSSES_QUERY;
                                        }
                                    });
                                }
                            }
                        };
                    }

                    @Override
                    public byte[] getMinPackedValue() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public byte[] getMaxPackedValue() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public int getNumDimensions() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public int getNumIndexDimensions() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public int getBytesPerDimension() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public long size() {
                        return finalMaxPointCount;
                    }

                    @Override
                    public int getDocCount() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public void checkIntegrity() throws IOException {
                throw new UnsupportedOperationException();
            }
        });
    }

    public void merge(MergeState mergeState) throws IOException {
        for (PointsReader reader : mergeState.pointsReaders) {
            if (reader == null) continue;
            reader.checkIntegrity();
        }
        for (FieldInfo fieldInfo : mergeState.mergeFieldInfos) {
            if (fieldInfo.getPointDimensionCount() == 0) continue;
            this.mergeOneField(mergeState, fieldInfo);
        }
        this.finish();
    }

    public abstract void finish() throws IOException;
}

