/*
 * Decompiled with CFR 0.152.
 */
package website.eccentric.tome.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import website.eccentric.tome.EccentricTome;
import website.eccentric.tome.Tome;

public class ConvertMessage {
    public final int index;

    public ConvertMessage(int index) {
        this.index = index;
    }

    public static ConvertMessage decode(FriendlyByteBuf buffer) {
        return new ConvertMessage(buffer.m_130242_());
    }

    public static void encode(ConvertMessage message, FriendlyByteBuf buffer) {
        buffer.m_130130_(message.index);
    }

    public static void handle(ConvertMessage message, Supplier<NetworkEvent.Context> context) {
        EccentricTome.LOGGER.debug("Received convert message for index {}.", (Object)message.index);
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            InteractionHand hand = Tome.inHand((Player)player);
            if (hand != null) {
                ItemStack tome = player.m_21120_(hand);
                player.m_21008_(hand, Tome.convert(tome, message.index));
            }
            ((NetworkEvent.Context)context.get()).setPacketHandled(true);
        });
    }
}

