/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.block;

import com.google.common.collect.Lists;
import com.magistuarmory.block.ModBlockEntityTypes;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class PaviseBlockEntity
extends BlockEntity {
    String shieldId = "wood_pavese";
    @Nullable
    private DyeColor baseColor;
    @Nullable
    private ListTag itemPatterns;
    private boolean enchanted = false;
    private CompoundTag stackCompound;
    @Nullable
    private List<Pair<Holder<BannerPattern>, DyeColor>> patterns;

    public PaviseBlockEntity(BlockPos blockpos, BlockState blockstate) {
        super((BlockEntityType)ModBlockEntityTypes.PAVISE.get(), blockpos, blockstate);
    }

    @Nullable
    public static ListTag getItemPatterns(ItemStack stack) {
        ListTag listtag = null;
        CompoundTag compound = BlockItem.m_186336_((ItemStack)stack);
        if (compound != null && compound.m_128425_("Patterns", 9)) {
            listtag = compound.m_128437_("Patterns", 10).m_6426_();
        }
        return listtag;
    }

    public void fromItem(ItemStack stack) {
        this.itemPatterns = PaviseBlockEntity.getItemPatterns(stack);
        this.baseColor = ShieldItem.m_43102_((ItemStack)stack);
        this.stackCompound = stack.m_41783_();
        this.enchanted = stack.m_41793_();
        this.patterns = null;
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128359_("ShieldId", this.shieldId);
        if (this.baseColor != null) {
            compound.m_128405_("Base", this.baseColor.m_41060_());
        }
        compound.m_128379_("Enchanted", this.enchanted);
        if (this.stackCompound != null) {
            compound.m_128365_("ItemStack", (Tag)this.stackCompound);
        }
        if (this.itemPatterns != null) {
            compound.m_128365_("Patterns", (Tag)this.itemPatterns);
        }
    }

    public boolean hasFoil() {
        return this.enchanted;
    }

    public boolean isPainted() {
        return this.getBaseColor() != null;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.shieldId = compound.m_128461_("ShieldId");
        if (compound.m_128441_("Base")) {
            this.baseColor = DyeColor.m_41053_((int)compound.m_128451_("Base"));
        }
        this.stackCompound = compound.m_128469_("ItemStack");
        this.enchanted = compound.m_128471_("Enchanted");
        this.itemPatterns = compound.m_128437_("Patterns", 10);
        this.patterns = null;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public static int getPatternCount(ItemStack stack) {
        CompoundTag compound = BlockItem.m_186336_((ItemStack)stack);
        return compound != null && compound.m_128441_("Patterns") ? compound.m_128437_("Patterns", 10).size() : 0;
    }

    public List<Pair<Holder<BannerPattern>, DyeColor>> getPatterns() {
        if (this.patterns == null) {
            this.patterns = PaviseBlockEntity.createPatterns(this.baseColor, this.itemPatterns);
        }
        return this.patterns;
    }

    public static List<Pair<Holder<BannerPattern>, DyeColor>> createPatterns(DyeColor color, @Nullable ListTag listtag) {
        ArrayList list = Lists.newArrayList();
        list.add(Pair.of((Object)BuiltInRegistries.f_256878_.m_246971_(BannerPatterns.f_222726_), (Object)color));
        if (listtag == null) {
            return list;
        }
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compound = listtag.m_128728_(i);
            Holder holder = BannerPattern.m_222700_((String)compound.m_128461_("Pattern"));
            if (holder == null) continue;
            int j = compound.m_128451_("Color");
            list.add(Pair.of((Object)holder, (Object)DyeColor.m_41053_((int)j)));
        }
        return list;
    }

    public static void removeLastPattern(ItemStack stack) {
        CompoundTag compound = BlockItem.m_186336_((ItemStack)stack);
        if (compound != null && compound.m_128425_("Patterns", 9)) {
            ListTag listtag = compound.m_128437_("Patterns", 10);
            if (listtag.isEmpty()) {
                return;
            }
            listtag.remove(listtag.size() - 1);
            if (listtag.isEmpty()) {
                compound.m_128473_("Patterns");
            }
            BlockItem.m_186338_((ItemStack)stack, (BlockEntityType)((BlockEntityType)ModBlockEntityTypes.PAVISE.get()), (CompoundTag)compound);
        }
    }

    public ItemStack getItem() {
        ItemStack stack = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation("magistuarmory", this.shieldId)));
        stack.m_41751_(this.stackCompound.m_6426_());
        return stack;
    }

    public DyeColor getBaseColor() {
        return this.baseColor;
    }

    public String getShieldId() {
        return this.shieldId;
    }
}

