/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.cobweb.api.item;

import it.crystalnest.cobweb.platform.Services;
import java.util.Collection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TierUtils {
    public static final String NO_TIER_REFERENCE = "none";
    public static final Tier NO_TIER = new Tier(){

        public int m_6609_() {
            return -1;
        }

        public float m_6624_() {
            return -1.0f;
        }

        public float m_6631_() {
            return -1.0f;
        }

        public int m_6604_() {
            return -1;
        }

        public int m_6601_() {
            return -1;
        }

        @NotNull
        public Ingredient m_6282_() {
            return Ingredient.f_43901_;
        }
    };

    private TierUtils() {
    }

    public static Collection<Tier> getAllTiers() {
        return Services.TOOL_TIERS.getAllTiers();
    }

    @Nullable
    public static Tier getTier(ResourceLocation reference) {
        return Services.TOOL_TIERS.getTier(reference);
    }

    @Nullable
    public static Tier getTier(String reference) {
        return Services.TOOL_TIERS.getTier(reference);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int compare(Item item1, Item item2) {
        if (!(item1 instanceof TieredItem)) return 0;
        TieredItem tiered1 = (TieredItem)item1;
        if (!(item2 instanceof TieredItem)) return 0;
        TieredItem tiered2 = (TieredItem)item2;
        int n = TierUtils.compare(tiered1, tiered2);
        return n;
    }

    public static int compare(TieredItem item1, TieredItem item2) {
        return TierUtils.compare(item1.m_43314_(), item2.m_43314_());
    }

    public static int compare(Tier tier1, Tier tier2) {
        return Services.TOOL_TIERS.compare(tier1, tier2);
    }

    public static int compare(ResourceLocation reference1, ResourceLocation reference2) {
        return TierUtils.compare(TierUtils.getTier(reference1), TierUtils.getTier(reference2));
    }

    public static int compare(String reference1, String reference2) {
        return TierUtils.compare(TierUtils.getTier(reference1), TierUtils.getTier(reference2));
    }

    public static boolean isIn(Collection<Tier> tiers, Tier tier) {
        return TierUtils.isIn(tiers, tier.toString());
    }

    public static boolean isIn(Collection<Tier> tiers, ResourceLocation reference) {
        return TierUtils.isIn(tiers, reference.toString());
    }

    public static boolean isIn(Collection<Tier> tiers, String reference) {
        return tiers.stream().anyMatch(tier -> TierUtils.matches(tier, reference));
    }

    public static int getLevel(Item item) {
        int n;
        if (item instanceof TieredItem) {
            TieredItem tiered = (TieredItem)item;
            n = TierUtils.getLevel(tiered);
        } else {
            n = NO_TIER.m_6604_();
        }
        return n;
    }

    public static int getLevel(TieredItem item) {
        return TierUtils.getLevel(item.m_43314_());
    }

    public static int getLevel(@Nullable Tier tier) {
        return Services.TOOL_TIERS.getLevel(tier);
    }

    public static int getLevel(ResourceLocation reference) {
        return TierUtils.getLevel(Services.TOOL_TIERS.getTier(reference));
    }

    public static int getLevel(String reference) {
        return TierUtils.getLevel(Services.TOOL_TIERS.getTier(reference));
    }

    public static boolean matches(Tier tier, String reference) {
        return Services.TOOL_TIERS.matches(tier, reference);
    }
}

