/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.networking;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IAEPowerStorage;
import appeng.api.networking.events.GridPowerStorageStateChanged;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.util.AECableType;
import appeng.block.networking.EnergyCellBlock;
import appeng.blockentity.grid.AENetworkBlockEntity;
import appeng.me.energy.StoredEnergyAmount;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import org.jetbrains.annotations.Nullable;

public class EnergyCellBlockEntity
extends AENetworkBlockEntity
implements IAEPowerStorage,
IGridTickable {
    private final StoredEnergyAmount stored;
    private byte currentDisplayLevel;
    private boolean neighborChangePending;

    public EnergyCellBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
        this.getMainNode().setIdlePowerUsage(0.0).addService(IAEPowerStorage.class, this).addService(IGridTickable.class, this);
        EnergyCellBlock cellBlock = (EnergyCellBlock)this.m_58900_().m_60734_();
        this.stored = new StoredEnergyAmount(0.0, cellBlock.getMaxPower(), this::emitPowerEvent);
    }

    @Override
    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.COVERED;
    }

    @Override
    public void onReady() {
        super.onReady();
        int value = (Integer)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)EnergyCellBlock.ENERGY_STORAGE);
        this.currentDisplayLevel = (byte)value;
        this.updateStateForPowerLevel();
    }

    public static int getStorageLevelFromFillFactor(double fillFactor) {
        return (int)Math.floor(4.0 * Mth.m_14008_((double)(fillFactor + 0.01), (double)0.0, (double)1.0));
    }

    private void updateStateForPowerLevel() {
        if (this.m_58901_()) {
            return;
        }
        int storageLevel = EnergyCellBlockEntity.getStorageLevelFromFillFactor(this.stored.getAmount() / this.stored.getMaximum());
        if (this.currentDisplayLevel != storageLevel) {
            this.currentDisplayLevel = (byte)storageLevel;
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)EnergyCellBlock.ENERGY_STORAGE, (Comparable)Integer.valueOf(storageLevel)));
        }
    }

    private void setChangedNoTicketUpdate() {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            throw new IllegalArgumentException("Expected server level, not " + String.valueOf(this.f_58857_));
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos pos = this.m_58899_();
        ChunkAccess chunk = serverLevel.m_7726_().m_7587_(SectionPos.m_123171_((int)pos.m_123341_()), SectionPos.m_123171_((int)pos.m_123343_()), ChunkStatus.f_62326_, false);
        if (chunk != null) {
            chunk.m_8092_(true);
        }
    }

    private void onAmountChanged() {
        this.setChangedNoTicketUpdate();
        if (!this.neighborChangePending) {
            this.neighborChangePending = true;
            this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().alertDevice((IGridNode)node));
        }
    }

    @Override
    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        data.m_128347_("internalCurrentPower", this.stored.getAmount());
        data.m_128379_("neighborChangePending", this.neighborChangePending);
    }

    @Override
    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        this.stored.setStored(data.m_128459_("internalCurrentPower"));
        this.neighborChangePending = data.m_128471_("neighborChangePending");
    }

    @Override
    public void importSettings(SettingsFrom mode, CompoundTag input, @Nullable Player player) {
        super.importSettings(mode, input, player);
        if (mode == SettingsFrom.DISMANTLE_ITEM) {
            this.stored.setStored(input.m_128459_("internalCurrentPower"));
        }
    }

    @Override
    public void exportSettings(SettingsFrom from, CompoundTag data, @Nullable Player player) {
        super.exportSettings(from, data, player);
        if (from == SettingsFrom.DISMANTLE_ITEM && this.stored.getAmount() > 0.0) {
            data.m_128347_("internalCurrentPower", this.stored.getAmount());
            data.m_128347_("internalMaxPower", this.stored.getMaximum());
        }
    }

    @Override
    public final double injectAEPower(double amt, Actionable mode) {
        double inserted = this.stored.insert(amt, mode == Actionable.MODULATE);
        if (mode == Actionable.MODULATE && inserted > 0.0) {
            this.onAmountChanged();
        }
        return amt - inserted;
    }

    @Override
    public final double extractAEPower(double amt, Actionable mode, PowerMultiplier pm) {
        return pm.divide(this.extractAEPower(pm.multiply(amt), mode));
    }

    private double extractAEPower(double amt, Actionable mode) {
        double extracted = this.stored.extract(amt, mode == Actionable.MODULATE);
        if (mode == Actionable.MODULATE && extracted > 0.0) {
            this.onAmountChanged();
        }
        return extracted;
    }

    @Override
    public double getAEMaxPower() {
        return this.stored.getMaximum();
    }

    @Override
    public double getAECurrentPower() {
        return this.stored.getAmount();
    }

    @Override
    public boolean isAEPublicPowerStorage() {
        return true;
    }

    @Override
    public AccessRestriction getPowerFlow() {
        return AccessRestriction.READ_WRITE;
    }

    @Override
    public int getPriority() {
        return ((EnergyCellBlock)this.m_58900_().m_60734_()).getPriority();
    }

    private void emitPowerEvent(GridPowerStorageStateChanged.PowerEventType type) {
        this.getMainNode().ifPresent(grid -> grid.postEvent(new GridPowerStorageStateChanged(this, type)));
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(1, 20, !this.neighborChangePending, true);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (Platform.areBlockEntitiesTicking(this.m_58904_(), this.m_58899_())) {
            if (this.neighborChangePending) {
                this.neighborChangePending = false;
                this.m_6596_();
                this.updateStateForPowerLevel();
            }
            return TickRateModulation.SLEEP;
        }
        return TickRateModulation.IDLE;
    }
}

