/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaksitems.entity;

import de.markusbordihn.adaptiveperformancetweakscore.CoreConstants;
import de.markusbordihn.adaptiveperformancetweakscore.entity.CoreItemEntityManager;
import de.markusbordihn.adaptiveperformancetweakscore.message.WarnMessages;
import de.markusbordihn.adaptiveperformancetweakscore.server.OptimizationEvent;
import de.markusbordihn.adaptiveperformancetweakscore.server.ServerLoadEvent;
import de.markusbordihn.adaptiveperformancetweaksitems.config.CommonConfig;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class ItemEntityManager {
    protected static final Logger log = LogManager.getLogger((String)"APTweaks(Items)");
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static final short VERIFICATION_TICK = 600;
    private static Map<String, Set<ItemEntity>> itemTypeEntityMap = new ConcurrentHashMap<String, Set<ItemEntity>>();
    private static Map<String, Set<ItemEntity>> itemWorldEntityMap = new ConcurrentHashMap<String, Set<ItemEntity>>();
    private static List<String> itemsAllowList = new ArrayList<String>();
    private static List<String> itemsDenyList = new ArrayList<String>();
    private static boolean hasHighServerLoad = false;
    private static boolean needsOptimization = false;
    private static boolean hasItemsAllowList = false;
    private static boolean hasItemsDenyList = false;
    private static short ticks = 0;

    protected ItemEntityManager() {
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        itemTypeEntityMap = new ConcurrentHashMap<String, Set<ItemEntity>>();
        itemWorldEntityMap = new ConcurrentHashMap<String, Set<ItemEntity>>();
        itemsAllowList = (List)ItemEntityManager.COMMON.itemsAllowList.get();
        itemsDenyList = (List)ItemEntityManager.COMMON.itemsDenyList.get();
        hasItemsAllowList = !itemsAllowList.isEmpty();
        boolean bl = hasItemsDenyList = !itemsDenyList.isEmpty();
        if (Boolean.TRUE.equals(ItemEntityManager.COMMON.optimizeItems.get())) {
            if ((Integer)ItemEntityManager.COMMON.maxNumberOfItems.get() < (Integer)ItemEntityManager.COMMON.maxNumberOfItemsPerType.get()) {
                log.error("Max number of {} items could not be lower than max. number of {} items per type!", ItemEntityManager.COMMON.maxNumberOfItems.get(), ItemEntityManager.COMMON.maxNumberOfItemsPerType.get());
                ItemEntityManager.COMMON.maxNumberOfItems.set((Object)((Integer)ItemEntityManager.COMMON.maxNumberOfItemsPerType.get() * 2));
            }
            log.info("Max number of Items allowed per world: {} / per type: {}", ItemEntityManager.COMMON.maxNumberOfItems.get(), ItemEntityManager.COMMON.maxNumberOfItemsPerType.get());
            log.info("Enable clustering of items with a radius of {} blocks.", ItemEntityManager.COMMON.itemsClusterRange.get());
            if (hasItemsAllowList) {
                log.info("Optimize only items from allow list: {}", itemsAllowList);
            } else if (hasItemsDenyList) {
                log.info("Optimize all items except from deny list: {}", itemsDenyList);
            }
            if (CoreConstants.GET_IT_TOGETHER_LOADED) {
                log.warn(() -> WarnMessages.conflictingFeaturesModWarning((String)"Get It Together, Drops!", (String)"clusters items in a specific radius"));
            }
        } else {
            log.info("Item Optimization is disabled!");
        }
    }

    @SubscribeEvent
    public static void handleClientServerTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            short s = ticks;
            ticks = (short)(s + 1);
            if (s >= 600) {
                ItemEntityManager.verifyEntities();
                ticks = 0;
            }
        }
    }

    @SubscribeEvent
    public static void handleServerLoadEvent(ServerLoadEvent event) {
        hasHighServerLoad = event.hasHighServerLoad();
        if (hasHighServerLoad) {
            needsOptimization = true;
        }
    }

    @SubscribeEvent
    public static void handleOptimizationEvent(OptimizationEvent event) {
        if (needsOptimization) {
            if (Boolean.TRUE.equals(ItemEntityManager.COMMON.optimizeItems.get())) {
                ItemEntityManager.optimizeItems();
            }
            needsOptimization = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void handleItemEntityJoinLevelEvent(EntityJoinLevelEvent event) {
        int numberOfItemEntities;
        int numberOfItemWorldEntities;
        ItemStack itemStack;
        ItemEntity itemEntity;
        Level level;
        block16: {
            block15: {
                level = event.getLevel();
                if (level.f_46443_ || event.isCanceled()) {
                    return;
                }
                Entity entity = event.getEntity();
                if (!(entity instanceof ItemEntity)) break block15;
                itemEntity = (ItemEntity)entity;
                if (!entity.m_213877_()) break block16;
            }
            return;
        }
        if (!CoreItemEntityManager.isRelevantItemEntity((ItemEntity)itemEntity)) {
            return;
        }
        String itemName = itemEntity.m_32055_().m_41720_().m_5524_();
        if (itemName == null) {
            itemName = itemEntity.m_20078_();
        }
        if (hasItemsAllowList && !itemsAllowList.contains(itemName)) {
            log.debug("[Item Allow List] {} is not on the allow list!", (Object)itemName);
            return;
        }
        if (hasItemsDenyList && itemsDenyList.contains(itemName)) {
            log.debug("[Item Deny List] {} will not be optimized!", (Object)itemName);
            return;
        }
        String levelName = level.m_46472_().m_135782_().toString();
        if (log.isDebugEnabled()) {
            log.debug("[Item joined {}] {} {}", (Object)levelName, (Object)itemName, (Object)itemEntity.m_5446_().getString());
        }
        String itemTypeEntityMapKey = "[" + levelName + "]" + itemName;
        itemTypeEntityMap.computeIfAbsent(itemTypeEntityMapKey, k -> new LinkedHashSet());
        Set<ItemEntity> itemTypeEntities = itemTypeEntityMap.get(itemTypeEntityMapKey);
        if (Boolean.TRUE.equals(ItemEntityManager.COMMON.optimizeItems.get()) && (itemStack = itemEntity.m_32055_()) != null && itemStack.m_41753_() && itemStack.m_41613_() < itemStack.m_41741_() && itemStack.m_41741_() > 1) {
            int x = (int)itemEntity.m_20185_();
            int y = (int)itemEntity.m_20186_();
            int z = (int)itemEntity.m_20189_();
            int itemsClusterRange = (Integer)ItemEntityManager.COMMON.itemsClusterRange.get();
            boolean itemCanSeeSky = level.m_45527_(itemEntity.m_20183_());
            int xStart = x - itemsClusterRange;
            int yStart = y - itemsClusterRange;
            int zStart = z - itemsClusterRange;
            int xEnd = x + itemsClusterRange;
            int yEnd = y + itemsClusterRange;
            int zEnd = z + itemsClusterRange;
            HashSet<ItemEntity> itemEntities = new HashSet<ItemEntity>(itemTypeEntities);
            for (ItemEntity existingItemEntity : itemEntities) {
                int xSub = (int)existingItemEntity.m_20185_();
                int ySub = (int)existingItemEntity.m_20186_();
                int zSub = (int)existingItemEntity.m_20189_();
                boolean existingItemCanSeeSky = level.m_45527_(existingItemEntity.m_20183_());
                ItemStack existingItemStack = existingItemEntity.m_32055_();
                if (itemEntity.m_19879_() == existingItemEntity.m_19879_() || !existingItemEntity.m_6084_() || !ItemEntity.m_32026_((ItemStack)itemStack, (ItemStack)existingItemStack) || xStart >= xSub || xSub >= xEnd || (!itemCanSeeSky || !existingItemCanSeeSky) && (yStart >= ySub || ySub >= yEnd) || zStart >= zSub || zSub >= zEnd) continue;
                if (log.isDebugEnabled()) {
                    int newItemCount = existingItemStack.m_41613_() + itemStack.m_41613_();
                    log.debug("[Merge Item] {} + {} = {} items", (Object)itemEntity, (Object)existingItemEntity, (Object)newItemCount);
                }
                ItemStack combinedItemStack = ItemEntity.m_32029_((ItemStack)existingItemStack, (ItemStack)itemStack, (int)64);
                existingItemEntity.m_32045_(combinedItemStack);
                return;
            }
        }
        itemWorldEntityMap.computeIfAbsent(levelName, k -> new LinkedHashSet());
        Set<ItemEntity> itemWorldEntities = itemWorldEntityMap.get(levelName);
        itemWorldEntities.add(itemEntity);
        if (Boolean.TRUE.equals(ItemEntityManager.COMMON.optimizeItems.get()) && (numberOfItemWorldEntities = itemWorldEntities.size()) > (Integer)ItemEntityManager.COMMON.maxNumberOfItems.get()) {
            ItemEntity firstItemWorldEntity = itemWorldEntities.iterator().next();
            log.debug("[Item World Limit {} exceeded {}] Removing item {}", ItemEntityManager.COMMON.maxNumberOfItems.get(), (Object)numberOfItemWorldEntities, (Object)firstItemWorldEntity);
            firstItemWorldEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            itemWorldEntities.remove(firstItemWorldEntity);
            itemTypeEntities.remove(firstItemWorldEntity);
        }
        itemTypeEntities.add(itemEntity);
        if (Boolean.TRUE.equals(ItemEntityManager.COMMON.optimizeItems.get()) && (numberOfItemEntities = itemTypeEntities.size()) > (Integer)ItemEntityManager.COMMON.maxNumberOfItemsPerType.get()) {
            ItemEntity firstItemEntity = itemTypeEntities.iterator().next();
            log.debug("[Item Type Limit {} exceeded {}] Removing item {}", ItemEntityManager.COMMON.maxNumberOfItemsPerType.get(), (Object)numberOfItemEntities, (Object)firstItemEntity);
            firstItemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            itemTypeEntities.remove(firstItemEntity);
            itemWorldEntities.remove(firstItemEntity);
        }
        if (Boolean.TRUE.equals((Boolean)ItemEntityManager.COMMON.optimizeItems.get() != false && hasHighServerLoad) && itemEntity.lifespan > 1) {
            itemEntity.lifespan = (int)Math.round((double)itemEntity.lifespan * 0.6);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void handleItemEntityLeaveLevelEvent(EntityLeaveLevelEvent event) {
        String itemTypeKey;
        Set<ItemEntity> itemTypeEntities;
        Level level = event.getLevel();
        if (level.f_46443_) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof ItemEntity)) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entity;
        if (!CoreItemEntityManager.isRelevantItemEntity((ItemEntity)itemEntity)) {
            return;
        }
        String itemName = itemEntity.m_32055_().m_41720_().m_5524_();
        if (itemName == null) {
            itemName = itemEntity.m_20078_();
        }
        if (hasItemsAllowList && !itemsAllowList.contains(itemName)) {
            return;
        }
        if (hasItemsDenyList && itemsDenyList.contains(itemName)) {
            return;
        }
        String levelName = level.m_46472_().m_135782_().toString();
        Set<ItemEntity> itemWorldEntities = itemWorldEntityMap.get(levelName);
        if (itemWorldEntities != null) {
            itemWorldEntities.remove(itemEntity);
            if (itemWorldEntities.isEmpty()) {
                itemWorldEntityMap.remove(levelName);
            }
        }
        if ((itemTypeEntities = itemTypeEntityMap.get(itemTypeKey = "[" + levelName + "]" + itemName)) != null) {
            itemTypeEntities.remove(itemEntity);
            if (itemTypeEntities.isEmpty()) {
                itemTypeEntityMap.remove(itemTypeKey);
            }
            if (log.isDebugEnabled()) {
                log.debug("[Item leaved {}] {} {}.", (Object)levelName, (Object)itemName, (Object)itemEntity.m_5446_().getString());
            }
        } else {
            log.warn("Item {} {} in {} was not tracked by item entity manager!", (Object)itemName, (Object)itemEntity.m_5446_().getString(), (Object)levelName);
        }
    }

    public static int optimizeItems() {
        String levelName;
        log.debug("[Optimize Items] Received request to optimize items ...");
        int numberOfRemovedItems = 0;
        int maxNumberOfOptimizedWorldItems = (int)Math.round((double)((Integer)ItemEntityManager.COMMON.maxNumberOfItems.get()).intValue() * 0.9);
        for (Map.Entry<String, Set<ItemEntity>> itemWorldEntities : itemWorldEntityMap.entrySet()) {
            Set<ItemEntity> itemWorldEntitiesValues = itemWorldEntities.getValue();
            if (itemWorldEntitiesValues.size() <= maxNumberOfOptimizedWorldItems) continue;
            List<ItemEntity> sortedItemWorldEntitiesValues = itemWorldEntitiesValues.stream().sorted(Comparator.comparing(Entity::m_19879_)).toList();
            ArrayList<ItemEntity> itemsToRemove = new ArrayList<ItemEntity>();
            for (int i = 0; i < sortedItemWorldEntitiesValues.size() - maxNumberOfOptimizedWorldItems; ++i) {
                ItemEntity itemEntity = sortedItemWorldEntitiesValues.get(i);
                if (!itemEntity.isAddedToWorld()) continue;
                itemsToRemove.add(itemEntity);
            }
            for (ItemEntity itemEntity : itemsToRemove) {
                itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
                itemWorldEntitiesValues.remove(itemEntity);
                ResourceLocation itemRegistryName = ForgeRegistries.ITEMS.getKey((Object)itemEntity.m_32055_().m_41720_());
                String itemName = itemRegistryName != null ? itemRegistryName.toString() : itemEntity.m_20078_();
                levelName = itemWorldEntities.getKey();
                String itemTypeKey = "[" + levelName + "]" + itemName;
                Set<ItemEntity> typeEntities = itemTypeEntityMap.get(itemTypeKey);
                if (typeEntities != null) {
                    typeEntities.remove(itemEntity);
                }
                ++numberOfRemovedItems;
            }
        }
        int maxNumberOfOptimizedTypeItems = (int)Math.round((double)((Integer)ItemEntityManager.COMMON.maxNumberOfItemsPerType.get()).intValue() * 0.9);
        for (Map.Entry<String, Set<ItemEntity>> itemTypeEntities : itemTypeEntityMap.entrySet()) {
            Set<ItemEntity> itemTypeEntitiesValues = itemTypeEntities.getValue();
            if (itemTypeEntitiesValues.size() <= maxNumberOfOptimizedTypeItems) continue;
            List<ItemEntity> sortedItemTypeEntitiesValues = itemTypeEntitiesValues.stream().sorted(Comparator.comparing(Entity::m_19879_)).toList();
            ArrayList<ItemEntity> itemsToRemove = new ArrayList<ItemEntity>();
            for (int i = 0; i < sortedItemTypeEntitiesValues.size() - maxNumberOfOptimizedTypeItems; ++i) {
                ItemEntity itemEntity = sortedItemTypeEntitiesValues.get(i);
                if (!itemEntity.isAddedToWorld()) continue;
                itemsToRemove.add(itemEntity);
            }
            for (ItemEntity itemEntity : itemsToRemove) {
                itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
                itemTypeEntitiesValues.remove(itemEntity);
                String typeKey = itemTypeEntities.getKey();
                levelName = typeKey.substring(1, typeKey.indexOf(93));
                Set<ItemEntity> worldEntities = itemWorldEntityMap.get(levelName);
                if (worldEntities != null) {
                    worldEntities.remove(itemEntity);
                }
                ++numberOfRemovedItems;
            }
        }
        if (numberOfRemovedItems > 0) {
            log.debug("[Optimized Items] Removed {} items from all worlds!", (Object)numberOfRemovedItems);
        } else {
            log.debug("[Optimized Items] Found no relevant items which should be removed!");
        }
        return numberOfRemovedItems;
    }

    public static Map<String, Set<ItemEntity>> getItemTypeEntityMap() {
        return itemTypeEntityMap;
    }

    public static void verifyEntities() {
        int removedEntries = 0;
        int removedEmptySets = 0;
        Iterator<Map.Entry<String, Set<ItemEntity>>> typeMapIterator = itemTypeEntityMap.entrySet().iterator();
        while (typeMapIterator.hasNext()) {
            Map.Entry<String, Set<ItemEntity>> entry = typeMapIterator.next();
            Set<ItemEntity> entities = entry.getValue();
            Iterator<ItemEntity> entityIterator = entities.iterator();
            while (entityIterator.hasNext()) {
                Entity entity = (Entity)entityIterator.next();
                if (entity == null || !entity.m_213877_()) continue;
                entityIterator.remove();
                ++removedEntries;
            }
            if (!entities.isEmpty()) continue;
            typeMapIterator.remove();
            ++removedEmptySets;
        }
        Iterator<Map.Entry<String, Set<ItemEntity>>> worldMapIterator = itemWorldEntityMap.entrySet().iterator();
        while (worldMapIterator.hasNext()) {
            Map.Entry<String, Set<ItemEntity>> entry = worldMapIterator.next();
            Set<ItemEntity> entities = entry.getValue();
            Iterator<ItemEntity> entityIterator = entities.iterator();
            while (entityIterator.hasNext()) {
                Entity entity = (Entity)entityIterator.next();
                if (entity == null || !entity.m_213877_()) continue;
                entityIterator.remove();
                ++removedEntries;
            }
            if (!entities.isEmpty()) continue;
            worldMapIterator.remove();
            ++removedEmptySets;
        }
        if (removedEntries > 0 || removedEmptySets > 0) {
            log.debug("[Verification] Removed {} entries and {} empty sets", (Object)removedEntries, (Object)removedEmptySets);
        }
    }
}

