/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaksitems.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.markusbordihn.adaptiveperformancetweakscore.commands.CustomCommand;
import de.markusbordihn.adaptiveperformancetweaksitems.entity.ItemEntityManager;
import java.util.Map;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.world.entity.item.ItemEntity;

public class ItemsCommand
extends CustomCommand {
    private static final ItemsCommand command = new ItemsCommand();

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"items").requires(cs -> cs.m_6761_(2))).executes((Command)command)).then(Commands.m_82127_((String)"optimize").executes(command::runOptimize));
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Map<String, Set<ItemEntity>> itemTypeEntityMap = ItemEntityManager.getItemTypeEntityMap();
        if (itemTypeEntityMap.isEmpty()) {
            ItemsCommand.sendFeedback(context, (String)"Unable to find any items entity. World is not loaded or nor items dropped?");
        } else {
            ItemsCommand.sendFeedback(context, (String)String.format("Items Overview (%s types)\n===", itemTypeEntityMap.size()));
            for (Map.Entry<String, Set<ItemEntity>> itemEntities : itemTypeEntityMap.entrySet()) {
                int numOfItems = itemEntities.getValue().size();
                if (numOfItems <= 0) continue;
                ItemsCommand.sendFeedback(context, (String)String.format("\u25cb %s %s", itemEntities.getKey(), numOfItems));
            }
        }
        return 0;
    }

    public int runOptimize(CommandContext<CommandSourceStack> context) {
        ItemsCommand.sendFeedback(context, (String)"Running manual Item Optimization ...");
        int numberOfRemovedItems = ItemEntityManager.optimizeItems();
        if (numberOfRemovedItems > 0) {
            ItemsCommand.sendFeedback(context, (String)String.format("Removed items %s from all worlds!", numberOfRemovedItems));
        } else {
            ItemsCommand.sendFeedback(context, (String)"Optimization was not needed!");
        }
        return 0;
    }
}

