/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.init;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.BOPFluids;
import biomesoplenty.common.block.BloodFluid;
import biomesoplenty.core.BiomesOPlenty;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidInteractionRegistry;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ModFluids {
    public static void setup() {
        ModFluids.registerFluids();
    }

    public static void registerFluids() {
        BOPFluids.FLOWING_BLOOD = ModFluids.registerFluid(() -> new BloodFluid.Flowing(), "flowing_blood");
        BOPFluids.BLOOD = ModFluids.registerFluid(() -> new BloodFluid.Source(), "blood");
        BOPFluids.BLOOD_TYPE = ModFluids.registerFluidType(() -> new FluidType(FluidType.Properties.create().descriptionId("block.biomesoplenty.blood").fallDistanceModifier(0.0f).canExtinguish(true).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.f_11937_).density(3000).viscosity(6000)){

            @Nullable
            public BlockPathTypes getBlockPathType(FluidState state, BlockGetter level, BlockPos pos, @Nullable Mob mob, boolean canFluidLog) {
                return canFluidLog ? super.getBlockPathType(state, level, pos, mob, true) : null;
            }

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(new IClientFluidTypeExtensions(){
                    private static final ResourceLocation BLOOD_UNDERWATER = new ResourceLocation("biomesoplenty:textures/block/blood_underwater.png");
                    private static final ResourceLocation BLOOD_STILL = new ResourceLocation("biomesoplenty:block/blood_still");
                    private static final ResourceLocation BLOOD_FLOW = new ResourceLocation("biomesoplenty:block/blood_flow");

                    public ResourceLocation getStillTexture() {
                        return BLOOD_STILL;
                    }

                    public ResourceLocation getFlowingTexture() {
                        return BLOOD_FLOW;
                    }

                    public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                        return BLOOD_UNDERWATER;
                    }

                    public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                        return new Vector3f(0.407f, 0.121f, 0.137f);
                    }

                    public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                        RenderSystem.setShaderFogStart((float)0.125f);
                        RenderSystem.setShaderFogEnd((float)1.5f);
                    }
                });
            }
        }, "blood");
    }

    public static RegistryObject<Fluid> registerFluid(Supplier<Fluid> fluidSupplier, String name) {
        return BiomesOPlenty.FLUID_REGISTER.register(name, fluidSupplier);
    }

    public static RegistryObject<FluidType> registerFluidType(Supplier<FluidType> fluidSupplier, String name) {
        return BiomesOPlenty.FORGE_FLUID_REGISTER.register(name, fluidSupplier);
    }

    public static void registerFluidInteractions() {
        for (Map.Entry fluidType : ((IForgeRegistry)ForgeRegistries.FLUID_TYPES.get()).getEntries()) {
            if (fluidType.getValue() == ForgeMod.EMPTY_TYPE.get() || fluidType.getValue() == BOPFluids.BLOOD_TYPE.get()) continue;
            FluidInteractionRegistry.addInteraction((FluidType)((FluidType)fluidType.getValue()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)BOPFluids.BLOOD_TYPE.get(), fluidState -> fluidState.m_76170_() ? ((Block)BOPBlocks.FLESH.get()).m_49966_() : ((Block)BOPBlocks.POROUS_FLESH.get()).m_49966_()));
        }
    }
}

