/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.net;

import com.lothrazar.cyclic.capabilities.ClientDataManager;
import com.lothrazar.cyclic.capabilities.chunk.ChunkDataStorage;
import com.lothrazar.cyclic.capabilities.player.PlayerCapabilityStorage;
import com.lothrazar.library.packet.PacketFlib;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class PacketSyncManaToClient
extends PacketFlib {
    private int playerMana;
    private int chunkMana;

    public PacketSyncManaToClient(PlayerCapabilityStorage playerMana, ChunkDataStorage chunkMana) {
        this.playerMana = playerMana.getMana();
        this.chunkMana = chunkMana.getMana();
    }

    public static void handle(PacketSyncManaToClient message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientDataManager.set(message.playerMana, message.chunkMana));
        message.done(ctx);
    }

    public static PacketSyncManaToClient decode(FriendlyByteBuf buf) {
        return new PacketSyncManaToClient(new PlayerCapabilityStorage(buf.readInt()), new ChunkDataStorage(buf.readInt()));
    }

    public static void encode(PacketSyncManaToClient msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.playerMana);
        buf.writeInt(msg.chunkMana);
    }
}

